/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.intellij.plugins.relaxNG.inspections.RngDomInspection;
import org.intellij.plugins.relaxNG.inspections.UnusedDefineInspection;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.intellij.plugins.relaxNG.validation.ValidateAction;
import org.intellij.plugins.relaxNG.xml.dom.RngDefine;
import org.intellij.plugins.relaxNG.xml.dom.impl.RngDefineMetaData;

public class ApplicationLoader
implements ApplicationComponent {
    private static final String RNG_EXT = "rng";
    private static final String VALIDATE_XML = "ValidateXml";
    public static final String RNG_NAMESPACE = "http://relaxng.org/ns/structure/1.0";

    public void initComponent() {
        ApplicationLoader.registerMetaData();
        ApplicationLoader.installValidateXmlAction();
    }

    private static void installValidateXmlAction() {
        ActionManager mgr = ActionManager.getInstance();
        AnAction validateAction = mgr.getAction(VALIDATE_XML);
        mgr.unregisterAction(VALIDATE_XML);
        mgr.registerAction(VALIDATE_XML, (AnAction)new ValidateAction(validateAction));
    }

    private static void registerMetaData() {
        MetaDataRegistrar registrar = MetaDataRegistrar.getInstance();
        registrar.registerMetaData((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(new String[]{RNG_NAMESPACE}), (ElementFilter)new ClassFilter(XmlDocument.class)), RngNsDescriptor.class);
        registrar.registerMetaData((ElementFilter)new ClassFilter(RncDocument.class), RngNsDescriptor.class);
        registrar.registerMetaData(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (element instanceof XmlTag) {
                    XmlTag tag = (XmlTag)element;
                    DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
                    return domElement instanceof RngDefine;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return XmlTag.class.isAssignableFrom(hintClass);
            }
        }, RngDefineMetaData.class);
    }

    public static Class[] getInspectionClasses() {
        return new Class[]{RngDomInspection.class, UnusedDefineInspection.class};
    }

    public static class ResourceProvider
    implements StandardResourceProvider {
        public void registerResources(ResourceRegistrar registrar) {
            registrar.addStdResource(ApplicationLoader.RNG_NAMESPACE, "/resources/relaxng.rng", this.getClass());
            registrar.addIgnoredResource("http://relaxng.org/ns/compatibility/annotations/1.0");
        }
    }
}

