/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableRectValue
extends AnimatableValue {
    protected float x;
    protected float y;
    protected float width;
    protected float height;

    protected AnimatableRectValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableRectValue(AnimationTarget animationTarget, float f, float f2, float f3, float f4) {
        super(animationTarget);
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableRectValue animatableRectValue;
        AnimatableRectValue animatableRectValue2 = animatableValue == null ? new AnimatableRectValue(this.target) : (AnimatableRectValue)animatableValue;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        if (animatableValue2 != null) {
            animatableRectValue = (AnimatableRectValue)animatableValue2;
            f2 += f * (animatableRectValue.x - this.x);
            f3 += f * (animatableRectValue.y - this.y);
            f4 += f * (animatableRectValue.width - this.width);
            f5 += f * (animatableRectValue.height - this.height);
        }
        if (animatableValue3 != null && n != 0) {
            animatableRectValue = (AnimatableRectValue)animatableValue3;
            f2 += (float)n * animatableRectValue.x;
            f3 += (float)n * animatableRectValue.y;
            f4 += (float)n * animatableRectValue.width;
            f5 += (float)n * animatableRectValue.height;
        }
        if (animatableRectValue2.x != f2 || animatableRectValue2.y != f3 || animatableRectValue2.width != f4 || animatableRectValue2.height != f5) {
            animatableRectValue2.x = f2;
            animatableRectValue2.y = f3;
            animatableRectValue2.width = f4;
            animatableRectValue2.height = f5;
            animatableRectValue2.hasChanged = true;
        }
        return animatableRectValue2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableRectValue(this.target, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public String toStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.x);
        stringBuffer.append(',');
        stringBuffer.append(this.y);
        stringBuffer.append(',');
        stringBuffer.append(this.width);
        stringBuffer.append(',');
        stringBuffer.append(this.height);
        return stringBuffer.toString();
    }
}

