/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;

public class SVGConverterFileSource
implements SVGConverterSource {
    File file;
    String ref;

    public SVGConverterFileSource(File file) {
        this.file = file;
    }

    public SVGConverterFileSource(File file, String string) {
        this.file = file;
        this.ref = string;
    }

    @Override
    public String getName() {
        String string = this.file.getName();
        if (this.ref != null && !"".equals(this.ref)) {
            string = string + '#' + this.ref;
        }
        return string;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getURI() {
        try {
            String string = this.file.toURL().toString();
            if (this.ref != null && !"".equals(this.ref)) {
                string = string + '#' + this.ref;
            }
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SVGConverterFileSource)) {
            return false;
        }
        return this.file.equals(((SVGConverterFileSource)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public InputStream openStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isSameAs(String string) {
        return this.file.toString().equals(string);
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }
}

