/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.progress.sending;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.ICvsFilesVisitor;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.IRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.AbstractFileStateRequest;
import org.netbeans.lib.cvsclient.request.IRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public class FileStateRequestsProgressHandler
implements IRequestsProgressHandler {
    private final Set fileObjects = new HashSet(2000);
    private final IProgressViewer progressViewer;
    private int count;
    private final int maxCount;

    public static IRequestsProgressHandler create(IProgressViewer parentProgressViewer, ICvsFiles cvsFiles) {
        return new FileStateRequestsProgressHandler(new RangeProgressViewer(parentProgressViewer, 0.0, 0.5), cvsFiles);
    }

    public FileStateRequestsProgressHandler(IProgressViewer progressViewer, ICvsFiles cvsFiles) {
        BugLog.getInstance().assertNotNull(progressViewer);
        BugLog.getInstance().assertNotNull(cvsFiles);
        this.progressViewer = progressViewer;
        cvsFiles.visit(new ICvsFilesVisitor(){

            @Override
            public void handleFile(FileObject fileObject, Entry entry, boolean exists) {
                FileStateRequestsProgressHandler.this.fileObjects.add(fileObject);
            }

            @Override
            public void handleDirectory(DirectoryObject directoryObject) {
            }
        });
        this.count = 0;
        this.maxCount = this.fileObjects.size();
    }

    @Override
    public void requestSent(IRequest request) {
        if (!(request instanceof AbstractFileStateRequest)) {
            return;
        }
        AbstractFileStateRequest fileStateRequest = (AbstractFileStateRequest)request;
        FileObject fileObject = fileStateRequest.getFileObject();
        if (!this.fileObjects.remove(fileObject)) {
            return;
        }
        ++this.count;
        this.notifyProgress(this.count, this.maxCount, this.progressViewer);
    }

    private void notifyProgress(int count, int maxCount, IProgressViewer progressViewer) {
        progressViewer.setProgress((double)count / (double)maxCount);
    }
}

