/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.format;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.IpnbFile;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbRawCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbJpegOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbPngOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbSvgOutputCell;

public class IpnbParser {
    private static final Logger LOG = Logger.getInstance(IpnbParser.class);
    private static final Gson gson = IpnbParser.initGson();
    private static final List<String> myErrors = new ArrayList<String>();
    private static final String VALIDATION_ERROR_TEXT = "An invalid notebook may not function properly. The validation error was:";
    private static final String VALIDATION_ERROR_TITLE = "Notebook Validation Failed";

    @NotNull
    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(IpnbCellRaw.class, (Object)new RawCellAdapter()).registerTypeAdapter(IpnbFileRaw.class, (Object)new FileAdapter()).registerTypeAdapter(CellOutputRaw.class, (Object)new OutputsAdapter()).registerTypeAdapter(OutputDataRaw.class, (Object)new OutputDataAdapter()).registerTypeAdapter(CellOutputRaw.class, (Object)new CellOutputDeserializer()).registerTypeAdapter(OutputDataRaw.class, (Object)new OutputDataDeserializer()).registerTypeAdapter(IpnbCellRaw.class, (Object)new CellRawDeserializer()).serializeNulls();
        Gson gson = builder.create();
        if (gson == null) {
            IpnbParser.$$$reportNull$$$0(0);
        }
        return gson;
    }

    @NotNull
    public static IpnbFile parseIpnbFile(@NotNull CharSequence fileText, @NotNull VirtualFile virtualFile) {
        if (fileText == null) {
            IpnbParser.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            IpnbParser.$$$reportNull$$$0(2);
        }
        myErrors.clear();
        String path = virtualFile.getPath();
        IpnbFileRaw rawFile = (IpnbFileRaw)gson.fromJson(fileText.toString(), IpnbFileRaw.class);
        if (rawFile == null) {
            int nbformat = IpnbParser.isIpythonNewFormat(virtualFile) ? 4 : 3;
            IpnbFile ipnbFile = new IpnbFile(new HashMap<String, Object>(), nbformat, 0, Lists.newArrayList(), path);
            if (ipnbFile == null) {
                IpnbParser.$$$reportNull$$$0(3);
            }
            return ipnbFile;
        }
        ArrayList<IpnbCell> cells = new ArrayList<IpnbCell>();
        List<IpnbWorksheet> worksheets = rawFile.worksheets;
        if (worksheets == null) {
            for (IpnbCellRaw rawCell : rawFile.cells) {
                cells.add(rawCell.createCell(IpnbParser.validateSource(rawCell)));
            }
        } else {
            for (IpnbWorksheet worksheet : worksheets) {
                List<IpnbCellRaw> rawCells = worksheet.cells;
                for (IpnbCellRaw rawCell : rawCells) {
                    cells.add(rawCell.createCell(IpnbParser.validateSource(rawCell)));
                }
            }
        }
        IpnbParser.showValidationMessage();
        IpnbFile ipnbFile = new IpnbFile(rawFile.metadata, rawFile.nbformat, rawFile.nbformat_minor, cells, path);
        if (ipnbFile == null) {
            IpnbParser.$$$reportNull$$$0(4);
        }
        return ipnbFile;
    }

    private static boolean validateSource(IpnbCellRaw cell) {
        if (cell.source == null && cell.input == null) {
            String error = "An invalid notebook may not function properly. The validation error was:\n\"source\" or \"input\" is required property:\n" + cell;
            myErrors.add(error);
            LOG.warn(error);
            return false;
        }
        return true;
    }

    private static void showValidationMessage() {
        if (!myErrors.isEmpty()) {
            Messages.showWarningDialog((String)myErrors.get(0), (String)VALIDATION_ERROR_TITLE);
        }
    }

    public static boolean isIpythonNewFormat(@NotNull VirtualFile virtualFile) {
        Sdk sdk;
        Module module;
        Project project;
        if (virtualFile == null) {
            IpnbParser.$$$reportNull$$$0(5);
        }
        if ((project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile)) != null && (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(virtualFile)) != null && (sdk = PythonSdkType.findPythonSdk((Module)module)) != null) {
            PyPackage jupyter;
            List packages = PyPackageUtil.refreshAndGetPackagesModally((Sdk)sdk);
            PyPackage ipython = packages != null ? PyPackageUtil.findPackage((List)packages, (String)"ipython") : null;
            PyPackage pyPackage = jupyter = packages != null ? PyPackageUtil.findPackage((List)packages, (String)"jupyter") : null;
            if (jupyter == null && ipython != null && VersionComparatorUtil.compare((String)ipython.getVersion(), (String)"3.0") <= 0) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static IpnbFile parseIpnbFile(@NotNull Document document, @NotNull VirtualFile virtualFile) throws IOException {
        if (document == null) {
            IpnbParser.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            IpnbParser.$$$reportNull$$$0(7);
        }
        IpnbFile ipnbFile = IpnbParser.parseIpnbFile(document.getImmutableCharSequence(), virtualFile);
        if (ipnbFile == null) {
            IpnbParser.$$$reportNull$$$0(8);
        }
        return ipnbFile;
    }

    public static void saveIpnbFile(@NotNull IpnbFilePanel ipnbPanel) {
        String json;
        if (ipnbPanel == null) {
            IpnbParser.$$$reportNull$$$0(9);
        }
        if ((json = IpnbParser.newDocumentText(ipnbPanel)) == null) {
            return;
        }
        IpnbParser.writeToFile(ipnbPanel.getIpnbFile().getPath(), json);
    }

    @Nullable
    public static String newDocumentText(@NotNull IpnbFilePanel ipnbPanel) {
        IpnbFile ipnbFile;
        if (ipnbPanel == null) {
            IpnbParser.$$$reportNull$$$0(10);
        }
        if ((ipnbFile = ipnbPanel.getIpnbFile()) == null) {
            return null;
        }
        for (IpnbEditablePanel ipnbEditablePanel : ipnbPanel.getIpnbPanels()) {
            if (!ipnbEditablePanel.isModified()) continue;
            ipnbEditablePanel.updateCellSource();
        }
        IpnbFileRaw fileRaw = new IpnbFileRaw();
        fileRaw.nbformat_minor = ipnbFile.getNbFormatMinor();
        fileRaw.metadata = ipnbFile.getMetadata();
        if (ipnbFile.getNbformat() == 4) {
            for (IpnbCell ipnbCell : ipnbFile.getCells()) {
                fileRaw.cells.add(IpnbCellRaw.fromCell(ipnbCell, ipnbFile.getNbformat()));
            }
        } else {
            IpnbWorksheet ipnbWorksheet = new IpnbWorksheet();
            ipnbWorksheet.cells.clear();
            for (IpnbCell cell : ipnbFile.getCells()) {
                ipnbWorksheet.cells.add(IpnbCellRaw.fromCell(cell, ipnbFile.getNbformat()));
            }
            fileRaw.worksheets = Collections.singletonList(ipnbWorksheet);
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setIndent(" ");
        gson.toJson((Object)fileRaw, fileRaw.getClass(), jsonWriter);
        return stringWriter.toString() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull String path, @NotNull String json) {
        if (path == null) {
            IpnbParser.$$$reportNull$$$0(11);
        }
        if (json == null) {
            IpnbParser.$$$reportNull$$$0(12);
        }
        File file = new File(path);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").newEncoder());
            try {
                writer.write(json);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    writer.close();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static ArrayList<String> getStringOrArray(String name, JsonObject object) {
        JsonElement jsonElement = object.get(name);
        ArrayList strings = Lists.newArrayList();
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            for (JsonElement element : array) {
                strings.add(element.getAsString());
            }
        } else {
            strings.add(jsonElement.getAsString());
        }
        return strings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/format/IpnbParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipnbPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initGson";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/format/IpnbParser";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIpnbFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseIpnbFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIpythonNewFormat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveIpnbFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newDocumentText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OutputDataAdapter
    implements JsonSerializer<OutputDataRaw> {
        OutputDataAdapter() {
        }

        public JsonElement serialize(OutputDataRaw cellRaw, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (cellRaw.png != null) {
                jsonObject.addProperty("image/png", cellRaw.png);
            }
            if (cellRaw.html != null) {
                JsonElement html = gson.toJsonTree(cellRaw.html);
                jsonObject.add("text/html", html);
            }
            if (cellRaw.svg != null) {
                JsonElement svg = gson.toJsonTree(cellRaw.svg);
                jsonObject.add("image/svg+xml", svg);
            }
            if (cellRaw.jpeg != null) {
                JsonElement jpeg = gson.toJsonTree(cellRaw.jpeg);
                jsonObject.add("image/jpeg", jpeg);
            }
            if (cellRaw.latex != null) {
                JsonElement latex = gson.toJsonTree(cellRaw.latex);
                jsonObject.add("text/latex", latex);
            }
            if (cellRaw.markdown != null) {
                JsonElement markdown = gson.toJsonTree(cellRaw.markdown);
                jsonObject.add("text/markdown", markdown);
            }
            if (cellRaw.text != null) {
                JsonElement text = gson.toJsonTree(cellRaw.text);
                jsonObject.add("text/plain", text);
            }
            return jsonObject;
        }
    }

    static class OutputsAdapter
    implements JsonSerializer<CellOutputRaw> {
        OutputsAdapter() {
        }

        public JsonElement serialize(CellOutputRaw cellRaw, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (cellRaw.ename != null) {
                jsonObject.addProperty("ename", cellRaw.ename);
            }
            if (cellRaw.name != null) {
                jsonObject.addProperty("name", cellRaw.name);
            }
            if (cellRaw.evalue != null) {
                jsonObject.addProperty("evalue", cellRaw.evalue);
            }
            if (cellRaw.data != null) {
                JsonElement data = gson.toJsonTree((Object)cellRaw.data);
                jsonObject.add("data", data);
            }
            if (cellRaw.execution_count != null) {
                jsonObject.addProperty("execution_count", (Number)cellRaw.execution_count);
            }
            if (cellRaw.png != null) {
                jsonObject.addProperty("png", cellRaw.png);
            }
            if (cellRaw.stream != null) {
                jsonObject.addProperty("stream", cellRaw.stream);
            }
            if (cellRaw.jpeg != null) {
                jsonObject.addProperty("jpeg", cellRaw.jpeg);
            }
            if (cellRaw.html != null) {
                JsonElement html = gson.toJsonTree(cellRaw.html);
                jsonObject.add("html", html);
            }
            if (cellRaw.latex != null) {
                JsonElement latex = gson.toJsonTree(cellRaw.latex);
                jsonObject.add("latex", latex);
            }
            if (cellRaw.svg != null) {
                JsonElement svg = gson.toJsonTree(cellRaw.svg);
                jsonObject.add("svg", svg);
            }
            if (cellRaw.prompt_number != null) {
                jsonObject.addProperty("prompt_number", (Number)cellRaw.prompt_number);
            }
            if (cellRaw.traceback != null) {
                JsonElement traceback = gson.toJsonTree(cellRaw.traceback);
                jsonObject.add("traceback", traceback);
            }
            if (cellRaw.metadata != null) {
                JsonElement metadata = gson.toJsonTree(cellRaw.metadata);
                jsonObject.add("metadata", metadata);
            }
            if (cellRaw.output_type != null) {
                jsonObject.addProperty("output_type", cellRaw.output_type);
            }
            if (cellRaw.text != null) {
                JsonElement text = gson.toJsonTree(cellRaw.text);
                jsonObject.add("text", text);
            }
            return jsonObject;
        }
    }

    static class CellOutputDeserializer
    implements JsonDeserializer<CellOutputRaw> {
        CellOutputDeserializer() {
        }

        public CellOutputRaw deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement jpeg;
            JsonElement stream;
            JsonElement png;
            JsonElement outputType;
            JsonElement count;
            JsonElement data;
            JsonElement evalue;
            JsonElement name;
            JsonObject object = json.getAsJsonObject();
            CellOutputRaw cellOutputRaw = new CellOutputRaw();
            JsonElement ename = object.get("ename");
            if (ename != null) {
                cellOutputRaw.ename = ename.getAsString();
            }
            if ((name = object.get("name")) != null) {
                cellOutputRaw.name = name.getAsString();
            }
            if ((evalue = object.get("evalue")) != null) {
                cellOutputRaw.evalue = evalue.getAsString();
            }
            if ((data = object.get("data")) != null) {
                cellOutputRaw.data = (OutputDataRaw)gson.fromJson(data, OutputDataRaw.class);
            }
            if ((count = object.get("execution_count")) != null) {
                cellOutputRaw.execution_count = count.getAsInt();
            }
            if ((outputType = object.get("output_type")) != null) {
                cellOutputRaw.output_type = outputType.getAsString();
            }
            if ((png = object.get("png")) != null) {
                cellOutputRaw.png = png.getAsString();
            }
            if ((stream = object.get("stream")) != null) {
                cellOutputRaw.stream = stream.getAsString();
            }
            if ((jpeg = object.get("jpeg")) != null) {
                cellOutputRaw.jpeg = jpeg.getAsString();
            }
            cellOutputRaw.html = IpnbParser.getStringOrArray("html", object);
            cellOutputRaw.latex = IpnbParser.getStringOrArray("latex", object);
            cellOutputRaw.svg = IpnbParser.getStringOrArray("svg", object);
            JsonElement promptNumber = object.get("prompt_number");
            if (promptNumber != null) {
                cellOutputRaw.prompt_number = promptNumber.getAsInt();
            }
            cellOutputRaw.text = IpnbParser.getStringOrArray("text", object);
            cellOutputRaw.traceback = IpnbParser.getStringOrArray("traceback", object);
            JsonElement metadata = object.get("metadata");
            if (metadata != null) {
                cellOutputRaw.metadata = (Map)gson.fromJson(metadata, Map.class);
            }
            return cellOutputRaw;
        }
    }

    static class OutputDataDeserializer
    implements JsonDeserializer<OutputDataRaw> {
        OutputDataDeserializer() {
        }

        public OutputDataRaw deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            OutputDataRaw dataRaw = new OutputDataRaw();
            JsonElement png = object.get("image/png");
            if (png instanceof JsonArray) {
                JsonArray array = png.getAsJsonArray();
                StringBuilder pngString = new StringBuilder();
                for (int i = 0; i != array.size(); ++i) {
                    pngString.append(array.get(i).getAsString());
                }
                dataRaw.png = pngString.toString();
            } else if (png instanceof JsonPrimitive) {
                dataRaw.png = png.getAsString();
            }
            dataRaw.html = IpnbParser.getStringOrArray("text/html", object);
            dataRaw.svg = IpnbParser.getStringOrArray("image/svg+xml", object);
            dataRaw.jpeg = IpnbParser.getStringOrArray("image/jpeg", object);
            dataRaw.latex = IpnbParser.getStringOrArray("text/latex", object);
            dataRaw.markdown = IpnbParser.getStringOrArray("text/markdown", object);
            dataRaw.text = IpnbParser.getStringOrArray("text/plain", object);
            return dataRaw;
        }
    }

    static class CellRawDeserializer
    implements JsonDeserializer<IpnbCellRaw> {
        CellRawDeserializer() {
        }

        public IpnbCellRaw deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement number;
            JsonElement outputsElement;
            JsonElement level;
            JsonElement metadata;
            JsonElement count;
            JsonObject object = json.getAsJsonObject();
            IpnbCellRaw cellRaw = new IpnbCellRaw();
            JsonElement cell_type = object.get("cell_type");
            if (cell_type != null) {
                cellRaw.cell_type = cell_type.getAsString();
            }
            if ((count = object.get("execution_count")) != null) {
                Integer n = cellRaw.execution_count = count.isJsonNull() ? null : Integer.valueOf(count.getAsInt());
            }
            if ((metadata = object.get("metadata")) != null) {
                cellRaw.metadata = (Map)gson.fromJson(metadata, Map.class);
            }
            if ((level = object.get("level")) != null) {
                cellRaw.level = level.getAsInt();
            }
            if ((outputsElement = object.get("outputs")) != null) {
                JsonArray outputs = outputsElement.getAsJsonArray();
                cellRaw.outputs = Lists.newArrayList();
                for (JsonElement output : outputs) {
                    cellRaw.outputs.add((CellOutputRaw)gson.fromJson(output, CellOutputRaw.class));
                }
            }
            cellRaw.source = IpnbParser.getStringOrArray("source", object);
            cellRaw.input = IpnbParser.getStringOrArray("input", object);
            JsonElement language = object.get("language");
            if (language != null) {
                cellRaw.language = language.getAsString();
            }
            if ((number = object.get("prompt_number")) != null) {
                cellRaw.prompt_number = "*".equals(number.getAsString()) ? null : Integer.valueOf(number.getAsInt());
            }
            return cellRaw;
        }
    }

    static class FileAdapter
    implements JsonSerializer<IpnbFileRaw>,
    JsonDeserializer<IpnbFileRaw> {
        FileAdapter() {
        }

        public JsonElement serialize(IpnbFileRaw fileRaw, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (fileRaw.worksheets != null) {
                JsonElement worksheets = gson.toJsonTree(fileRaw.worksheets);
                jsonObject.add("worksheets", worksheets);
            }
            if (fileRaw.cells != null) {
                JsonElement cells = gson.toJsonTree(fileRaw.cells, new TypeToken<List<IpnbCellRaw>>(){}.getType());
                jsonObject.add("cells", cells);
            }
            JsonElement metadata = gson.toJsonTree(fileRaw.metadata);
            jsonObject.add("metadata", metadata);
            jsonObject.addProperty("nbformat", (Number)fileRaw.nbformat);
            jsonObject.addProperty("nbformat_minor", (Number)fileRaw.nbformat_minor);
            return jsonObject;
        }

        public IpnbFileRaw deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement nbformatMinor;
            JsonElement nbformat;
            JsonElement metadataElement;
            JsonElement cellsElement;
            JsonObject object = json.getAsJsonObject();
            IpnbFileRaw fileRaw = new IpnbFileRaw();
            JsonElement worksheets = object.get("worksheets");
            if (worksheets != null) {
                fileRaw.worksheets = (List)gson.fromJson(worksheets, new TypeToken<List<IpnbWorksheet>>(){}.getType());
            }
            if ((cellsElement = object.get("cells")) != null) {
                fileRaw.cells = (List)gson.fromJson(cellsElement, new TypeToken<List<IpnbCellRaw>>(){}.getType());
            }
            if ((metadataElement = object.get("metadata")) != null) {
                JsonElement languageInfo;
                LinkedTreeMap metadataMap = (LinkedTreeMap)gson.fromJson(metadataElement, new TypeToken<Map<String, Object>>(){}.getType());
                JsonElement kernelInfo = metadataElement.getAsJsonObject().get("kernel_info");
                if (kernelInfo != null) {
                    metadataMap.put((Object)"kernel_info", gson.fromJson(kernelInfo, new TypeToken<Map<String, String>>(){}.getType()));
                }
                if ((languageInfo = metadataElement.getAsJsonObject().get("language_info")) != null) {
                    LinkedTreeMap languageInfoMap = (LinkedTreeMap)gson.fromJson(languageInfo, new TypeToken<Map<String, Object>>(){}.getType());
                    JsonElement codemirrorMode = languageInfo.getAsJsonObject().get("codemirror_mode");
                    if (codemirrorMode != null) {
                        String version;
                        LinkedTreeMap codemirrorModeMap = (LinkedTreeMap)gson.fromJson(codemirrorMode, new TypeToken<Map<String, String>>(){}.getType());
                        if (codemirrorModeMap.containsKey((Object)"version") && NumberUtils.isNumber((String)(version = (String)codemirrorModeMap.get((Object)"version")))) {
                            try {
                                codemirrorModeMap.put((Object)"version", (Object)Integer.parseInt(version));
                            }
                            catch (NumberFormatException e) {
                                codemirrorModeMap.put((Object)"version", (Object)((int)Double.parseDouble(version)));
                            }
                        }
                        languageInfoMap.put((Object)"codemirror_mode", (Object)codemirrorModeMap);
                    }
                    metadataMap.put((Object)"language_info", (Object)languageInfoMap);
                }
                fileRaw.metadata = metadataMap;
            }
            if ((nbformat = object.get("nbformat")) != null) {
                fileRaw.nbformat = nbformat.getAsInt();
            }
            if ((nbformatMinor = object.get("nbformat_minor")) != null) {
                fileRaw.nbformat_minor = nbformatMinor.getAsInt();
            }
            return fileRaw;
        }
    }

    static class RawCellAdapter
    implements JsonSerializer<IpnbCellRaw> {
        RawCellAdapter() {
        }

        public JsonElement serialize(IpnbCellRaw cellRaw, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("cell_type", cellRaw.cell_type);
            if ("code".equals(cellRaw.cell_type)) {
                Integer count = cellRaw.execution_count;
                if (count == null) {
                    jsonObject.add("execution_count", (JsonElement)JsonNull.INSTANCE);
                } else {
                    jsonObject.addProperty("execution_count", (Number)count);
                }
            }
            if (cellRaw.metadata != null) {
                JsonElement metadata = gson.toJsonTree(cellRaw.metadata);
                jsonObject.add("metadata", metadata);
            }
            if (cellRaw.level != null) {
                jsonObject.addProperty("level", (Number)cellRaw.level);
            }
            if (cellRaw.outputs != null) {
                JsonElement outputs = gson.toJsonTree(cellRaw.outputs);
                jsonObject.add("outputs", outputs);
            }
            if (cellRaw.source != null) {
                JsonElement source = gson.toJsonTree(cellRaw.source);
                jsonObject.add("source", source);
            }
            if (cellRaw.input != null) {
                JsonElement input = gson.toJsonTree(cellRaw.input);
                jsonObject.add("input", input);
            }
            if (cellRaw.language != null) {
                jsonObject.addProperty("language", cellRaw.language);
            }
            if (cellRaw.prompt_number != null) {
                jsonObject.addProperty("prompt_number", (Number)cellRaw.prompt_number);
            }
            return jsonObject;
        }
    }

    private static class OutputDataRaw {
        @SerializedName(value="image/png")
        String png;
        @SerializedName(value="text/html")
        List<String> html;
        @SerializedName(value="image/svg+xml")
        List<String> svg;
        @SerializedName(value="image/jpeg")
        List<String> jpeg;
        @SerializedName(value="text/latex")
        List<String> latex;
        @SerializedName(value="text/plain")
        List<String> text;
        @SerializedName(value="text/markdown")
        List<String> markdown;

        private OutputDataRaw() {
        }
    }

    private static class CellOutputRaw {
        String ename;
        String name;
        String evalue;
        OutputDataRaw data;
        Integer execution_count;
        String png;
        String stream;
        String jpeg;
        List<String> html;
        List<String> latex;
        List<String> svg;
        Integer prompt_number;
        List<String> traceback;
        Map<String, Object> metadata;
        String output_type;
        List<String> text;

        private CellOutputRaw() {
        }

        public static CellOutputRaw fromOutput(@NotNull IpnbOutputCell outputCell, int nbformat) {
            if (outputCell == null) {
                CellOutputRaw.$$$reportNull$$$0(0);
            }
            CellOutputRaw raw = new CellOutputRaw();
            raw.metadata = outputCell.getMetadata();
            if (raw.metadata == null && !(outputCell instanceof IpnbStreamOutputCell) && !(outputCell instanceof IpnbErrorOutputCell)) {
                raw.metadata = new HashMap<String, Object>();
            }
            if (outputCell instanceof IpnbPngOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.png = ((IpnbPngOutputCell)outputCell).getBase64String();
                    dataRaw.text = outputCell.getText();
                    raw.data = dataRaw;
                    raw.execution_count = outputCell.getPromptNumber();
                    raw.output_type = outputCell.getPromptNumber() != null ? "execute_result" : "display_data";
                } else {
                    raw.png = ((IpnbPngOutputCell)outputCell).getBase64String();
                    raw.text = outputCell.getText();
                }
            } else if (outputCell instanceof IpnbSvgOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.text = outputCell.getText();
                    dataRaw.svg = ((IpnbSvgOutputCell)outputCell).getSvg();
                    raw.data = dataRaw;
                    raw.execution_count = outputCell.getPromptNumber();
                    raw.output_type = outputCell.getPromptNumber() != null ? "execute_result" : "display_data";
                } else {
                    raw.svg = ((IpnbSvgOutputCell)outputCell).getSvg();
                    raw.text = outputCell.getText();
                }
            } else if (outputCell instanceof IpnbJpegOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.text = outputCell.getText();
                    dataRaw.jpeg = Lists.newArrayList((Object[])new String[]{((IpnbJpegOutputCell)outputCell).getBase64String()});
                    raw.data = dataRaw;
                } else {
                    raw.jpeg = ((IpnbJpegOutputCell)outputCell).getBase64String();
                    raw.text = outputCell.getText();
                }
            } else if (outputCell instanceof IpnbLatexOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.text = outputCell.getText();
                    if (((IpnbLatexOutputCell)outputCell).isMarkdown()) {
                        dataRaw.markdown = ((IpnbLatexOutputCell)outputCell).getLatex();
                    } else {
                        dataRaw.latex = ((IpnbLatexOutputCell)outputCell).getLatex();
                    }
                    raw.data = dataRaw;
                    raw.execution_count = outputCell.getPromptNumber();
                    raw.output_type = outputCell.getPromptNumber() != null ? "execute_result" : "display_data";
                } else {
                    raw.latex = ((IpnbLatexOutputCell)outputCell).getLatex();
                    raw.text = outputCell.getText();
                    raw.prompt_number = outputCell.getPromptNumber();
                }
            } else if (outputCell instanceof IpnbStreamOutputCell) {
                if (nbformat == 4) {
                    raw.name = ((IpnbStreamOutputCell)outputCell).getStream();
                } else {
                    raw.stream = ((IpnbStreamOutputCell)outputCell).getStream();
                }
                raw.text = outputCell.getText();
                raw.output_type = "stream";
            } else if (outputCell instanceof IpnbHtmlOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.html = ((IpnbHtmlOutputCell)outputCell).getHtmls();
                    dataRaw.text = outputCell.getText();
                    raw.data = dataRaw;
                    raw.execution_count = outputCell.getPromptNumber();
                } else {
                    raw.html = ((IpnbHtmlOutputCell)outputCell).getHtmls();
                }
                raw.output_type = nbformat == 4 ? "execute_result" : "pyout";
            } else if (outputCell instanceof IpnbErrorOutputCell) {
                raw.output_type = nbformat == 4 ? "error" : "pyerr";
                raw.evalue = ((IpnbErrorOutputCell)outputCell).getEvalue();
                raw.ename = ((IpnbErrorOutputCell)outputCell).getEname();
                raw.traceback = outputCell.getText();
            } else if (outputCell instanceof IpnbOutOutputCell) {
                if (nbformat == 4) {
                    raw.execution_count = outputCell.getPromptNumber();
                    raw.output_type = "execute_result";
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.text = outputCell.getText();
                    raw.data = dataRaw;
                } else {
                    raw.output_type = "pyout";
                    raw.prompt_number = outputCell.getPromptNumber();
                    raw.text = outputCell.getText();
                }
            } else {
                raw.text = outputCell.getText();
            }
            return raw;
        }

        public IpnbOutputCell createOutput() {
            Integer prompt;
            ArrayList text = this.text != null ? this.text : (this.data != null ? this.data.text : Lists.newArrayList());
            Integer n = prompt = this.execution_count != null ? this.execution_count : this.prompt_number;
            IpnbOutputCell outputCell = this.png != null || this.data != null && this.data.png != null ? new IpnbPngOutputCell(this.png == null ? StringUtil.join((String[])new String[]{this.data.png}) : this.png, text, prompt, this.metadata) : (this.jpeg != null || this.data != null && this.data.jpeg != null ? new IpnbJpegOutputCell(this.jpeg == null ? StringUtil.join(this.data.jpeg, (String)"") : this.jpeg, text, prompt, this.metadata) : (this.svg != null || this.data != null && this.data.svg != null ? new IpnbSvgOutputCell(this.svg == null ? this.data.svg : this.svg, text, prompt, this.metadata) : (this.html != null || this.data != null && this.data.html != null ? new IpnbHtmlOutputCell(this.html == null ? this.data.html : this.html, text, prompt, this.metadata) : (this.latex != null || this.data != null && this.data.latex != null ? new IpnbLatexOutputCell(this.latex == null ? this.data.latex : this.latex, false, prompt, text, this.metadata) : (this.data != null && this.data.markdown != null ? new IpnbLatexOutputCell(this.data.markdown, true, prompt, text, this.metadata) : (this.stream != null || this.name != null ? new IpnbStreamOutputCell(this.stream == null ? this.name : this.stream, text, prompt, this.metadata) : ("pyerr".equals(this.output_type) || "error".equals(this.output_type) ? new IpnbErrorOutputCell(this.evalue, this.ename, this.traceback, prompt, this.metadata) : ("pyout".equals(this.output_type) ? new IpnbOutOutputCell(text, prompt, this.metadata) : ("execute_result".equals(this.output_type) && this.data != null ? new IpnbOutOutputCell(this.data.text, prompt, this.metadata) : ("display_data".equals(this.output_type) ? new IpnbPngOutputCell(null, text, prompt, this.metadata) : new IpnbOutputCell(text, prompt, this.metadata)))))))))));
            return outputCell;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputCell", "org/jetbrains/plugins/ipnb/format/IpnbParser$CellOutputRaw", "fromOutput"));
        }
    }

    private static class IpnbCellRaw {
        String cell_type;
        Integer execution_count;
        Map<String, Object> metadata = new HashMap<String, Object>();
        Integer level;
        List<CellOutputRaw> outputs;
        List<String> source;
        List<String> input;
        String language;
        Integer prompt_number;

        private IpnbCellRaw() {
        }

        public String toString() {
            return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
        }

        public static IpnbCellRaw fromCell(@NotNull IpnbCell cell, int nbformat) {
            if (cell == null) {
                IpnbCellRaw.$$$reportNull$$$0(0);
            }
            IpnbCellRaw raw = new IpnbCellRaw();
            if (cell instanceof IpnbEditableCell) {
                raw.metadata = ((IpnbEditableCell)cell).getMetadata();
            }
            if (cell instanceof IpnbMarkdownCell) {
                raw.cell_type = "markdown";
                raw.source = ((IpnbMarkdownCell)cell).getSource();
            } else if (cell instanceof IpnbCodeCell) {
                raw.cell_type = "code";
                ArrayList<CellOutputRaw> outputRaws = new ArrayList<CellOutputRaw>();
                for (IpnbOutputCell outputCell : ((IpnbCodeCell)cell).getCellOutputs()) {
                    outputRaws.add(CellOutputRaw.fromOutput(outputCell, nbformat));
                }
                raw.outputs = outputRaws;
                Integer promptNumber = ((IpnbCodeCell)cell).getPromptNumber();
                if (nbformat == 4) {
                    raw.execution_count = promptNumber != null && promptNumber >= 0 ? promptNumber : null;
                    raw.source = ((IpnbCodeCell)cell).getSource();
                } else {
                    raw.prompt_number = promptNumber != null && promptNumber >= 0 ? promptNumber : null;
                    raw.language = ((IpnbCodeCell)cell).getLanguage();
                    raw.input = ((IpnbCodeCell)cell).getSource();
                }
            } else if (cell instanceof IpnbRawCell) {
                raw.cell_type = "raw";
                raw.source = ((IpnbRawCell)cell).getSource();
            } else if (cell instanceof IpnbHeadingCell) {
                raw.cell_type = "heading";
                raw.source = ((IpnbHeadingCell)cell).getSource();
                raw.level = ((IpnbHeadingCell)cell).getLevel();
            }
            return raw;
        }

        @Nullable
        public IpnbCell createCell(boolean isValidSource) {
            IpnbCell cell;
            if (this.cell_type.equals("markdown")) {
                cell = new IpnbMarkdownCell(isValidSource ? this.source : new ArrayList<String>(), this.metadata);
            } else if (this.cell_type.equals("code")) {
                ArrayList<IpnbOutputCell> outputCells = new ArrayList<IpnbOutputCell>();
                for (CellOutputRaw outputRaw : this.outputs) {
                    outputCells.add(outputRaw.createOutput());
                }
                Integer prompt = this.prompt_number != null ? this.prompt_number : this.execution_count;
                cell = new IpnbCodeCell(this.language == null ? "python" : this.language, this.input == null ? (isValidSource ? this.source : new ArrayList<String>()) : this.input, prompt, outputCells, this.metadata);
            } else {
                cell = this.cell_type.equals("raw") ? new IpnbRawCell(isValidSource ? this.source : new ArrayList<String>()) : (this.cell_type.equals("heading") ? new IpnbHeadingCell(isValidSource ? this.source : new ArrayList<String>(), this.level, this.metadata) : null);
            }
            return cell;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/format/IpnbParser$IpnbCellRaw", "fromCell"));
        }
    }

    private static class IpnbWorksheet {
        final List<IpnbCellRaw> cells = new ArrayList<IpnbCellRaw>();

        private IpnbWorksheet() {
        }
    }

    public static class IpnbFileRaw {
        List<IpnbWorksheet> worksheets;
        List<IpnbCellRaw> cells = new ArrayList<IpnbCellRaw>();
        Map<String, Object> metadata = new HashMap<String, Object>();
        int nbformat = 4;
        int nbformat_minor;
    }
}

