/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.ClassConditionKey;

public class PrioritizedLookupElement<T extends LookupElement>
extends LookupElementDecorator<T> {
    public static final ClassConditionKey<PrioritizedLookupElement> CLASS_CONDITION_KEY = ClassConditionKey.create(PrioritizedLookupElement.class);
    private final double myPriority;
    private final int myGrouping;
    private final int myExplicitProximity;

    private PrioritizedLookupElement(T delegate, double priority, int grouping) {
        this(delegate, priority, grouping, 0);
    }

    private PrioritizedLookupElement(T delegate, double priority, int grouping, int explicitProximity) {
        super(delegate);
        this.myPriority = priority;
        this.myGrouping = grouping;
        this.myExplicitProximity = explicitProximity;
    }

    public double getPriority() {
        return this.myPriority;
    }

    public int getGrouping() {
        return this.myGrouping;
    }

    public int getExplicitProximity() {
        return this.myExplicitProximity;
    }

    public static LookupElement withPriority(LookupElement element, double priority) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        return new PrioritizedLookupElement<LookupElement>(element, priority, prioritized == null ? 0 : prioritized.getGrouping());
    }

    public static LookupElement withGrouping(LookupElement element, int grouping) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        return new PrioritizedLookupElement<LookupElement>(element, prioritized == null ? 0.0 : prioritized.getPriority(), grouping);
    }

    public static LookupElement withExplicitProximity(LookupElement element, int explicitProximity) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        double priority = prioritized == null ? 0.0 : prioritized.getPriority();
        int grouping = prioritized == null ? 0 : prioritized.getGrouping();
        return new PrioritizedLookupElement<LookupElement>(element, priority, grouping, explicitProximity);
    }
}

