/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommonProblemDescriptor {
    public static final Comparator<CommonProblemDescriptor> DESCRIPTOR_COMPARATOR = (c1, c2) -> {
        if (c1 instanceof ProblemDescriptor && c2 instanceof ProblemDescriptor) {
            int diff = ((ProblemDescriptor)c2).getLineNumber() - ((ProblemDescriptor)c1).getLineNumber();
            if (diff != 0) {
                return diff;
            }
            diff = PsiUtilCore.compareElementsByPosition(((ProblemDescriptor)c2).getPsiElement(), ((ProblemDescriptor)c1).getPsiElement());
            if (diff != 0) {
                return diff;
            }
        }
        return c1.getDescriptionTemplate().compareTo(c2.getDescriptionTemplate());
    };
    public static final CommonProblemDescriptor[] EMPTY_ARRAY = new CommonProblemDescriptor[0];
    public static final ArrayFactory<CommonProblemDescriptor> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new CommonProblemDescriptor[count];

    @NotNull
    public String getDescriptionTemplate();

    @Nullable
    public QuickFix[] getFixes();
}

