/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCodeStyleSettingsManager {
    private volatile Map<Language, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Content> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.myParentSettings = parentSettings;
    }

    public CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        CommonCodeStyleSettings settings = commonSettingsMap.get((Object)lang);
        while (settings == null && lang != null) {
            lang = lang.getBaseLanguage();
            settings = commonSettingsMap.get((Object)lang);
        }
        if (settings != null) {
            return settings;
        }
        return this.myParentSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Language, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        Map<Language, CommonCodeStyleSettings> map = commonSettingsMap;
        if (map == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        if (langName == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        Map<Language, CommonCodeStyleSettings> map = this.getCommonSettingsMap();
        for (Map.Entry<Language, CommonCodeStyleSettings> entry : map.entrySet()) {
            if (!langName.equals(entry.getKey().getDisplayName())) continue;
            CommonCodeStyleSettings commonCodeStyleSettings = entry.getValue();
            if (commonCodeStyleSettings == null) {
                CommonCodeStyleSettingsManager.$$$reportNull$$$0(3);
            }
            return commonCodeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = this.myParentSettings;
        if (codeStyleSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return codeStyleSettings;
    }

    private void initNonReadSettings() {
        LanguageCodeStyleSettingsProvider[] providers;
        for (LanguageCodeStyleSettingsProvider provider : providers = (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(LanguageCodeStyleSettingsProvider.EP_NAME)) {
            CommonCodeStyleSettings initialSettings;
            Language target = provider.getLanguage();
            if (this.myCommonSettingsMap.containsKey((Object)target) || (initialSettings = provider.getDefaultCommonSettings()) == null) continue;
            this.init(initialSettings, target);
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull Language target) {
        if (initialSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        if (target == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(target, initialSettings);
    }

    private Map<Language, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<Language, CommonCodeStyleSettings> map = new LinkedHashMap<Language, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Content>();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull Language lang, @NotNull CommonCodeStyleSettings settings) {
        if (lang == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey((Object)lang)) {
                this.myCommonSettingsMap.put(lang, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager2 = this;
        // MONITORENTER : commonCodeStyleSettingsManager2
        CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
        if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
            settingsManager.initCommonSettingsMap();
            for (Map.Entry<Language, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
            }
            for (Map.Entry<Object, CommonCodeStyleSettings> entry : this.myUnknownSettingsMap.entrySet()) {
                Content contentCopy = ((Content)entry.getValue()).clone();
                settingsManager.myUnknownSettingsMap.put((String)entry.getKey(), contentCopy);
            }
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = settingsManager;
        // MONITOREXIT : commonCodeStyleSettingsManager2
        if (commonCodeStyleSettingsManager != null) return commonCodeStyleSettingsManager;
        CommonCodeStyleSettingsManager.$$$reportNull$$$0(10);
        return commonCodeStyleSettingsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            for (Element commonSettingsElement : element.getChildren(COMMON_SETTINGS_TAG)) {
                boolean isKnownLanguage;
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (StringUtil.isEmpty((String)languageId)) continue;
                Language target = Language.findLanguageByID(languageId);
                boolean bl = isKnownLanguage = target != null;
                if (isKnownLanguage) {
                    LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(target);
                    if (provider != null) {
                        CommonCodeStyleSettings settings = provider.getDefaultCommonSettings();
                        if (settings != null) {
                            settings.readExternal(commonSettingsElement);
                            this.init(settings, target);
                        }
                    } else {
                        isKnownLanguage = false;
                    }
                }
                if (isKnownLanguage) continue;
                this.myUnknownSettingsMap.put(languageId, (Content)commonSettingsElement.clone());
            }
            this.initNonReadSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            THashMap idToLang = new THashMap();
            for (Language language : this.myCommonSettingsMap.keySet()) {
                idToLang.put(language.getID(), language);
            }
            Object[] languages = ArrayUtil.toStringArray((Collection)ContainerUtil.union(this.myUnknownSettingsMap.keySet(), idToLang.keySet()));
            Arrays.sort(languages);
            for (Object id : languages) {
                Language language = (Language)((Object)idToLang.get(id));
                if (language != null) {
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get((Object)language);
                    Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
                    commonSettings.writeExternal(commonSettingsElement);
                    commonSettingsElement.setAttribute(LANGUAGE_ATTR, language.getID());
                    if (commonSettingsElement.getChildren().isEmpty()) continue;
                    element.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = this.myUnknownSettingsMap.get(id);
                if (unknown == null) continue;
                element.addContent(unknown.detach());
            }
        }
    }

    public static void copy(@NotNull CommonCodeStyleSettings source, @NotNull CommonCodeStyleSettings target) {
        CommonCodeStyleSettings.IndentOptions sourceIndentOptions;
        if (source == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        if (target == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        CommonCodeStyleSettings.copyPublicFields(source, target);
        CommonCodeStyleSettings.IndentOptions targetIndentOptions = target.getIndentOptions();
        if (targetIndentOptions != null && (sourceIndentOptions = source.getIndentOptions()) != null) {
            CommonCodeStyleSettings.copyPublicFields(sourceIndentOptions, targetIndentOptions);
        }
        target.setSoftMargins(source.getSoftMargins());
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager other = (CommonCodeStyleSettingsManager)obj;
            if (this.getCommonSettingsMap().size() != other.getCommonSettingsMap().size() || this.myUnknownSettingsMap.size() != other.myUnknownSettingsMap.size()) {
                return false;
            }
            for (Language language : this.myCommonSettingsMap.keySet()) {
                CommonCodeStyleSettings otherSettings;
                CommonCodeStyleSettings theseSettings = this.myCommonSettingsMap.get((Object)language);
                if (theseSettings.equals(otherSettings = other.getCommonSettings(language))) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettingsMap";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

