/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.Alarm;
import com.intellij.util.ui.Animator;

abstract class TwoWayAnimator {
    private final Alarm myAlarm = new Alarm();
    private final MyAnimator myForwardAnimator;
    private final MyAnimator myBackwardAnimator;
    private final int myMaxFrame;
    private int myFrame;
    float myValue;

    abstract void onValueUpdate();

    TwoWayAnimator(String name, int totalFrames, int pauseForward, int durationForward, int pauseBackward, int durationBackward) {
        this.myMaxFrame = totalFrames - 1;
        this.myForwardAnimator = new MyAnimator(name + "ForwardAnimator", totalFrames, durationForward, pauseForward, true);
        this.myBackwardAnimator = new MyAnimator(name + "BackwardAnimator", totalFrames, durationBackward, pauseBackward, false);
    }

    void start(boolean forward) {
        MyAnimator animator;
        this.stop();
        MyAnimator myAnimator = animator = forward ? this.myForwardAnimator : this.myBackwardAnimator;
        if (!forward ? this.myFrame > 0 : this.myFrame < this.myMaxFrame) {
            if (forward ? this.myFrame > 0 : this.myFrame < this.myMaxFrame) {
                animator.run();
            } else {
                this.myAlarm.addRequest((Runnable)animator, animator.myPause);
            }
        }
    }

    void rewind(boolean forward) {
        this.stop();
        if (forward) {
            if (this.myFrame != this.myMaxFrame) {
                this.setFrame(this.myMaxFrame);
            }
        } else if (this.myFrame != 0) {
            this.setFrame(0);
        }
    }

    void stop() {
        this.myAlarm.cancelAllRequests();
        this.myForwardAnimator.suspend();
        this.myBackwardAnimator.suspend();
    }

    void setFrame(int frame) {
        this.myFrame = frame;
        this.myValue = frame == 0 ? 0.0f : (frame == this.myMaxFrame ? 1.0f : (float)frame / (float)this.myMaxFrame);
        this.onValueUpdate();
    }

    private final class MyAnimator
    extends Animator
    implements Runnable {
        private final int myPause;

        private MyAnimator(String name, int totalFrames, int cycleDuration, int pause, boolean forward) {
            super(name, totalFrames, cycleDuration, false, forward);
            this.myPause = pause;
        }

        @Override
        public void run() {
            this.reset();
            this.resume();
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            if (this.isForward() ? frame > TwoWayAnimator.this.myFrame : frame < TwoWayAnimator.this.myFrame) {
                TwoWayAnimator.this.setFrame(frame);
            }
        }

        @Override
        protected void paintCycleEnd() {
            TwoWayAnimator.this.setFrame(this.isForward() ? TwoWayAnimator.this.myMaxFrame : 0);
        }
    }
}

