/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;

public class SvnExternalFileReporter
implements ISVNReporterBaton {
    private SVNWCContext context;
    private File localAbsPath;
    private boolean restoreFiles;
    private boolean useCommitTimes;

    public SvnExternalFileReporter(SVNWCContext context, File localAbsPath, boolean restoreFiles, boolean useCommitTimes) {
        this.context = context;
        this.localAbsPath = localAbsPath;
        this.restoreFiles = restoreFiles;
        this.useCommitTimes = useCommitTimes;
    }

    @Override
    public void report(ISVNReporter reporter) throws SVNException {
        ISVNWCDb.WCDbBaseInfo baseInfo = null;
        try {
            baseInfo = this.context.getDb().getBaseInfo(this.localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot, ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock);
            if (baseInfo.kind == ISVNWCDb.SVNWCDbKind.Dir || !baseInfo.updateRoot) {
                reporter.setPath("", null, 0L, SVNDepth.INFINITY, false);
                reporter.deletePath("");
            } else {
                SVNFileType ft;
                if (this.restoreFiles && (ft = SVNFileType.getType(this.localAbsPath)) == SVNFileType.NONE) {
                    SVNReporter17.restoreNode(this.context, this.localAbsPath, ISVNWCDb.SVNWCDbKind.File, baseInfo.revision, this.useCommitTimes);
                }
                reporter.setPath("", null, baseInfo.revision, SVNDepth.INFINITY, false);
                SVNURL url = baseInfo.reposRootUrl.appendPath(SVNFileUtil.getFilePath(baseInfo.reposRelPath), false);
                String lockToken = baseInfo.lock != null ? baseInfo.lock.token : null;
                reporter.linkPath(url, "", lockToken, baseInfo.revision, SVNDepth.INFINITY, false);
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            reporter.setPath("", null, 0L, SVNDepth.INFINITY, false);
            reporter.deletePath("");
        }
        reporter.finishReport();
    }
}

