/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.auth.AbstractAuthenticator;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;

class SSLServerCertificateAuthenticator
extends AbstractAuthenticator {
    private String myCertificateRealm;
    private String myCredentialsRealm;
    private Object myCertificate;
    private int myResult;
    private SVNAuthentication myAuthentication;

    SSLServerCertificateAuthenticator(@NotNull AuthenticationService authenticationService, @NotNull SVNURL url, String realm) {
        if (authenticationService == null) {
            SSLServerCertificateAuthenticator.$$$reportNull$$$0(0);
        }
        if (url == null) {
            SSLServerCertificateAuthenticator.$$$reportNull$$$0(1);
        }
        super(authenticationService, url, realm);
    }

    @Override
    public boolean tryAuthenticate() {
        this.myResult = 1;
        this.myStoreInUsual = false;
        return super.tryAuthenticate();
    }

    @Override
    protected boolean getWithPassive(SvnAuthenticationManager passive) throws SVNException {
        String stored = (String)passive.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm);
        if (stored == null) {
            return false;
        }
        this.myCertificate = this.createCertificate(stored);
        this.myCertificateRealm = this.myRealm;
        return true;
    }

    @Override
    public void requestClientAuthentication(SVNURL url, String realm, SVNAuthentication authentication) {
        if (!this.myUrl.equals((Object)url)) {
            return;
        }
        this.myCredentialsRealm = realm;
        this.myAuthentication = authentication;
        if (this.myAuthentication != null) {
            this.myStoreInUsual &= this.myAuthentication.isStorageAllowed();
        }
    }

    @Override
    public void acceptServerAuthentication(SVNURL url, String realm, Object certificate, int acceptResult) {
        if (!this.myUrl.equals((Object)url)) {
            return;
        }
        this.myCertificateRealm = realm;
        this.myCertificate = certificate;
        this.myResult = acceptResult;
    }

    @Override
    protected boolean afterAuthCall() {
        this.myStoreInUsual &= this.myCertificate != null && 2 == this.myResult;
        return 0 != this.myResult && this.myCertificate != null;
    }

    @Override
    protected boolean acknowledge(SvnAuthenticationManager manager) throws SVNException {
        if (this.myCertificate == null) {
            String stored = (String)manager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm);
            if (StringUtil.isEmptyOrSpaces((String)stored)) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"No stored server certificate was found in runtime"));
            }
            this.myCertificate = this.createCertificate(stored);
            this.myCertificateRealm = this.myRealm;
        }
        if (this.myAuthenticationService.getTempDirectory() != null && this.myCertificate != null) {
            this.storeServerCertificate();
            if (this.myAuthentication != null) {
                String realm = this.myCredentialsRealm == null ? this.myCertificateRealm : this.myCredentialsRealm;
                return SSLServerCertificateAuthenticator.storeCredentials(manager, this.myAuthentication, realm);
            }
        }
        return true;
    }

    @NotNull
    private Certificate createCertificate(@NotNull String stored) throws SVNException {
        Certificate certificate;
        if (stored == null) {
            SSLServerCertificateAuthenticator.$$$reportNull$$$0(2);
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            byte[] buffer = new byte[stored.length()];
            SVNBase64.base64ToByteArray((StringBuffer)new StringBuffer(stored), (byte[])buffer);
            certificate = factory.generateCertificate(new ByteArrayInputStream(buffer));
        }
        catch (CertificateException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (Throwable)e));
        }
        if (certificate == null) {
            SSLServerCertificateAuthenticator.$$$reportNull$$$0(3);
        }
        return certificate;
    }

    private void storeServerCertificate() throws SVNException {
        String stored;
        if (!(this.myCertificate instanceof X509Certificate)) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)("Can not store server certificate: " + this.myCertificate)));
        }
        X509Certificate x509Certificate = (X509Certificate)this.myCertificate;
        try {
            stored = SVNBase64.byteArrayToBase64((byte[])x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e));
        }
        int failures = SVNSSLUtil.getServerCertificateFailures((X509Certificate)x509Certificate, (String)this.myUrl.getHost());
        this.storeServerCertificate(this.myAuthenticationService.getTempDirectory(), this.myCertificateRealm, stored, failures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeServerCertificate(File configDir, String realm, String data, int failures) throws SVNException {
        configDir.mkdirs();
        File file = new File(configDir, "auth/svn.ssl.server/" + SVNFileUtil.computeChecksum((String)realm));
        SVNHashMap map = new SVNHashMap();
        map.put((Object)"ascii_cert", (Object)data);
        map.put((Object)"svn:realmstring", (Object)realm);
        map.put((Object)"failures", (Object)Integer.toString(failures));
        SVNFileUtil.deleteFile((File)file);
        File tmpFile = SVNFileUtil.createUniqueFile((File)configDir, (String)"auth", (String)".tmp", (boolean)true);
        try {
            SVNWCProperties.setProperties((SVNProperties)SVNProperties.wrap((Map)map), (File)file, (File)tmpFile, (String)"END");
        }
        finally {
            SVNFileUtil.deleteFile((File)tmpFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/auth/SSLServerCertificateAuthenticator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/auth/SSLServerCertificateAuthenticator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCertificate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCertificate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

