/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<SvnFileRevision> {
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffFromHistoryHandler(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myVcs = vcs;
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull SvnFileRevision rev1, @Nullable SvnFileRevision rev2) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(1);
        }
        if (rev1 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(2);
        }
        File file = path.getIOFile();
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)rev1.getURL(), (SVNRevision)rev1.getRevision());
        SvnTarget target2 = rev2 != null ? SvnTarget.fromURL((SVNURL)rev2.getURL(), (SVNRevision)rev2.getRevision()) : SvnTarget.fromFile((File)file);
        List<Change> list = this.executeDiff(path, target1, target2);
        if (list == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull SvnFileRevision rev) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(4);
        }
        if (rev == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(5);
        }
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)rev.getURL(), (SVNRevision)SVNRevision.create((long)0L));
        SvnTarget target2 = SvnTarget.fromURL((SVNURL)rev.getURL(), (SVNRevision)rev.getRevision());
        List<Change> list = this.executeDiff(path, target1, target2);
        if (list == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected String getPresentableName(@NotNull SvnFileRevision revision) {
        if (revision == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(7);
        }
        String string = revision.getRevisionNumber().asString();
        if (string == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @NotNull SvnTarget target1, @NotNull SvnTarget target2) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(9);
        }
        if (target1 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(10);
        }
        if (target2 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(11);
        }
        File file = path.getIOFile();
        ClientFactory factory = target2.isURL() ? this.myVcs.getFactory(file) : DirectoryWithBranchComparer.getClientFactory(this.myVcs, file);
        List<Change> list = factory.createDiffClient().compare(target1, target2);
        if (list == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev1";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBetweenRevisions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChangesBetweenRevisions";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

