/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CommandLineTokenizer
extends StringTokenizer {
    private static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    private List myTokens = new ArrayList();
    private int myCurrentToken = 0;
    private boolean myHandleEscapedWhitespaces = false;

    public CommandLineTokenizer(String str) {
        this(str, false);
    }

    public CommandLineTokenizer(String str, boolean handleEscapedWhitespaces) {
        super(str, DEFAULT_DELIMITERS, true);
        this.myHandleEscapedWhitespaces = handleEscapedWhitespaces;
        this.parseTokens();
    }

    @Deprecated
    public CommandLineTokenizer(String str, String delim) {
        super(str, delim, true);
        this.parseTokens();
    }

    @Override
    public boolean hasMoreTokens() {
        return this.myCurrentToken < this.myTokens.size();
    }

    @Override
    public String nextToken() {
        return (String)this.myTokens.get(this.myCurrentToken++);
    }

    public String peekNextToken() {
        return (String)this.myTokens.get(this.myCurrentToken);
    }

    @Override
    public int countTokens() {
        return this.myTokens.size() - this.myCurrentToken;
    }

    @Override
    public String nextToken(String delim) {
        throw new UnsupportedOperationException();
    }

    private void parseTokens() {
        String token;
        while ((token = this.nextTokenInternal()) != null) {
            this.myTokens.add(token);
        }
    }

    private String nextTokenInternal() {
        String nextToken;
        while ((nextToken = super.hasMoreTokens() ? super.nextToken() : null) != null && nextToken.length() == 1 && DEFAULT_DELIMITERS.indexOf(nextToken.charAt(0)) >= 0) {
        }
        if (nextToken == null) {
            return null;
        }
        int quotationMarks = 0;
        StringBuilder buffer = new StringBuilder();
        while (true) {
            int i;
            if ((i = nextToken.indexOf(34)) >= 0) {
                boolean isEscapedQuote = CommandLineTokenizer.isEscapedAtPos(nextToken, i);
                if (!isEscapedQuote) {
                    ++quotationMarks;
                }
                buffer.append(nextToken.substring(0, isEscapedQuote ? i - 1 : i));
                if (isEscapedQuote) {
                    buffer.append('\"');
                }
                nextToken = nextToken.substring(i + 1);
                continue;
            }
            boolean isEscapedWhitespace = false;
            if (this.myHandleEscapedWhitespaces && quotationMarks == 0 && nextToken.endsWith("\\") && super.hasMoreTokens()) {
                isEscapedWhitespace = true;
                buffer.append(nextToken.substring(0, nextToken.length() - 1));
                buffer.append(super.nextToken());
            } else {
                buffer.append(nextToken);
            }
            if ((nextToken = (isEscapedWhitespace || (quotationMarks & 1) == 1) && super.hasMoreTokens() ? super.nextToken() : null) == null) break;
        }
        return buffer.toString();
    }

    private static boolean isEscapedAtPos(String token, int pos) {
        int escapeCount = 0;
        --pos;
        while (pos >= 0 && token.charAt(pos) == '\\') {
            ++escapeCount;
            --pos;
        }
        return escapeCount & true;
    }
}

