/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import gnu.trove.TIntProcedure;

class AddonlyIntSet {
    private int size;
    private int[] data;
    private int shift;
    private int mask;
    private boolean hasZeroKey;

    public AddonlyIntSet() {
        this(21);
    }

    public AddonlyIntSet(int expectedSize) {
        int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
        this.shift = Integer.numberOfLeadingZeros(powerOfTwo) + 1;
        this.mask = powerOfTwo - 1;
        this.data = new int[powerOfTwo];
    }

    public int size() {
        return this.size;
    }

    private int hash(int h, int[] a) {
        h ^= h >>> 20 ^ h >>> 12;
        return (h ^ h >>> 7 ^ h >>> 4) & this.mask;
    }

    public void add(int key) {
        if (key == 0) {
            if (!this.hasZeroKey) {
                ++this.size;
            }
            this.hasZeroKey = true;
            return;
        }
        if (this.size >= 2 * this.data.length / 3) {
            this.rehash();
        }
        if (this.doPut(this.data, key)) {
            ++this.size;
        }
    }

    private boolean doPut(int[] a, int o) {
        int obj;
        int index = this.hash(o, a);
        while ((obj = a[index]) != 0 && obj != o) {
            if (index == 0) {
                index = a.length;
            }
            --index;
        }
        a[index] = o;
        return obj == 0;
    }

    private void rehash() {
        --this.shift;
        int[] b = new int[this.data.length << 1];
        this.mask = b.length - 1;
        int i = this.data.length;
        while (--i >= 0) {
            int ns = this.data[i];
            if (ns == 0) continue;
            this.doPut(b, ns);
        }
        this.data = b;
    }

    public boolean contains(int key) {
        int v;
        if (key == 0) {
            return this.hasZeroKey;
        }
        int index = this.hash(key, this.data);
        while ((v = this.data[index]) != 0) {
            if (v == key) {
                return true;
            }
            if (index == 0) {
                index = this.data.length;
            }
            --index;
        }
        return false;
    }

    public boolean forEach(TIntProcedure consumer) {
        if (this.hasZeroKey && !consumer.execute(0)) {
            return false;
        }
        for (int o : this.data) {
            if (o == 0 || consumer.execute(o)) continue;
            return false;
        }
        return true;
    }
}

