/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AntivirusDetector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class OpenChannelsCache {
    private final int myCacheSizeLimit;
    private final String myAccessMode;
    private final Map<File, ChannelDescriptor> myCache;

    public OpenChannelsCache(int cacheSizeLimit, @NonNls String accessMode) {
        this.myCacheSizeLimit = cacheSizeLimit;
        this.myAccessMode = accessMode;
        this.myCache = new LinkedHashMap<File, ChannelDescriptor>(cacheSizeLimit, 0.5f, true);
    }

    public synchronized RandomAccessFile getChannel(File ioFile) throws FileNotFoundException {
        ChannelDescriptor descriptor = this.myCache.get(ioFile);
        if (descriptor == null) {
            this.dropOvercache();
            descriptor = new ChannelDescriptor(ioFile, this.myAccessMode);
            this.myCache.put(ioFile, descriptor);
        }
        descriptor.lock();
        return descriptor.getChannel();
    }

    private void dropOvercache() {
        int dropCount = this.myCache.size() - this.myCacheSizeLimit;
        if (dropCount >= 0) {
            ArrayList<File> keysToDrop = new ArrayList<File>();
            for (Map.Entry<File, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (File file : keysToDrop) {
                this.closeChannel(file);
            }
        }
    }

    public synchronized void releaseChannel(File ioFile) {
        ChannelDescriptor descriptor = this.myCache.get(ioFile);
        assert (descriptor != null);
        descriptor.unlock();
    }

    public synchronized void closeChannel(File ioFile) {
        final ChannelDescriptor descriptor = this.myCache.remove(ioFile);
        if (descriptor != null) {
            assert (!descriptor.isLocked());
            AntivirusDetector.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        descriptor.getChannel().close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private static class ChannelDescriptor {
        private int lockCount = 0;
        private final RandomAccessFile myChannel;
        private final File myFile;

        public ChannelDescriptor(File file, String accessMode) throws FileNotFoundException {
            this.myFile = file;
            this.myChannel = new RandomAccessFile(file, accessMode);
        }

        public void lock() {
            ++this.lockCount;
        }

        public void unlock() {
            --this.lockCount;
        }

        public boolean isLocked() {
            return this.lockCount != 0;
        }

        public RandomAccessFile getChannel() {
            return this.myChannel;
        }
    }
}

