/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2ArtifactParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private final String repoUrl;

    public P2ArtifactParser(P2Descriptor p2Descriptor, String string) {
        this.p2Descriptor = p2Descriptor;
        this.repoUrl = string;
    }

    @Override
    public void parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(this.p2Descriptor, this.repoUrl);
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    static class ArtifactHandler
    extends DelegetingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String CLASSIFIER = "classifier";
        private static final String ID = "id";
        private static final String VERSION = "version";
        P2Artifact p2Artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            Version version;
            String string = attributes.getValue(ID);
            try {
                version = new Version(attributes.getValue(VERSION));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version attribute on artifact '" + string + "': " + attributes.getValue(VERSION) + " (" + parseException.getMessage() + ")");
            }
            String string2 = attributes.getValue(CLASSIFIER);
            this.p2Artifact = new P2Artifact(string, version, string2);
        }
    }

    static class ArtifactsHandler
    extends DelegetingHandler {
        private static final String ARTIFACTS = "artifacts";

        public ArtifactsHandler(final P2Descriptor p2Descriptor, final Map map, final String string) {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    P2Artifact p2Artifact = ((ArtifactHandler)delegetingHandler).p2Artifact;
                    String string2 = (String)map.get(p2Artifact.getClassifier());
                    string2 = string2.replaceAll("\\$\\{repoUrl\\}", string);
                    p2Descriptor.addArtifactUrl(p2Artifact.getClassifier(), p2Artifact.getId(), p2Artifact.getVersion(), string2);
                }
            });
        }
    }

    static class RuleHandler
    extends DelegetingHandler {
        private static final String RULE = "rule";
        private static final String FILTER = "filter";
        private static final String OUTPUT = "output";
        private String filter;
        private String output;

        public RuleHandler() {
            super(RULE);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.filter = attributes.getValue(FILTER);
            this.output = attributes.getValue(OUTPUT);
        }
    }

    static class MappingsHandler
    extends DelegetingHandler {
        private static final String MAPPINGS = "mappings";
        private static final String SIZE = "size";
        Map outputByFilter;

        public MappingsHandler() {
            super(MAPPINGS);
            this.addChild(new RuleHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    MappingsHandler.this.outputByFilter.put(((RuleHandler)delegetingHandler).filter, ((RuleHandler)delegetingHandler).output);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.outputByFilter = new HashMap(n);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        private Map patternsByClassifier = new HashMap();

        public RepositoryHandler(P2Descriptor p2Descriptor, String string) {
            super(REPOSITORY);
            this.addChild(new MappingsHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    for (Map.Entry entry : ((MappingsHandler)delegetingHandler).outputByFilter.entrySet()) {
                        String string = (String)entry.getKey();
                        if (string.startsWith("(& (classifier=") && string.endsWith("")) {
                            String string2 = string.substring(15, string.length() - 2);
                            RepositoryHandler.this.patternsByClassifier.put(string2, entry.getValue());
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                }
            });
            this.addChild(new ArtifactsHandler(p2Descriptor, this.patternsByClassifier, string), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }
    }
}

