/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.EncrytedProperties;
import org.apache.ivy.util.Message;

public final class CredentialsUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials promptCredentials(Credentials credentials, File file) {
        if ((credentials = CredentialsUtil.loadPassfile(credentials, file)).getUserName() != null && credentials.getPasswd() != null) {
            return credentials;
        }
        CredentialPanel credentialPanel = new CredentialPanel(credentials, file);
        if (JOptionPane.showOptionDialog(null, credentialPanel, credentials.getHost() + " credentials", 2, 0, new ImageIcon(Ivy.class.getResource("logo.png")), null, new Integer(0)) == 0) {
            String string = credentialPanel.userNameField.getText();
            String string2 = credentialPanel.passwordField.getText();
            if (credentialPanel.rememberDataCB.isSelected()) {
                EncrytedProperties encrytedProperties = new EncrytedProperties();
                ((Properties)encrytedProperties).setProperty("username", string);
                ((Properties)encrytedProperties).setProperty("passwd", string2);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    encrytedProperties.store(fileOutputStream, "");
                }
                catch (Exception exception) {
                    Message.warn("error occurred while saving password file " + file + ": " + exception);
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            credentials = new Credentials(credentials.getRealm(), credentials.getHost(), string, string2);
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials loadPassfile(Credentials credentials, File file) {
        if (file != null && file.exists()) {
            EncrytedProperties encrytedProperties = new EncrytedProperties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                encrytedProperties.load(fileInputStream);
                String string = credentials.getUserName();
                String string2 = credentials.getPasswd();
                if (string == null) {
                    string = ((Properties)encrytedProperties).getProperty("username");
                }
                if (string2 == null) {
                    string2 = ((Properties)encrytedProperties).getProperty("passwd");
                }
                Credentials credentials2 = new Credentials(credentials.getRealm(), credentials.getHost(), string, string2);
                return credentials2;
            }
            catch (IOException iOException) {
                Message.warn("error occurred while loading password file " + file + ": " + iOException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return credentials;
    }

    private CredentialsUtil() {
    }

    private static final class CredentialPanel
    extends JPanel {
        private static final int FIELD_LENGTH = 20;
        private JTextField userNameField = new JTextField(20);
        private JTextField passwordField = new JPasswordField(20);
        private JCheckBox rememberDataCB = new JCheckBox("remember my information");

        CredentialPanel(Credentials credentials, File file) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 2;
            String string = credentials.getRealm() != null ? "Enter username and password for \"" + credentials.getRealm() + "\" at " + credentials.getHost() : "Enter username and password for " + credentials.getHost();
            this.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)new JLabel("username: "), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.userNameField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            if (credentials.getUserName() != null) {
                this.userNameField.setText(credentials.getUserName());
            }
            if (credentials.getPasswd() == null) {
                this.add((Component)new JLabel("passwd:  "), gridBagConstraints);
                gridBagConstraints.gridx = 2;
                this.add((Component)this.passwordField, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                ++gridBagConstraints.gridy;
            } else {
                this.passwordField.setText(credentials.getPasswd());
            }
            if (file != null) {
                gridBagConstraints.gridwidth = 2;
                this.add((Component)this.rememberDataCB, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.gridwidth = 2;
            this.add((Component)new JLabel(), gridBagConstraints);
        }
    }
}

