/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import sbt.io.Using;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Hash$ {
    public static Hash$ MODULE$;
    private final int BufferSize;

    static {
        new Hash$();
    }

    private int BufferSize() {
        return this.BufferSize;
    }

    public String toHex(byte[] bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).indices().foreach((Function1 & java.io.Serializable & Serializable)i -> Hash$.$anonfun$toHex$1(bytes, buffer, BoxesRunTime.unboxToInt((Object)i)));
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] fromHex(String hex) {
        void var2_2;
        Predef$.MODULE$.require((hex.length() & 1) == 0, (Function0 & java.io.Serializable & Serializable)() -> "Hex string must have length 2n.");
        byte[] array = new byte[hex.length() >> 1];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), hex.length()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            char c1 = hex.charAt(i);
            char c2 = hex.charAt(i + 1);
            array$1[i >> 1] = (byte)(MODULE$.fromHex(c1) << 4 | MODULE$.fromHex(c2));
        });
        return var2_2;
    }

    public String halve(String s) {
        return s.length() > 3 ? s.substring(0, s.length() / 2) : s;
    }

    public String trimHashString(String s, int i) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(this.toHex(this.apply(s)))).take(i);
    }

    public String halfHashString(String s) {
        return this.halve(this.toHex(this.apply(s)));
    }

    public byte[] apply(String s) {
        return this.apply(s.getBytes("UTF-8"));
    }

    public byte[] apply(byte[] as) {
        return this.apply(new ByteArrayInputStream(as));
    }

    public byte[] apply(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & java.io.Serializable & Serializable)stream -> MODULE$.apply((InputStream)stream));
    }

    public byte[] apply(URL url) {
        return (byte[])Using$.MODULE$.urlInputStream().apply(url, (Function1 & java.io.Serializable & Serializable)stream -> MODULE$.apply((InputStream)stream));
    }

    public byte[] contentsIfLocal(URI uri) {
        String string = uri.getScheme();
        String string2 = "file";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.apply(uri.toURL()) : this.apply(uri.normalize().toString());
    }

    public byte[] apply(InputStream stream) {
        byte[] byArray;
        MessageDigest digest = MessageDigest.getInstance("SHA");
        try {
            DigestInputStream dis = new DigestInputStream(stream, digest);
            byte[] buffer = new byte[this.BufferSize()];
            while (dis.read(buffer) >= 0) {
            }
            dis.close();
            byArray = digest.digest();
        }
        finally {
            stream.close();
        }
        return byArray;
    }

    private char toHex(byte b) {
        Predef$.MODULE$.require(b >= 0 && b <= 15, (Function0 & java.io.Serializable & Serializable)() -> "Byte " + b + " was not between 0 and 15");
        return b < 10 ? (char)(48 + b) : (char)(97 + (b - 10));
    }

    /*
     * WARNING - void declaration
     */
    private int fromHex(char c) {
        void var2_2;
        int n;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = c - 97 + 10;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 65 + 10;
        } else {
            throw new RuntimeException("Invalid hex character: '" + c + "'.");
        }
        int b = n;
        return (int)var2_2;
    }

    public static final /* synthetic */ StringBuilder $anonfun$toHex$1(byte[] bytes$1, StringBuilder buffer$1, int i) {
        int b = bytes$1[i];
        int bi = b < 0 ? b + 256 : b;
        buffer$1.append(MODULE$.toHex((byte)(bi >>> 4)));
        return buffer$1.append(MODULE$.toHex((byte)(bi & 0xF)));
    }

    private Hash$() {
        MODULE$ = this;
        this.BufferSize = 8192;
    }
}

