/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.extendable.DefaultExtendableItem;

public class Configuration
extends DefaultExtendableItem
implements InheritableItem {
    private String name;
    private String description;
    private String[] extendsFrom;
    private Configuration$Visibility visibility;
    private boolean transitive = true;
    private String deprecated;
    private ModuleRevisionId sourceModule;

    public static Collection findConfigurationExtending(String string, Configuration[] configurationArray) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i] == null || !Arrays.asList(configurationArray[i].extendsFrom).contains(string)) continue;
            arrayList.add(configurationArray[i]);
            arrayList.addAll(Configuration.findConfigurationExtending(configurationArray[i].name, configurationArray));
        }
        return arrayList;
    }

    public Configuration(String string) {
        this(string, Configuration$Visibility.PUBLIC, null, null, true, null);
    }

    public Configuration(Configuration configuration, ModuleRevisionId moduleRevisionId) {
        this(configuration.getAttributes(), configuration.getQualifiedExtraAttributes(), configuration.name, configuration.getVisibility(), configuration.description, configuration.extendsFrom, configuration.transitive, configuration.deprecated, moduleRevisionId);
    }

    public Configuration(String string, Configuration$Visibility configuration$Visibility, String string2, String[] stringArray, boolean bl, String string3) {
        this(null, null, string, configuration$Visibility, string2, stringArray, bl, string3, null);
    }

    private Configuration(Map map2, Map map3, String string, Configuration$Visibility configuration$Visibility, String string2, String[] stringArray, boolean bl, String string3, ModuleRevisionId moduleRevisionId) {
        super(map2, map3);
        if (string == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (configuration$Visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this.name = string;
        this.visibility = configuration$Visibility;
        this.description = string2;
        if (stringArray == null) {
            this.extendsFrom = new String[0];
        } else {
            this.extendsFrom = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.extendsFrom[i] = stringArray[i].trim();
            }
        }
        this.transitive = bl;
        this.deprecated = string3;
        this.sourceModule = moduleRevisionId;
    }

    public final String getDeprecated() {
        return this.deprecated;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String[] getExtends() {
        return this.extendsFrom;
    }

    public final String getName() {
        return this.name;
    }

    public Configuration$Visibility getVisibility() {
        return this.visibility;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public final ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Configuration)) {
            return false;
        }
        return ((Configuration)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final void replaceWildcards(ModuleDescriptor moduleDescriptor) {
        if (this != moduleDescriptor.getConfiguration(this.name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < this.extendsFrom.length; ++i) {
            if ("*".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, null, linkedHashSet);
                continue;
            }
            if ("*(public)".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, Configuration$Visibility.PUBLIC, linkedHashSet);
                continue;
            }
            if ("*(private)".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, Configuration$Visibility.PRIVATE, linkedHashSet);
                continue;
            }
            linkedHashSet.add(this.extendsFrom[i]);
        }
        this.extendsFrom = linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void addOther(Configuration[] configurationArray, Configuration$Visibility configuration$Visibility, Set set) {
        for (int i = 0; i < configurationArray.length; ++i) {
            String string = configurationArray[i].name;
            if (this.name.equals(string) || configuration$Visibility != null && !configuration$Visibility.equals(configurationArray[i].getVisibility())) continue;
            set.add(string);
        }
    }
}

