/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.media.Buffer;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;

public class BufferToBufferedImage
extends BufferToImage {
    public BufferToBufferedImage() throws ClassNotFoundException {
        super(null);
        Class.forName("java.awt.Graphics2D");
    }

    public BufferToBufferedImage(VideoFormat videoFormat) throws ClassNotFoundException {
        super(videoFormat);
        Class.forName("java.awt.Graphics2D");
    }

    public Image createImage(Buffer buffer) {
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        Object object = buffer.getData();
        int n = rGBFormat.getRedMask();
        int n2 = rGBFormat.getGreenMask();
        int n3 = rGBFormat.getBlueMask();
        int[] nArray = new int[]{n, n2, n3};
        DataBufferInt dataBufferInt = new DataBufferInt((int[])object, rGBFormat.getLineStride() * rGBFormat.getSize().height);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, rGBFormat.getLineStride(), rGBFormat.getSize().height, nArray);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
        DirectColorModel directColorModel = new DirectColorModel(24, n, n2, n3);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        BufferedImage bufferedImage2 = affineTransformOp.createCompatibleDestImage(bufferedImage, directColorModel);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

