/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.ECDH;
import com.jcraft.jsch.jce.KeyPairGenECDSA;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;

public class ECDHN
implements ECDH {
    byte[] Q_array;
    ECPublicKey publicKey;
    private KeyAgreement myKeyAgree;
    private static BigInteger two = BigInteger.ONE.add(BigInteger.ONE);
    private static BigInteger three = two.add(BigInteger.ONE);

    @Override
    public void init(int n) throws Exception {
        this.myKeyAgree = KeyAgreement.getInstance("ECDH");
        KeyPairGenECDSA keyPairGenECDSA = new KeyPairGenECDSA();
        keyPairGenECDSA.init(n);
        this.publicKey = keyPairGenECDSA.getPublicKey();
        byte[] byArray = keyPairGenECDSA.getR();
        byte[] byArray2 = keyPairGenECDSA.getS();
        this.Q_array = this.toPoint(byArray, byArray2);
        this.myKeyAgree.init(keyPairGenECDSA.getPrivateKey());
    }

    @Override
    public byte[] getQ() throws Exception {
        return this.Q_array;
    }

    @Override
    public byte[] getSecret(byte[] byArray, byte[] byArray2) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        ECPoint eCPoint = new ECPoint(new BigInteger(1, byArray), new BigInteger(1, byArray2));
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, this.publicKey.getParams());
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        this.myKeyAgree.doPhase(publicKey, true);
        return this.myKeyAgree.generateSecret();
    }

    @Override
    public boolean validate(byte[] byArray, byte[] byArray2) throws Exception {
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        if (eCPoint.equals(ECPoint.POINT_INFINITY)) {
            return false;
        }
        ECParameterSpec eCParameterSpec = this.publicKey.getParams();
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        BigInteger bigInteger3 = ((ECFieldFp)ellipticCurve.getField()).getP();
        BigInteger bigInteger4 = bigInteger3.subtract(BigInteger.ONE);
        if (bigInteger.compareTo(bigInteger4) > 0 || bigInteger2.compareTo(bigInteger4) > 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger.multiply(ellipticCurve.getA()).add(ellipticCurve.getB()).add(bigInteger.modPow(three, bigInteger3)).mod(bigInteger3);
        BigInteger bigInteger6 = bigInteger2.modPow(two, bigInteger3);
        return bigInteger6.equals(bigInteger5);
    }

    private byte[] toPoint(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
        return byArray3;
    }

    private byte[] insert0(byte[] byArray) {
        if ((byArray[0] & 0x80) == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.bzero(byArray);
        return byArray2;
    }

    private byte[] chop0(byte[] byArray) {
        if (byArray[0] != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        this.bzero(byArray);
        return byArray2;
    }

    private void bzero(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }
}

