/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.NullTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SelectAllCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.RedoCommand;
import CH.ifa.draw.util.SerializationStorageFormat;
import CH.ifa.draw.util.StandardStorageFormat;
import CH.ifa.draw.util.StandardVersionControlStrategy;
import CH.ifa.draw.util.StorageFormat;
import CH.ifa.draw.util.StorageFormatManager;
import CH.ifa.draw.util.UndoCommand;
import CH.ifa.draw.util.UndoManager;
import CH.ifa.draw.util.UndoableCommand;
import CH.ifa.draw.util.VersionControlStrategy;
import CH.ifa.draw.util.VersionManagement;
import CH.ifa.draw.util.VersionRequester;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class DrawApplication
extends JFrame
implements DrawingEditor,
PaletteListener,
VersionRequester {
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    private DrawingView fView;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private String fApplicationName;
    private StorageFormatManager fStorageFormatManager;
    private UndoManager myUndoManager;
    protected static String fgUntitled = "untitled";
    private final EventListenerList listenerList = new EventListenerList();
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    protected static int winCount = 0;
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;

    public DrawApplication() {
        this("JHotDraw");
    }

    public DrawApplication(String title) {
        super(title);
        this.setApplicationName(title);
        ++winCount;
    }

    protected DrawApplication createApplication() {
        return new DrawApplication();
    }

    public void newView() {
        if (this.view() == null) {
            return;
        }
        DrawApplication window = this.createApplication();
        window.open(this.view());
        if (this.view().drawing().getTitle() != null) {
            window.setDrawingTitle(this.view().drawing().getTitle() + " (View)");
        } else {
            window.setDrawingTitle(this.getDefaultDrawingTitle() + " (View)");
        }
    }

    public void newWindow(Drawing initialDrawing) {
        DrawApplication window = this.createApplication();
        if (initialDrawing == null) {
            window.open();
        } else {
            window.open(this.createDrawingView(initialDrawing));
        }
    }

    public void open() {
        this.open(this.createInitialDrawingView());
    }

    protected void open(DrawingView newDrawingView) {
        this.getVersionControlStrategy().assertCompatibleVersion();
        this.setUndoManager(new UndoManager());
        this.fIconkit = new Iconkit(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.fStatusLine = this.createStatusLine();
        this.getContentPane().add((Component)this.fStatusLine, "South");
        this.setTool(new NullTool(this), "");
        this.setView(newDrawingView);
        JComponent contents = this.createContents(this.view());
        contents.setAlignmentX(0.0f);
        JToolBar tools = this.createToolPalette();
        this.createTools(tools);
        JPanel activePanel = new JPanel();
        activePanel.setAlignmentX(0.0f);
        activePanel.setAlignmentY(0.0f);
        activePanel.setLayout(new BorderLayout());
        activePanel.add((Component)tools, "North");
        activePanel.add((Component)contents, "Center");
        this.getContentPane().add((Component)activePanel, "Center");
        JMenuBar mb = new JMenuBar();
        this.createMenus(mb);
        this.setJMenuBar(mb);
        Dimension d = this.defaultSize();
        if (d.width > mb.getPreferredSize().width) {
            this.setSize(d.width, d.height);
        } else {
            this.setSize(mb.getPreferredSize().width, d.height);
        }
        this.addListeners();
        this.setVisible(true);
        this.fStorageFormatManager = this.createStorageFormatManager();
        this.toolDone();
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                DrawApplication.this.exit();
            }
        });
    }

    protected void createMenus(JMenuBar mb) {
        this.addMenuIfPossible(mb, this.createFileMenu());
        this.addMenuIfPossible(mb, this.createEditMenu());
        this.addMenuIfPossible(mb, this.createAlignmentMenu());
        this.addMenuIfPossible(mb, this.createAttributesMenu());
        this.addMenuIfPossible(mb, this.createDebugMenu());
    }

    protected void addMenuIfPossible(JMenuBar mb, JMenu newMenu) {
        if (newMenu != null) {
            mb.add(newMenu);
        }
    }

    protected JMenu createFileMenu() {
        CommandMenu menu = new CommandMenu("File");
        AbstractCommand cmd = new AbstractCommand("New", this, false){

            public void execute() {
                DrawApplication.this.promptNew();
            }
        };
        menu.add(cmd, new MenuShortcut(110));
        cmd = new AbstractCommand("Open...", this, false){

            public void execute() {
                DrawApplication.this.promptOpen();
            }
        };
        menu.add(cmd, new MenuShortcut(111));
        cmd = new AbstractCommand("Save As...", this, true){

            public void execute() {
                DrawApplication.this.promptSaveAs();
            }
        };
        menu.add(cmd, new MenuShortcut(115));
        menu.addSeparator();
        cmd = new AbstractCommand("Print...", this, true){

            public void execute() {
                DrawApplication.this.print();
            }
        };
        menu.add(cmd, new MenuShortcut(112));
        menu.addSeparator();
        cmd = new AbstractCommand("Exit", this, true){

            public void execute() {
                DrawApplication.this.exit();
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        menu.add(new UndoableCommand(new SelectAllCommand("Select All", this)), new MenuShortcut(97));
        menu.addSeparator();
        menu.add(new UndoableCommand(new CutCommand("Cut", this)), new MenuShortcut(120));
        menu.add(new CopyCommand("Copy", this), new MenuShortcut(99));
        menu.add(new UndoableCommand(new PasteCommand("Paste", this)), new MenuShortcut(118));
        menu.addSeparator();
        menu.add(new UndoableCommand(new DuplicateCommand("Duplicate", this)), new MenuShortcut(100));
        menu.add(new UndoableCommand(new DeleteCommand("Delete", this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new GroupCommand("Group", this)));
        menu.add(new UndoableCommand(new UngroupCommand("Ungroup", this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new SendToBackCommand("Send to Back", this)));
        menu.add(new UndoableCommand(new BringToFrontCommand("Bring to Front", this)));
        menu.addSeparator();
        menu.add(new UndoCommand("Undo Command", this));
        menu.add(new RedoCommand("Redo Command", this));
        return menu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu menu = new CommandMenu("Align");
        menu.addCheckItem(new ToggleGridCommand("Toggle Snap to Grid", (DrawingEditor)this, new Point(4, 4)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.LEFTS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.CENTERS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.RIGHTS, (DrawingEditor)this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.TOPS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.MIDDLES, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.BOTTOMS, (DrawingEditor)this)));
        return menu;
    }

    protected JMenu createDebugMenu() {
        CommandMenu menu = new CommandMenu("Debug");
        AbstractCommand cmd = new AbstractCommand("Simple Update", this){

            public void executable() {
                this.view().setDisplayUpdate(new SimpleUpdateStrategy());
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("Buffered Update", this){

            public void executable() {
                this.view().setDisplayUpdate(new BufferedUpdateStrategy());
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", "FillColor"));
        menu.add(this.createColorMenu("Pen Color", "FrameColor"));
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", "TextColor"));
        return menu;
    }

    protected JMenu createColorMenu(String title, String attribute) {
        CommandMenu menu = new CommandMenu(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this)));
        }
        return menu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu menu = new CommandMenu("Arrow");
        menu.add(new UndoableCommand(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this)));
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < fonts.length; ++i) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this)));
        }
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu menu = new CommandMenu("Font Style");
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this)));
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = new CommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < sizes.length; ++i) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(Integer.toString(sizes[i]), "FontSize", new Integer(sizes[i]), this)));
        }
        return menu;
    }

    public JMenu createLookAndFeelMenu() {
        CommandMenu menu = new CommandMenu("Look'n'Feel");
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            final String lnfClassName = lafs[i].getClassName();
            AbstractCommand cmd = new AbstractCommand(lafs[i].getName(), this){

                public void execute() {
                    DrawApplication.this.newLookAndFeel(lnfClassName);
                }
            };
            menu.add(cmd);
        }
        return menu;
    }

    protected JToolBar createToolPalette() {
        JToolBar palette = new JToolBar();
        palette.setBackground(Color.lightGray);
        return palette;
    }

    protected void createTools(JToolBar palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected DrawingView createDrawingView() {
        DrawingView createdDrawingView = this.createDrawingView(this.createDrawing());
        createdDrawingView.drawing().setTitle(this.getDefaultDrawingTitle());
        return createdDrawingView;
    }

    protected DrawingView createDrawingView(Drawing newDrawing) {
        Dimension d = this.getDrawingViewSize();
        StandardDrawingView newDrawingView = new StandardDrawingView(this, d.width, d.height);
        newDrawingView.setDrawing(newDrawing);
        this.fireViewCreatedEvent(newDrawingView);
        return newDrawingView;
    }

    protected DrawingView createInitialDrawingView() {
        return this.createDrawingView();
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(800, 800);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected JComponent createContents(DrawingView view) {
        if (view instanceof Component) {
            JScrollPane sp = new JScrollPane((Component)((Object)view));
            sp.setVerticalScrollBarPolicy(22);
            sp.setHorizontalScrollBarPolicy(32);
            return sp;
        }
        return new JPanel();
    }

    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new StandardStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        storageFormatManager.addStorageFormat(new SerializationStorageFormat());
        return storageFormatManager;
    }

    protected final void setStorageFormatManager(StorageFormatManager storageFormatManager) {
        this.fStorageFormatManager = storageFormatManager;
    }

    public StorageFormatManager getStorageFormatManager() {
        return this.fStorageFormatManager;
    }

    protected Dimension defaultSize() {
        return new Dimension(600, 450);
    }

    protected JTextField createStatusLine() {
        JTextField field = new JTextField("No Tool", 40);
        field.setBackground(Color.white);
        field.setEditable(false);
        return field;
    }

    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton button, boolean inside) {
        ToolButton toolButton = (ToolButton)button;
        if (inside) {
            this.showStatus(toolButton.name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    protected void setView(DrawingView newView) {
        DrawingView oldView = this.fView;
        this.fView = newView;
        this.fireViewSelectionChangedEvent(oldView, this.view());
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public void toolDone() {
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void figureSelectionChanged(DrawingView view) {
        JMenu attributeMenu;
        CommandMenu alignmentMenu;
        JMenuBar mb = this.getJMenuBar();
        CommandMenu editMenu = (CommandMenu)mb.getMenu(1);
        if (editMenu != null) {
            editMenu.checkEnabled();
        }
        if ((alignmentMenu = (CommandMenu)mb.getMenu(2)) != null) {
            alignmentMenu.checkEnabled();
        }
        if ((attributeMenu = mb.getMenu(3)) != null) {
            for (int i = 0; i < attributeMenu.getItemCount(); ++i) {
                JMenuItem currentMenu = attributeMenu.getItem(i);
                if (!(currentMenu instanceof CommandMenu)) continue;
                ((CommandMenu)currentMenu).checkEnabled();
            }
        }
    }

    public void addViewChangeListener(ViewChangeListener vsl) {
        this.listenerList.add(ViewChangeListener.class, vsl);
    }

    public void removeViewChangeListener(ViewChangeListener vsl) {
        this.listenerList.remove(ViewChangeListener.class, vsl);
    }

    protected void fireViewSelectionChangedEvent(DrawingView oldView, DrawingView newView) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) continue;
            vsl = (ViewChangeListener)listeners[i + 1];
            vsl.viewSelectionChanged(oldView, newView);
        }
    }

    protected void fireViewCreatedEvent(DrawingView view) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) continue;
            vsl = (ViewChangeListener)listeners[i + 1];
            vsl.viewCreated(view);
        }
    }

    protected void fireViewDestroyingEvent(DrawingView view) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) continue;
            vsl = (ViewChangeListener)listeners[i + 1];
            vsl.viewDestroying(view);
        }
    }

    public void showStatus(String string) {
        this.fStatusLine.setText(string);
    }

    public void setTool(Tool t, String name) {
        if (this.tool() != null && this.tool().isActive()) {
            this.tool().deactivate();
        }
        this.fTool = t;
        if (this.tool() != null) {
            this.showStatus(name);
            this.tool().activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void exit() {
        this.destroy();
        this.setVisible(false);
        this.dispose();
        if (--winCount == 0) {
            System.exit(0);
        }
    }

    protected void destroy() {
    }

    public void promptNew() {
        this.toolDone();
        this.view().setDrawing(this.createDrawing());
        this.view().drawing().setTitle(this.getDefaultDrawingTitle());
    }

    public void promptOpen() {
        this.toolDone();
        JFileChooser openDialog = this.createOpenFileChooser();
        this.getStorageFormatManager().registerFileFilters(openDialog);
        if (openDialog.showOpenDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(openDialog.getFileFilter());
            if (foundFormat != null) {
                this.loadDrawing(foundFormat, openDialog.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + openDialog.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAs() {
        this.toolDone();
        JFileChooser saveDialog = this.createSaveFileChooser();
        this.getStorageFormatManager().registerFileFilters(saveDialog);
        if (saveDialog.showSaveDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
            if (foundFormat != null) {
                this.saveDrawing(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
            }
        }
    }

    protected JFileChooser createOpenFileChooser() {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setDialogTitle("Open File...");
        return openDialog;
    }

    protected JFileChooser createSaveFileChooser() {
        JFileChooser saveDialog = new JFileChooser();
        saveDialog.setDialogTitle("Save File...");
        return saveDialog;
    }

    public void print() {
        this.tool().deactivate();
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Drawing", null);
        if (printJob != null) {
            Graphics pg = printJob.getGraphics();
            if (pg != null) {
                ((StandardDrawingView)this.view()).printAll(pg);
                pg.dispose();
            }
            printJob.end();
        }
        this.tool().activate();
    }

    protected void saveDrawing(StorageFormat storeFormat, String file) {
        if (this.view() == null) {
            return;
        }
        try {
            String name = storeFormat.store(file, this.view().drawing());
            this.view().drawing().setTitle(name);
            this.setDrawingTitle(name);
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    protected void loadDrawing(StorageFormat restoreFormat, String file) {
        try {
            Drawing restoredDrawing = restoreFormat.restore(file);
            if (restoredDrawing != null) {
                restoredDrawing.setTitle(file);
                this.newWindow(restoredDrawing);
            } else {
                this.showStatus("Unknown file type: could not open file '" + file + "'");
            }
        }
        catch (IOException e) {
            this.showStatus("Error: " + e);
        }
    }

    private void newLookAndFeel(String landf) {
        try {
            UIManager.setLookAndFeel(landf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void setDrawingTitle(String drawingTitle) {
        if (this.getDefaultDrawingTitle().equals(drawingTitle)) {
            this.setTitle(this.getApplicationName());
        } else {
            this.setTitle(this.getApplicationName() + " - " + drawingTitle);
        }
    }

    protected String getDrawingTitle() {
        return this.view().drawing().getTitle();
    }

    public void setApplicationName(String applicationName) {
        this.fApplicationName = applicationName;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }

    protected void setUndoManager(UndoManager newUndoManager) {
        this.myUndoManager = newUndoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected VersionControlStrategy getVersionControlStrategy() {
        return new StandardVersionControlStrategy(this);
    }

    public String[] getRequiredVersions() {
        String[] requiredVersions = new String[]{VersionManagement.getPackageVersion(DrawApplication.class.getPackage())};
        return requiredVersions;
    }

    protected String getDefaultDrawingTitle() {
        return fgUntitled;
    }
}

