/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.JHotDrawRuntimeException;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends AbstractTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure myAddedFigure;
    private Figure fPrototype;

    public CreationTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor);
        this.fPrototype = prototype;
    }

    protected CreationTool(DrawingEditor newDrawingEditor) {
        super(newDrawingEditor);
        this.fPrototype = null;
    }

    public void activate() {
        super.activate();
        if (this.isUsable()) {
            this.view().setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.fAnchorPoint = new Point(x, y);
        this.fCreatedFigure = this.createFigure();
        this.setAddedFigure(this.view().add(this.getCreatedFigure()));
        this.getAddedFigure().displayBox(this.fAnchorPoint, this.fAnchorPoint);
    }

    protected Figure createFigure() {
        if (this.fPrototype == null) {
            throw new JHotDrawRuntimeException("No protoype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        this.getAddedFigure().displayBox(this.fAnchorPoint, new Point(x, y));
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.getCreatedFigure().isEmpty()) {
            this.drawing().remove(this.getAddedFigure());
            this.setUndoActivity(null);
        } else {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
        }
        this.fCreatedFigure = null;
        this.setAddedFigure(null);
        this.editor().toolDone();
    }

    protected Figure getCreatedFigure() {
        return this.fCreatedFigure;
    }

    private void setCreatedFigure(Figure newCreatedFigure) {
        this.fCreatedFigure = newCreatedFigure;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }

    protected Point getAnchorPoint() {
        return this.fAnchorPoint;
    }
}

