/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.figures.AbstractLineDecoration;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Geom;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.ColorConverter;
import ch.ehi.umleditor.umldrawingtools.ModelElementUI;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umlpresentation.PresentationAssocClass;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.WayPoint;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.ColorChooserDialog;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

abstract class EdgeFigure
extends LineConnection
implements ModelElementUI {
    private ClassDiagramView classDiagram = null;
    protected PresentationEdge edge = null;
    protected ModelElement modelElement = null;
    private EdgeFigure lastInvalidEdge = null;

    public EdgeFigure() {
        this.setLineColor(this.determineForegroundColor(null));
        this.showDecoration();
    }

    public EdgeFigure(ClassDiagramView classDiagram) {
        this();
        this.setClassDiagram(classDiagram);
    }

    protected JPopupMenu adaptPopupMenu(JPopupMenu popupMenu) {
        this.addSpecificationMenu(popupMenu);
        this.addSpecialMenu(popupMenu);
        this.addSelectInBrowserMenu(popupMenu);
        popupMenu.add(new JSeparator());
        this.addFormatMenu(popupMenu);
        this.addEditMenu(popupMenu);
        popupMenu.setLightWeightPopupEnabled(true);
        return popupMenu;
    }

    protected void addDeletionMenu(JPopupMenu popupMenu) {
        popupMenu.add(new AbstractAction(CommonUserAccess.getMniEditRemoveText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.removeVisually();
            }
        });
        popupMenu.add(new AbstractAction(REMOVE_IN_MODEL){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.removeInModel();
            }
        });
    }

    protected void addEditMenu(JPopupMenu popupMenu) {
        JMenu editMenu = new JMenu(CommonUserAccess.getMnuEditText());
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditCutText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.mniCut();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditCopyText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.mniCopy();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditPasteText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.mniPaste();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditRemoveText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.removeVisually();
            }
        });
        editMenu.add(new JSeparator());
        editMenu.add(new AbstractAction(REMOVE_IN_MODEL){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.removeInModel();
            }
        });
        popupMenu.add(editMenu);
    }

    protected void addFormatMenu(JPopupMenu popupMenu) {
        JMenu formatMenu = new JMenu(CommonUserAccess.getMnuFormatText());
        formatMenu.add(new AbstractAction(CommonUserAccess.getMniFormatFontText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.mniFont();
            }
        });
        formatMenu.add(new AbstractAction(CommonUserAccess.getMniFormatLineColorText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.mniLineColor();
            }
        });
        popupMenu.add(formatMenu);
    }

    protected void addModelElement(ModelElement relationship) {
        this.setModelElement(relationship);
        this.getEdge().addSubject(relationship);
        this.getClassDiagram().getDiagram().addPresentationElement(this.getEdge());
    }

    protected void addSelectInBrowserMenu(JPopupMenu popupMenu) {
        popupMenu.add(new JSeparator());
        popupMenu.add(new AbstractAction(ModelElementUI.SELECT_IN_BROWSER){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.selectInBrowser();
            }
        });
    }

    protected abstract void addSpecialMenu(JPopupMenu var1);

    protected void addSpecificationMenu(JPopupMenu popupMenu) {
        popupMenu.add(new AbstractAction(CommonUserAccess.getMniEditChangeWindowText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EdgeFigure.this.showSpecification();
            }
        });
    }

    protected final void connectNodes() {
        try {
            Vector wayPoints = new Vector();
            if (this.getEdge() == null) {
                Tracer.getInstance().developerWarning("edge not set");
            } else {
                Iterator iterator = this.getEdge().iteratorWayPoint();
                while (iterator.hasNext()) {
                    wayPoints.add(iterator.next());
                }
            }
            int x = 0;
            int y = 0;
            this.startPoint(x, y);
            Connector start = null;
            start = this.getModelElement() instanceof Generalization && this.getStartElement() instanceof Association ? this.getClassDiagram().findAssociationAttributeConnector(this.getStartElement(), x, y, this.getModelElement()) : this.getClassDiagram().findNodeConnector(this.getStartElement(), x, y);
            if (start == null) {
                Tracer.getInstance().developerWarning("AUTO-CORRECT: Missing StartNode->there must have been an improper deletion of nodes/edges before=>" + this.getSourceName(this.getStartElement()));
                this.removeVisually();
            } else if (this.getEdge().sizeEndpoint() == 2) {
                x = 0;
                y = 0;
                this.endPoint(x, y);
                Iterator iterator = this.getEdge().iteratorEndpoint();
                iterator.next();
                Object second = iterator.next();
                Connector end = null;
                end = second instanceof PresentationAssocClass && (this.getModelElement() instanceof RoleDef || this.getModelElement() instanceof Generalization) ? this.getClassDiagram().findAssociationAttributeConnector(this.getEndElement(), x, y, this.getModelElement()) : this.getClassDiagram().findNodeConnector(this.getEndElement(), x, y);
                if (end == null) {
                    Tracer.getInstance().developerWarning("AUTO-CORRECT: Missing EndNode->there must have been an improper deletion of nodes/edges before=>" + this.getSourceName(this.getEndElement()));
                    this.removeVisually();
                } else {
                    this.connectStart(start);
                    this.setEndConnector(end);
                    for (int i = 0; i < wayPoints.size(); ++i) {
                        WayPoint currentPoint = (WayPoint)wayPoints.get(i);
                        super.insertPointAt(new Point(currentPoint.getEast(), currentPoint.getSouth()), i + 1);
                    }
                    this.updateConnection();
                    this.endFigure().addFigureChangeListener(this);
                }
            } else if (this.getEdge().sizeEndpoint() == 1) {
                Tracer.getInstance().developerWarning("AUTO-CORRECT: 2 endpoints expected");
                this.removeVisually();
            }
        }
        catch (Throwable e) {
            Tracer.getInstance().developerWarning(e.toString());
        }
    }

    protected static WayPoint createWayPoint(Point p) {
        WayPoint wayPoint = (WayPoint)ElementFactory.createObject(WayPoint.class);
        wayPoint.setEast(p.x);
        wayPoint.setSouth(p.y);
        return wayPoint;
    }

    protected Color determineForegroundColor(PresentationEdge edge) {
        if (edge == null || edge.getForeground() == null) {
            return LauncherView.getSettings().getForegroundColor();
        }
        return ColorConverter.createColor(edge.getForeground());
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("POPUP_MENU")) {
            return this.adaptPopupMenu(new JPopupMenu());
        }
        if (name.equals("FontName") && this.getEdge() != null && this.getEdge().getFont() != null) {
            return this.getEdge().getFont();
        }
        return super.getAttribute(name);
    }

    protected ClassDiagramView getClassDiagram() {
        return this.classDiagram;
    }

    public PresentationEdge getEdge() {
        return this.edge;
    }

    protected abstract Element getEndElement();

    protected Font getFont() {
        String font = (String)this.getAttribute("FontName");
        if (font == null) {
            return LauncherView.getSettings().getFont();
        }
        return Font.decode(font);
    }

    protected final GeneralizableElement getGeneralizableElement(Figure figure) {
        return (GeneralizableElement)((NodeFigure)figure).getModelElement();
    }

    protected Color getLineColor() {
        Color color = (Color)this.getAttribute("FrameColor");
        if (color == null) {
            return LauncherView.getSettings().getForegroundColor();
        }
        return (Color)this.getAttribute("FrameColor");
    }

    @Override
    public ModelElement getModelElement() {
        return this.modelElement;
    }

    private String getSourceName(Element element) {
        String edgeName = StringUtils.getPureClassName(this.getClass()) + ":";
        if (element == null) {
            return edgeName + "<???>";
        }
        if (element instanceof ModelElement) {
            return edgeName + ((ModelElement)element).getName().getValue();
        }
        return edgeName + element.toString();
    }

    protected abstract Element getStartElement();

    protected int getWayPointIndex(int x, int y) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point p = this.pointAt(i);
            if (Geom.length(x, y, p.x, p.y) >= (long)LauncherView.getSettings().getConnectorZone().intValue()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insertPointAt(Point p, int index) {
        if (this.getEdge() != null) {
            super.insertPointAt(p, index);
            this.getEdge().addWayPoint(index - 1, EdgeFigure.createWayPoint(p));
        }
    }

    private void mniCopy() {
        LauncherView.getInstance().nyi("Copy");
    }

    private void mniCut() {
        LauncherView.getInstance().nyi("Cut");
    }

    private void mniFont() {
        LauncherView.getInstance().nyi("Font");
    }

    private void mniLineColor() {
        ColorChooserDialog dialog = new ColorChooserDialog((Frame)LauncherView.getInstance(), true);
        if (dialog.isSaved()) {
            this.setLineColor(dialog.getChosenColor());
        }
    }

    private void mniPaste() {
        LauncherView.getInstance().nyi("Paste");
    }

    @Override
    public void removeInModel() {
        try {
            this.removeVisually();
            if (this.getModelElement() != null) {
                ElementFactory.removeElement(this.getModelElement());
                this.setModelElement(null);
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, NodeFigure.REMOVE_IN_MODEL, null, this);
        }
    }

    @Override
    public void removePointAt(int i) {
        if (this.getEdge() != null) {
            super.removePointAt(i);
            this.getEdge().removeWayPoint(i - 1);
        }
    }

    @Override
    public void removeVisually() {
        try {
            if (this.getClassDiagram() != null) {
                this.getClassDiagram().remove(this);
                if (this.edge != null && this.getClassDiagram().getDiagram().containsPresentationElement(this.edge)) {
                    this.getClassDiagram().getDiagram().removePresentationElement(this.edge);
                }
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, CommonUserAccess.getMniEditRemoveText(), null, this);
        }
    }

    public void selectInBrowser() {
        LauncherView.getInstance().getPnlNavigation().selectElement(this.getModelElement());
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("FrameColor")) {
            if (this.getStartDecoration() != null) {
                ((AbstractLineDecoration)this.getStartDecoration()).setBorderColor((Color)value);
                this.changed();
            }
            if (this.getEndDecoration() != null) {
                ((AbstractLineDecoration)this.getEndDecoration()).setBorderColor((Color)value);
                this.changed();
            }
        }
        super.setAttribute(name, value);
    }

    private void setClassDiagram(ClassDiagramView classDiagram) {
        this.classDiagram = classDiagram;
    }

    public void setEdge(PresentationEdge edge, Figure start, Figure end) {
        this.edge = edge;
        this.getEdge().setForeground(ColorConverter.createColor(this.getLineColor()));
        edge.addEndpoint(((NodeFigure)start).getNode());
        edge.addEndpoint(((NodeFigure)end).getNode());
    }

    @Override
    protected void setEndConnector(Connector newEndConnector) {
        super.setEndConnector(newEndConnector);
    }

    protected void setFont(String font) {
        this.setAttribute("FontName", font);
        if (this.getEdge() != null && !this.getEdge().getFont().equalsIgnoreCase(font)) {
            this.getEdge().setFont(font);
        }
    }

    protected void setLineColor(Color color) {
        this.setAttribute("FrameColor", color);
        if (this.getEdge() != null && !ColorConverter.isSame(this.getEdge().getForeground(), color)) {
            this.getEdge().setForeground(ColorConverter.createColor(color));
        }
    }

    protected void setModelElement(ModelElement modelElement) {
        this.modelElement = modelElement;
    }

    @Override
    public void setPointAt(Point p, int index) {
        if (this.getEdge() != null) {
            super.setPointAt(p, index);
            if (index != 0 && index < this.pointCount() - 1) {
                this.getEdge().setWayPoint(index - 1, EdgeFigure.createWayPoint(p));
            }
        }
    }

    @Override
    protected void setStartConnector(Connector newStartConnector) {
        super.setStartConnector(newStartConnector);
    }

    protected void setToolView() {
        this.setClassDiagram((ClassDiagramView)((AbstractTool)LauncherView.getInstance().tool()).view());
    }

    protected void shouldWarn(String warning) {
        if (this.lastInvalidEdge == null || !this.lastInvalidEdge.equals(this)) {
            this.lastInvalidEdge = this;
            this.showIllegalRelationship(warning);
        }
        if (this.getClassDiagram() != null) {
            this.getClassDiagram().remove(this);
        }
    }

    protected void showDecoration() {
        this.setStartDecoration(null);
        this.setEndDecoration(null);
    }

    protected abstract void showIllegalRelationship(String var1);

    @Override
    public abstract void showSpecification();

    @Override
    public void updateConnection() {
        try {
            super.updateConnection();
        }
        catch (Throwable e) {
            Tracer.getInstance().developerWarning("JHotDraw-Error ignored [" + e.toString() + "]");
        }
    }

    protected void updateImmediately() {
        this.willChange();
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
        this.changed();
    }

    public void updateView() {
        if (this.getClassDiagram() != null && (this.getStartElement() == null || this.getEndElement() == null || this.getClassDiagram().findFigure(this.getStartElement()) == null || this.getClassDiagram().findFigure(this.getEndElement()) == null)) {
            this.removeVisually();
        }
    }
}

