/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DeclarationWriterWrapper;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Model {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Namespace noNamespace = new Namespace(null, null);
    private String name;
    private String version;
    private String file;
    private String dtd;
    private String uri;
    private ArrayList declarations;
    private ArrayList topLevel;
    private HashSet namespaces;
    private HashMap namespaceToName;
    private HashMap superclasses;
    private DeclarationWriterWrapper wrapper = new DeclarationWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createDeclarationWriterAdapter());

    public Model(String string) {
        this.name = string;
    }

    public Model(String string, Iterator iterator) throws XMIException {
        this(string);
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add((Data)iterator.next());
            }
        }
    }

    public Model(String string, String string2) {
        this(string);
        this.version = string2;
    }

    public Model(String string, String string2, String string3) {
        this(string, string2);
        this.file = string3;
    }

    public void add(Data data) throws XMIException {
        block6: {
            block5: {
                if (this.declarations == null) {
                    this.declarations = new ArrayList();
                }
                this.declarations.add(data);
                this.addToNameHashtable(data);
                if (data.getXMIOwner() == null) {
                    if (this.topLevel == null) {
                        this.topLevel = new ArrayList();
                    }
                    this.topLevel.add(data);
                }
                if (!(data instanceof XMIClass)) break block5;
                XMIClass xMIClass = (XMIClass)data;
                Iterator iterator = xMIClass.getXMIFeatures().iterator();
                while (iterator.hasNext()) {
                    this.addToNameHashtable((Data)iterator.next());
                }
                break block6;
            }
            if (!(data instanceof Package)) break block6;
            Package package_ = (Package)data;
            Iterator iterator = package_.getXMIContents().iterator();
            while (iterator.hasNext()) {
                this.add((Data)iterator.next());
            }
        }
    }

    private void addToNameHashtable(Data data) {
        Namespace namespace = data.getXMINamespace();
        if (namespace == null) {
            namespace = noNamespace;
        }
        if (this.namespaces == null) {
            this.namespaces = new HashSet();
        }
        if (!this.namespaces.contains(namespace)) {
            this.namespaces.add(namespace);
            if (this.namespaceToName == null) {
                this.namespaceToName = new HashMap();
            }
            if (this.namespaceToName.get(namespace) == null) {
                this.namespaceToName.put(namespace, new HashMap());
            }
        }
        HashMap hashMap = (HashMap)this.namespaceToName.get(namespace);
        if (data.getXMIName() != null) {
            String string = data.getXMIName();
            int n = string.indexOf(":");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (hashMap.get(string) == null) {
                hashMap.put(string, new ArrayList(5));
            }
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            arrayList.add(data);
        }
    }

    public void delete(Data data) throws XMIException {
        if (this.declarations == null) {
            return;
        }
        ((AbstractCollection)this.declarations).remove(data);
    }

    private Object[] getAllSuperclasses(Data data) {
        Object[] objectArray;
        if (this.superclasses == null) {
            this.superclasses = new HashMap();
        }
        if ((objectArray = (Object[])this.superclasses.get(data)) != null) {
            return objectArray;
        }
        objectArray = this.wrapper.getAllSuperclasses(data).toArray();
        this.superclasses.put(data, objectArray);
        return objectArray;
    }

    public Collection getDeclarations() {
        if (this.declarations == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.declarations);
    }

    public Data getDeclaration(String string) {
        return this.getDeclaration(noNamespace, string, false);
    }

    public Data getDeclaration(Data data, String string) {
        return this.getDeclaration(noNamespace, data, string, false);
    }

    public Data getDeclaration(Namespace namespace, Data data, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, data, string);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data2 = this.getDeclaration(hashMap2, data, string);
            if (data2 == null) continue;
            return data2;
        }
        return null;
    }

    private Data getDeclaration(HashMap hashMap, Data data, String string) {
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList == null && data == null) {
            return null;
        }
        if (data == null) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                Data data2 = (Data)iterator.next();
                if (data2.getXMIOwner() != null) continue;
                return data2;
            }
            return (Data)((AbstractList)arrayList).iterator().next();
        }
        HashSet<Object> hashSet = new HashSet<Object>(5);
        hashSet.add(data);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>(5);
        arrayList2.add(hashMap);
        if (data instanceof XMIClass) {
            Object[] objectArray = this.getAllSuperclasses(data);
            int n = 0;
            while (n < objectArray.length) {
                HashMap hashMap2;
                XMIClass xMIClass = (XMIClass)objectArray[n];
                Namespace namespace = xMIClass.getXMINamespace();
                if (namespace == null) {
                    namespace = noNamespace;
                }
                if (!arrayList2.contains(hashMap2 = (HashMap)this.namespaceToName.get(namespace))) {
                    arrayList2.add(hashMap2);
                }
                hashSet.add(objectArray[n]);
                ++n;
            }
        }
        int n = 0;
        while (n < arrayList2.size()) {
            HashMap hashMap3 = (HashMap)arrayList2.get(n);
            arrayList = (ArrayList)hashMap3.get(string);
            if (arrayList != null) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (hashSet.contains(((Data)arrayList.get(n2)).getXMIOwner())) {
                        return (Data)arrayList.get(n2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public Data getDeclaration(Namespace namespace, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, namespace, string, bl);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data = this.getDeclaration(hashMap2, namespace, string, bl);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private Data getDeclaration(HashMap hashMap, Namespace namespace, String string, boolean bl) {
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList != null) {
            return (Data)((AbstractList)arrayList).iterator().next();
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        Collection collection = this.getDeclarations(namespace, string.substring(n + 1));
        if (collection != null && collection.size() == 1) {
            return (Data)collection.iterator().next();
        }
        Data data = this.getDeclaration(namespace, string.substring(0, n), bl);
        if (data == null) {
            return null;
        }
        return this.getDeclaration(namespace, data, string.substring(n + 1), bl);
    }

    public Data getDeclaration(int n, String string) {
        return this.getDeclaration(noNamespace, n, string, false);
    }

    public Data getDeclaration(Namespace namespace, int n, String string, boolean bl) {
        HashMap hashMap;
        if (this.namespaceToName == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null && !bl) {
            return null;
        }
        if (!bl) {
            return this.getDeclaration(hashMap, namespace, n, string, bl);
        }
        Iterator iterator = this.namespaceToName.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            Data data = this.getDeclaration(hashMap2, namespace, n, string, bl);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private Data getDeclaration(HashMap hashMap, Namespace namespace, int n, String string, boolean bl) {
        Data data;
        ArrayList<Data> arrayList = (ArrayList<Data>)hashMap.get(string);
        int n2 = string.lastIndexOf(".");
        if (arrayList == null && n2 == -1) {
            return null;
        }
        if (arrayList == null && (data = this.getDeclaration(namespace, string, bl)) != null) {
            arrayList = new ArrayList<Data>(1);
            arrayList.add(data);
        }
        if (arrayList == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (this.wrapper.getType(arrayList.get(n3)) == n) {
                return (Data)arrayList.get(n3);
            }
            ++n3;
        }
        return null;
    }

    public Collection getDeclarations(String string) {
        return this.getDeclarations(noNamespace, string);
    }

    public Collection getDeclarations(Namespace namespace, String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (this.namespaceToName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = noNamespace;
        }
        if ((hashMap = (HashMap)this.namespaceToName.get(namespace)) == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getFile() {
        return this.file;
    }

    public Collection getNamespaces() {
        return this.namespaces;
    }

    public Collection getTopLevel() {
        if (this.topLevel == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.topLevel);
    }

    public String getXMIName() {
        return this.name;
    }

    public String getURI() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    private String printClass(XMIClass xMIClass, String string) {
        Iterator iterator;
        String string2 = string + xMIClass.toString() + "\n";
        Iterator iterator2 = xMIClass.getXMIFeatures().iterator();
        if (iterator2.hasNext()) {
            string2 = string2 + string + "  Features:\n";
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                string2 = string2 + string + "    " + iterator + "\n";
            }
        }
        if ((iterator = xMIClass.getXMISuperclasses().iterator()).hasNext()) {
            string2 = string2 + string + "  Superclasses:\n";
        }
        while (iterator.hasNext()) {
            string2 = string2 + string + "    " + iterator.next() + "\n";
        }
        Iterator iterator3 = xMIClass.getXMISubclasses().iterator();
        if (iterator3.hasNext()) {
            string2 = string2 + string + "  Subclasses:\n";
        }
        while (iterator3.hasNext()) {
            string2 = string2 + string + "    " + iterator3.next() + "\n";
        }
        return string2;
    }

    private String printPackage(Package package_, String string) {
        String string2 = string + package_;
        if (package_.getXMIOwner() != null) {
            string2 = string2 + " owner: [" + package_.getXMIOwner() + "]";
        }
        string2 = string2 + "\n";
        Iterator iterator = package_.getXMIContents().iterator();
        if (iterator.hasNext()) {
            string2 = string2 + string + "  Contents:\n";
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            string2 = e instanceof XMIClass ? string2 + this.printClass((XMIClass)e, string + "    ") : (e instanceof Package ? string2 + this.printPackage((Package)e, string + "    ") : string2 + string + "    " + e + "\n");
        }
        return string2;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String toString() {
        String string = "Model: \n";
        string = string + "name: " + this.getXMIName() + " version: " + this.getVersion() + " file: " + this.getFile() + "\n";
        if (this.topLevel == null) {
            return "empty";
        }
        int n = 0;
        while (n < this.topLevel.size()) {
            string = this.topLevel.get(n) instanceof XMIClass ? string + this.printClass((XMIClass)this.topLevel.get(n), "") : (this.topLevel.get(n) instanceof Package ? string + this.printPackage((Package)this.topLevel.get(n), "") : string + this.topLevel.get(n) + "\n");
            ++n;
        }
        return string;
    }
}

