/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherTest;

public abstract class RegexpTest
extends RegexpMatcherTest {
    private static final String test = "abcdefg-abcdefg";
    private static final String pattern = "ab([^d]*)d([^f]*)f";

    public RegexpTest(String name) {
        super(name);
    }

    public final RegexpMatcher getImplementation() {
        return this.getRegexpImplementation();
    }

    public abstract Regexp getRegexpImplementation();

    public void testSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        RegexpTest.assertTrue((boolean)reg.matches(test));
        RegexpTest.assertEquals((String)"abedcfg-abcdefg", (String)reg.substitute(test, "ab\\2d\\1f", 0));
    }

    public void testReplaceFirstSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        RegexpTest.assertTrue((boolean)reg.matches(test));
        RegexpTest.assertEquals((String)"abedcfg-abcdefg", (String)reg.substitute(test, "ab\\2d\\1f", 1));
    }

    public void testReplaceAllSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        RegexpTest.assertTrue((boolean)reg.matches(test));
        RegexpTest.assertEquals((String)"abedcfg-abedcfg", (String)reg.substitute(test, "ab\\2d\\1f", 16));
    }
}

