/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import sun.awt.AWTAccessor;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Accessible {
    boolean state = false;
    transient ItemListener itemListener;
    private static final String base = "chkmenuitem";
    private static int nameCounter;
    private static final long serialVersionUID = 6190621106981774043L;
    private int checkboxMenuItemSerializedDataVersion = 1;

    public CheckboxMenuItem() throws HeadlessException {
        this("", false);
    }

    public CheckboxMenuItem(String label) throws HeadlessException {
        this(label, false);
    }

    public CheckboxMenuItem(String label, boolean state) throws HeadlessException {
        super(label);
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<CheckboxMenuItem> clazz = CheckboxMenuItem.class;
        synchronized (CheckboxMenuItem.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
            }
            super.addNotify();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean b) {
        this.state = b;
        CheckboxMenuItemPeer peer = (CheckboxMenuItemPeer)this.peer;
        if (peer != null) {
            peer.setState(b);
        }
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        if (this.state) {
            Object[] items = new Object[]{this.label};
            return items;
        }
        return null;
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        ItemListener l = null;
        if (listenerType != ItemListener.class) {
            return super.getListeners(listenerType);
        }
        l = this.itemListener;
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        if (e.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        ItemListener listener = this.itemListener;
        if (listener != null) {
            listener.itemStateChanged(e);
        }
    }

    @Override
    void doMenuEvent(long when, int modifiers) {
        this.setState(!this.state);
        Toolkit.getEventQueue().postEvent(new ItemEvent(this, 701, this.getLabel(), this.state ? 1 : 2));
    }

    @Override
    public String paramString() {
        return super.paramString() + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckboxMenuItem();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            CheckboxMenuItem.initIDs();
        }
        AWTAccessor.setCheckboxMenuItemAccessor(new AWTAccessor.CheckboxMenuItemAccessor(){

            @Override
            public boolean getState(CheckboxMenuItem cmi) {
                return cmi.state;
            }
        });
        nameCounter = 0;
    }

    protected class AccessibleAWTCheckboxMenuItem
    extends MenuItem.AccessibleAWTMenuItem
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -1122642964303476L;

        protected AccessibleAWTCheckboxMenuItem() {
            super(CheckboxMenuItem.this);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 0;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            return false;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return null;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

