/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.relation.RelationService;

public class RelationNotification
extends Notification {
    private static final long oldSerialVersionUID = -2126464566505527147L;
    private static final long newSerialVersionUID = -6871117877523310399L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myNewRoleValue", ArrayList.class), new ObjectStreamField("myOldRoleValue", ArrayList.class), new ObjectStreamField("myRelId", String.class), new ObjectStreamField("myRelObjName", ObjectName.class), new ObjectStreamField("myRelTypeName", String.class), new ObjectStreamField("myRoleName", String.class), new ObjectStreamField("myUnregMBeanList", ArrayList.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("newRoleValue", List.class), new ObjectStreamField("oldRoleValue", List.class), new ObjectStreamField("relationId", String.class), new ObjectStreamField("relationObjName", ObjectName.class), new ObjectStreamField("relationTypeName", String.class), new ObjectStreamField("roleName", String.class), new ObjectStreamField("unregisterMBeanList", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static final String RELATION_BASIC_CREATION = "jmx.relation.creation.basic";
    public static final String RELATION_MBEAN_CREATION = "jmx.relation.creation.mbean";
    public static final String RELATION_BASIC_UPDATE = "jmx.relation.update.basic";
    public static final String RELATION_MBEAN_UPDATE = "jmx.relation.update.mbean";
    public static final String RELATION_BASIC_REMOVAL = "jmx.relation.removal.basic";
    public static final String RELATION_MBEAN_REMOVAL = "jmx.relation.removal.mbean";
    private String relationId = null;
    private String relationTypeName = null;
    private ObjectName relationObjName = null;
    private List<ObjectName> unregisterMBeanList = null;
    private String roleName = null;
    private List<ObjectName> oldRoleValue = null;
    private List<ObjectName> newRoleValue = null;

    public RelationNotification(String notifType, Object sourceObj, long sequence, long timeStamp, String message, String id, String typeName, ObjectName objectName, List<ObjectName> unregMBeanList) throws IllegalArgumentException {
        super(notifType, sourceObj, sequence, timeStamp, message);
        if (!this.isValidBasicStrict(notifType, sourceObj, id, typeName) || !this.isValidCreate(notifType)) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.relationId = id;
        this.relationTypeName = typeName;
        this.relationObjName = this.safeGetObjectName(objectName);
        this.unregisterMBeanList = this.safeGetObjectNameList(unregMBeanList);
    }

    public RelationNotification(String notifType, Object sourceObj, long sequence, long timeStamp, String message, String id, String typeName, ObjectName objectName, String name, List<ObjectName> newValue, List<ObjectName> oldValue) throws IllegalArgumentException {
        super(notifType, sourceObj, sequence, timeStamp, message);
        if (!this.isValidBasicStrict(notifType, sourceObj, id, typeName) || !this.isValidUpdate(notifType, name, newValue, oldValue)) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.relationId = id;
        this.relationTypeName = typeName;
        this.relationObjName = this.safeGetObjectName(objectName);
        this.roleName = name;
        this.oldRoleValue = this.safeGetObjectNameList(oldValue);
        this.newRoleValue = this.safeGetObjectNameList(newValue);
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public ObjectName getObjectName() {
        return this.relationObjName;
    }

    public List<ObjectName> getMBeansToUnregister() {
        List<ObjectName> result = this.unregisterMBeanList != null ? new ArrayList<ObjectName>(this.unregisterMBeanList) : Collections.emptyList();
        return result;
    }

    public String getRoleName() {
        String result = null;
        if (this.roleName != null) {
            result = this.roleName;
        }
        return result;
    }

    public List<ObjectName> getOldRoleValue() {
        List<ObjectName> result = this.oldRoleValue != null ? new ArrayList<ObjectName>(this.oldRoleValue) : Collections.emptyList();
        return result;
    }

    public List<ObjectName> getNewRoleValue() {
        List<ObjectName> result = this.newRoleValue != null ? new ArrayList<ObjectName>(this.newRoleValue) : Collections.emptyList();
        return result;
    }

    private boolean isValidBasicStrict(String notifType, Object sourceObj, String id, String typeName) {
        if (sourceObj == null) {
            return false;
        }
        return this.isValidBasic(notifType, sourceObj, id, typeName);
    }

    private boolean isValidBasic(String notifType, Object sourceObj, String id, String typeName) {
        if (notifType == null || id == null || typeName == null) {
            return false;
        }
        return sourceObj == null || sourceObj instanceof RelationService || sourceObj instanceof ObjectName;
    }

    private boolean isValidCreate(String notifType) {
        String[] validTypes = new String[]{RELATION_BASIC_CREATION, RELATION_MBEAN_CREATION, RELATION_BASIC_REMOVAL, RELATION_MBEAN_REMOVAL};
        HashSet<String> ctSet = new HashSet<String>(Arrays.asList(validTypes));
        return ctSet.contains(notifType);
    }

    private boolean isValidUpdate(String notifType, String name, List<ObjectName> newValue, List<ObjectName> oldValue) {
        if (!notifType.equals(RELATION_BASIC_UPDATE) && !notifType.equals(RELATION_MBEAN_UPDATE)) {
            return false;
        }
        return name != null && oldValue != null && newValue != null;
    }

    private ArrayList<ObjectName> safeGetObjectNameList(List<ObjectName> src) {
        ArrayList<ObjectName> dest = null;
        if (src != null) {
            dest = new ArrayList<ObjectName>();
            for (ObjectName item : src) {
                dest.add(ObjectName.getInstance(item));
            }
        }
        return dest;
    }

    private ObjectName safeGetObjectName(ObjectName src) {
        ObjectName dest = null;
        if (src != null) {
            dest = ObjectName.getInstance(src);
        }
        return dest;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List tmpUnregMBeanList;
        List tmpOldRoleValue;
        List tmpNewRoleValue;
        ObjectName tmpRelationObjName;
        String tmpRoleName;
        String tmpRelationTypeName;
        String tmpRelationId;
        ObjectInputStream.GetField fields = in.readFields();
        if (compat) {
            tmpRelationId = (String)fields.get("myRelId", null);
            tmpRelationTypeName = (String)fields.get("myRelTypeName", null);
            tmpRoleName = (String)fields.get("myRoleName", null);
            tmpRelationObjName = (ObjectName)fields.get("myRelObjName", null);
            tmpNewRoleValue = (List)Util.cast(fields.get("myNewRoleValue", null));
            tmpOldRoleValue = (List)Util.cast(fields.get("myOldRoleValue", null));
            tmpUnregMBeanList = (List)Util.cast(fields.get("myUnregMBeanList", null));
        } else {
            tmpRelationId = (String)fields.get("relationId", null);
            tmpRelationTypeName = (String)fields.get("relationTypeName", null);
            tmpRoleName = (String)fields.get("roleName", null);
            tmpRelationObjName = (ObjectName)fields.get("relationObjName", null);
            tmpNewRoleValue = (List)Util.cast(fields.get("newRoleValue", null));
            tmpOldRoleValue = (List)Util.cast(fields.get("oldRoleValue", null));
            tmpUnregMBeanList = (List)Util.cast(fields.get("unregisterMBeanList", null));
        }
        String notifType = super.getType();
        if (!this.isValidBasic(notifType, super.getSource(), tmpRelationId, tmpRelationTypeName) || !this.isValidCreate(notifType) && !this.isValidUpdate(notifType, tmpRoleName, tmpNewRoleValue, tmpOldRoleValue)) {
            super.setSource(null);
            throw new InvalidObjectException("Invalid object read");
        }
        this.relationObjName = this.safeGetObjectName(tmpRelationObjName);
        this.newRoleValue = this.safeGetObjectNameList(tmpNewRoleValue);
        this.oldRoleValue = this.safeGetObjectNameList(tmpOldRoleValue);
        this.unregisterMBeanList = this.safeGetObjectNameList(tmpUnregMBeanList);
        this.relationId = tmpRelationId;
        this.relationTypeName = tmpRelationTypeName;
        this.roleName = tmpRoleName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myNewRoleValue", this.newRoleValue);
            fields.put("myOldRoleValue", this.oldRoleValue);
            fields.put("myRelId", this.relationId);
            fields.put("myRelObjName", this.relationObjName);
            fields.put("myRelTypeName", this.relationTypeName);
            fields.put("myRoleName", this.roleName);
            fields.put("myUnregMBeanList", this.unregisterMBeanList);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -2126464566505527147L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6871117877523310399L;
        }
    }
}

