/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.MainSwatchPanel;
import javax.swing.colorchooser.RecentSwatchPanel;
import javax.swing.colorchooser.SwatchPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private KeyListener mainSwatchKeyListener;
    private KeyListener recentSwatchKeyListener;

    public DefaultSwatchChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString((Object)"ColorChooser.swatchesNameText", this.getLocale());
    }

    @Override
    public int getMnemonic() {
        return this.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        String recentStr = UIManager.getString((Object)"ColorChooser.swatchesRecentText", this.getLocale());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel superHolder = new JPanel(gb);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.putClientProperty("AccessibleName", recentStr);
        this.mainSwatchKeyListener = new MainSwatchKeyListener();
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.swatchPanel.addKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchKeyListener = new RecentSwatchKeyListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.addKeyListener(this.recentSwatchKeyListener);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        gbc.anchor = 25;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 0, 10);
        superHolder.add((Component)mainHolder, gbc);
        gbc.insets = oldInsets;
        this.recentSwatchPanel.setInheritsPopupMenu(true);
        JPanel recentHolder = new JPanel(new BorderLayout());
        recentHolder.setBorder(border);
        recentHolder.setInheritsPopupMenu(true);
        recentHolder.add((Component)this.recentSwatchPanel, "Center");
        JLabel l = new JLabel(recentStr);
        l.setLabelFor(this.recentSwatchPanel);
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        superHolder.add((Component)l, gbc);
        gbc.weighty = 0.0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        superHolder.add((Component)recentHolder, gbc);
        superHolder.setInheritsPopupMenu(true);
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel.removeKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.removeKeyListener(this.recentSwatchKeyListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.mainSwatchKeyListener = null;
        this.recentSwatchListener = null;
        this.recentSwatchKeyListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DefaultSwatchChooserPanel.this.isEnabled()) {
                Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
                DefaultSwatchChooserPanel.this.setSelectedColor(color);
                DefaultSwatchChooserPanel.this.swatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
                DefaultSwatchChooserPanel.this.swatchPanel.requestFocusInWindow();
            }
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DefaultSwatchChooserPanel.this.isEnabled()) {
                Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
                DefaultSwatchChooserPanel.this.recentSwatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                DefaultSwatchChooserPanel.this.setSelectedColor(color);
                DefaultSwatchChooserPanel.this.recentSwatchPanel.requestFocusInWindow();
            }
        }
    }

    private class MainSwatchKeyListener
    extends KeyAdapter {
        private MainSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = DefaultSwatchChooserPanel.this.swatchPanel.getSelectedColor();
                DefaultSwatchChooserPanel.this.setSelectedColor(color);
                DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
            }
        }
    }

    private class RecentSwatchKeyListener
    extends KeyAdapter {
        private RecentSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getSelectedColor();
                DefaultSwatchChooserPanel.this.setSelectedColor(color);
            }
        }
    }
}

