/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;

public class TabStop
implements Serializable {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_DECIMAL = 4;
    public static final int ALIGN_BAR = 5;
    public static final int LEAD_NONE = 0;
    public static final int LEAD_DOTS = 1;
    public static final int LEAD_HYPHENS = 2;
    public static final int LEAD_UNDERLINE = 3;
    public static final int LEAD_THICKLINE = 4;
    public static final int LEAD_EQUALS = 5;
    private int alignment;
    private float position;
    private int leader;

    public TabStop(float pos) {
        this(pos, 0, 0);
    }

    public TabStop(float pos, int align, int leader) {
        this.alignment = align;
        this.leader = leader;
        this.position = pos;
    }

    public float getPosition() {
        return this.position;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getLeader() {
        return this.leader;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TabStop) {
            TabStop o = (TabStop)other;
            return this.alignment == o.alignment && this.leader == o.leader && this.position == o.position;
        }
        return false;
    }

    public int hashCode() {
        return this.alignment ^ this.leader ^ Math.round(this.position);
    }

    public String toString() {
        String buf;
        switch (this.alignment) {
            default: {
                buf = "";
                break;
            }
            case 1: {
                buf = "right ";
                break;
            }
            case 2: {
                buf = "center ";
                break;
            }
            case 4: {
                buf = "decimal ";
                break;
            }
            case 5: {
                buf = "bar ";
            }
        }
        buf = buf + "tab @" + String.valueOf(this.position);
        if (this.leader != 0) {
            buf = buf + " (w/leaders)";
        }
        return buf;
    }
}

