/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XColor
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XColor.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XColor(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XColor() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XColor.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public short get_red() {
        log.finest("");
        return Native.getShort(this.pData + 8L);
    }

    public void set_red(short v) {
        log.finest("");
        Native.putShort(this.pData + 8L, v);
    }

    public short get_green() {
        log.finest("");
        return Native.getShort(this.pData + 10L);
    }

    public void set_green(short v) {
        log.finest("");
        Native.putShort(this.pData + 10L, v);
    }

    public short get_blue() {
        log.finest("");
        return Native.getShort(this.pData + 12L);
    }

    public void set_blue(short v) {
        log.finest("");
        Native.putShort(this.pData + 12L, v);
    }

    public byte get_flags() {
        log.finest("");
        return Native.getByte(this.pData + 14L);
    }

    public void set_flags(byte v) {
        log.finest("");
        Native.putByte(this.pData + 14L, v);
    }

    public byte get_pad() {
        log.finest("");
        return Native.getByte(this.pData + 15L);
    }

    public void set_pad(byte v) {
        log.finest("");
        Native.putByte(this.pData + 15L, v);
    }

    @Override
    String getName() {
        return "XColor";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(240);
        ret.append("pixel = ").append(this.get_pixel()).append(", ");
        ret.append("red = ").append(this.get_red()).append(", ");
        ret.append("green = ").append(this.get_green()).append(", ");
        ret.append("blue = ").append(this.get_blue()).append(", ");
        ret.append("flags = ").append(this.get_flags()).append(", ");
        ret.append("pad = ").append(this.get_pad()).append(", ");
        return ret.toString();
    }
}

