/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.EType;

public final class Aes256CtsHmacSha1EType
extends EType {
    @Override
    public int eType() {
        return 18;
    }

    @Override
    public int minimumPadSize() {
        return 0;
    }

    @Override
    public int confounderSize() {
        return this.blockSize();
    }

    @Override
    public int checksumType() {
        return 16;
    }

    @Override
    public int checksumSize() {
        return Aes256.getChecksumLength();
    }

    @Override
    public int blockSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 3;
    }

    @Override
    public int keySize() {
        return 32;
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key, int usage) throws KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.encrypt(data, key, ivec, usage);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key, byte[] ivec, int usage) throws KrbCryptoException {
        try {
            return Aes256.encrypt(key, usage, ivec, data, 0, data.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws KrbApErrException, KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws KrbApErrException, KrbCryptoException {
        try {
            return Aes256.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    @Override
    public byte[] decryptedData(byte[] data) {
        return data;
    }
}

