/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import sun.security.provider.SecureRandom;

public final class NativePRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -6599091113397072932L;
    private static final String NAME_RANDOM = "/dev/random";
    private static final String NAME_URANDOM = "/dev/urandom";
    private static final RandomIO INSTANCE = NativePRNG.initIO();

    private static RandomIO initIO() {
        return AccessController.doPrivileged(new PrivilegedAction<RandomIO>(){

            @Override
            public RandomIO run() {
                File randomFile = new File(NativePRNG.NAME_RANDOM);
                if (!randomFile.exists()) {
                    return null;
                }
                File urandomFile = new File(NativePRNG.NAME_URANDOM);
                if (!urandomFile.exists()) {
                    return null;
                }
                try {
                    return new RandomIO(randomFile, urandomFile);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    static boolean isAvailable() {
        return INSTANCE != null;
    }

    public NativePRNG() {
        if (INSTANCE == null) {
            throw new AssertionError((Object)"NativePRNG not available");
        }
    }

    @Override
    protected void engineSetSeed(byte[] seed) {
        NativePRNG.INSTANCE.implSetSeed(seed);
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        NativePRNG.INSTANCE.implNextBytes(bytes);
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        return NativePRNG.INSTANCE.implGenerateSeed(numBytes);
    }

    private static class RandomIO {
        private static final long MAX_BUFFER_TIME = 100L;
        private static final int BUFFER_SIZE = 32;
        private final InputStream randomIn;
        private final InputStream urandomIn;
        private OutputStream randomOut;
        private boolean randomOutInitialized;
        private volatile SecureRandom mixRandom;
        private final byte[] urandomBuffer;
        private int buffered;
        private long lastRead;
        private final Object LOCK_GET_BYTES = new Object();
        private final Object LOCK_GET_SEED = new Object();
        private final Object LOCK_SET_SEED = new Object();

        private RandomIO(File randomFile, File urandomFile) throws IOException {
            this.randomIn = new FileInputStream(randomFile);
            this.urandomIn = new FileInputStream(urandomFile);
            this.urandomBuffer = new byte[32];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecureRandom getMixRandom() {
            SecureRandom r = this.mixRandom;
            if (r == null) {
                Object object = this.LOCK_GET_BYTES;
                synchronized (object) {
                    r = this.mixRandom;
                    if (r == null) {
                        r = new SecureRandom();
                        try {
                            byte[] b = new byte[20];
                            RandomIO.readFully(this.urandomIn, b);
                            r.engineSetSeed(b);
                        }
                        catch (IOException e) {
                            throw new ProviderException("init failed", e);
                        }
                        this.mixRandom = r;
                    }
                }
            }
            return r;
        }

        private static void readFully(InputStream in, byte[] data) throws IOException {
            int len;
            int k;
            int ofs = 0;
            for (len = data.length; len > 0; len -= k) {
                k = in.read(data, ofs, len);
                if (k <= 0) {
                    throw new EOFException("/dev/[u]random closed?");
                }
                ofs += k;
            }
            if (len > 0) {
                throw new IOException("Could not read from /dev/[u]random");
            }
        }

        private byte[] implGenerateSeed(int numBytes) {
            Object object = this.LOCK_GET_SEED;
            synchronized (object) {
                try {
                    byte[] b = new byte[numBytes];
                    RandomIO.readFully(this.randomIn, b);
                    return b;
                }
                catch (IOException e) {
                    throw new ProviderException("generateSeed() failed", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implSetSeed(byte[] seed) {
            Object object = this.LOCK_SET_SEED;
            synchronized (object) {
                if (!this.randomOutInitialized) {
                    this.randomOutInitialized = true;
                    this.randomOut = AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                        @Override
                        public OutputStream run() {
                            try {
                                return new FileOutputStream(NativePRNG.NAME_RANDOM, true);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    });
                }
                if (this.randomOut != null) {
                    try {
                        this.randomOut.write(seed);
                    }
                    catch (IOException e) {
                        throw new ProviderException("setSeed() failed", e);
                    }
                }
                this.getMixRandom().engineSetSeed(seed);
            }
        }

        private void ensureBufferValid() throws IOException {
            long time = System.currentTimeMillis();
            if (this.buffered > 0 && time - this.lastRead < 100L) {
                return;
            }
            this.lastRead = time;
            RandomIO.readFully(this.urandomIn, this.urandomBuffer);
            this.buffered = this.urandomBuffer.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implNextBytes(byte[] data) {
            Object object = this.LOCK_GET_BYTES;
            synchronized (object) {
                try {
                    this.getMixRandom().engineNextBytes(data);
                    int len = data.length;
                    int ofs = 0;
                    while (len > 0) {
                        this.ensureBufferValid();
                        int bufferOfs = this.urandomBuffer.length - this.buffered;
                        while (len > 0 && this.buffered > 0) {
                            int n = ofs++;
                            data[n] = (byte)(data[n] ^ this.urandomBuffer[bufferOfs++]);
                            --len;
                            --this.buffered;
                        }
                    }
                }
                catch (IOException e) {
                    throw new ProviderException("nextBytes() failed", e);
                }
            }
        }
    }
}

