/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.DoubleByte;

public abstract class CharToByteDBCS_ASCII
extends CharToByteConverter {
    private char highHalfZoneCode;
    private byte[] outputByte = new byte[2];
    private DoubleByte.Encoder enc;

    public CharToByteDBCS_ASCII(DoubleByte.Encoder enc) {
        this.enc = enc;
    }

    int encodeChar(char c) {
        return this.enc.encodeChar(c);
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        if (this.highHalfZoneCode != '\u0000') {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        this.byteOff = outOff;
        this.charOff = inOff;
        while (this.charOff < inEnd) {
            int inputSize;
            char inputChar;
            if (this.highHalfZoneCode == '\u0000') {
                inputChar = input[this.charOff];
                inputSize = 1;
            } else {
                inputChar = this.highHalfZoneCode;
                inputSize = 0;
                this.highHalfZoneCode = '\u0000';
            }
            if (Character.isHighSurrogate(inputChar)) {
                if (this.charOff + inputSize >= inEnd) {
                    this.highHalfZoneCode = inputChar;
                    this.charOff += inputSize;
                    return this.byteOff - outOff;
                }
                inputChar = input[this.charOff + inputSize];
                if (!Character.isLowSurrogate(inputChar)) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (!this.subMode) {
                    this.badInputLength = 2;
                    throw new UnknownCharacterException();
                }
                if (this.subBytes.length == 1) {
                    this.outputByte[0] = 0;
                    this.outputByte[1] = this.subBytes[0];
                } else {
                    this.outputByte[0] = this.subBytes[0];
                    this.outputByte[1] = this.subBytes[1];
                }
                ++inputSize;
            } else {
                if (Character.isLowSurrogate(inputChar)) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                int theBytes = this.encodeChar(inputChar);
                if (theBytes == 65533) {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    if (this.subBytes.length == 1) {
                        this.outputByte[0] = 0;
                        this.outputByte[1] = this.subBytes[0];
                    } else {
                        this.outputByte[0] = this.subBytes[0];
                        this.outputByte[1] = this.subBytes[1];
                    }
                } else {
                    this.outputByte[0] = (byte)(theBytes >> 8);
                    this.outputByte[1] = (byte)theBytes;
                }
            }
            int spaceNeeded = this.outputByte[0] == 0 ? 1 : 2;
            if (this.byteOff + spaceNeeded > outEnd) {
                throw new ConversionBufferFullException();
            }
            if (spaceNeeded == 1) {
                output[this.byteOff++] = this.outputByte[1];
            } else {
                output[this.byteOff++] = this.outputByte[0];
                output[this.byteOff++] = this.outputByte[1];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public boolean canConvert(char c) {
        return this.encodeChar(c) != 65533;
    }
}

