/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileSystemProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JarFileSystemProvider
extends ZipFileSystemProvider {
    @Override
    public String getScheme() {
        return "jar";
    }

    @Override
    protected Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String uristr = uri.toString();
            int end = uristr.indexOf("!/");
            uristr = uristr.substring(4, end == -1 ? uristr.length() : end);
            uri = new URI(uristr);
            return Paths.get(new URI("file", uri.getHost(), uri.getPath(), null)).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Path getPath(URI uri) {
        String uristr;
        int off;
        FileSystem fs = this.getFileSystem(uri);
        String path = uri.getFragment();
        if (path == null && (off = (uristr = uri.toString()).indexOf("!/")) != -1) {
            path = uristr.substring(off + 2);
        }
        if (path != null) {
            return fs.getPath(path, new String[0]);
        }
        throw new IllegalArgumentException("URI: " + uri + " does not contain path fragment ex. jar:///c:/foo.zip!/BAR");
    }
}

