open GtkSignal
open Gobject
open Data
let set = set
let get = get
let param = param
open GtkListProps

class virtual liste_props = object
  val virtual obj : _ obj
  method set_selection_mode = set Liste.P.selection_mode obj
  method selection_mode = get Liste.P.selection_mode obj
end

class virtual liste_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method selection_mode = self#notify Liste.P.selection_mode
end

class virtual clist_props = object
  val virtual obj : _ obj
  method set_sort_type = set Clist.P.sort_type obj
  method set_reorderable = set Clist.P.reorderable obj
  method set_row_height = set Clist.P.row_height obj
  method set_selection_mode = set Clist.P.selection_mode obj
  method set_shadow_type = set Clist.P.shadow_type obj
  method set_titles_active = set Clist.P.titles_active obj
  method set_use_drag_icons = set Clist.P.use_drag_icons obj
  method n_columns = get Clist.P.n_columns obj
  method sort_type = get Clist.P.sort_type obj
  method reorderable = get Clist.P.reorderable obj
  method row_height = get Clist.P.row_height obj
  method selection_mode = get Clist.P.selection_mode obj
  method shadow_type = get Clist.P.shadow_type obj
  method titles_active = get Clist.P.titles_active obj
  method use_drag_icons = get Clist.P.use_drag_icons obj
end

class virtual clist_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method n_columns = self#notify Clist.P.n_columns
  method sort_type = self#notify Clist.P.sort_type
  method reorderable = self#notify Clist.P.reorderable
  method row_height = self#notify Clist.P.row_height
  method selection_mode = self#notify Clist.P.selection_mode
  method shadow_type = self#notify Clist.P.shadow_type
  method titles_active = self#notify Clist.P.titles_active
  method use_drag_icons = self#notify Clist.P.use_drag_icons
end

class virtual clist_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method click_column = self#connect Clist.S.click_column
  method resize_column = self#connect Clist.S.resize_column
  method scroll_horizontal = self#connect Clist.S.scroll_horizontal
  method scroll_vertical = self#connect Clist.S.scroll_vertical
  method select_all = self#connect Clist.S.select_all
  method select_row = self#connect Clist.S.select_row
  method unselect_all = self#connect Clist.S.unselect_all
  method unselect_row = self#connect Clist.S.unselect_row
  method notify_n_columns ~callback = self#notify Clist.P.n_columns ~callback
  method notify_sort_type ~callback = self#notify Clist.P.sort_type ~callback
  method notify_reorderable ~callback =
    self#notify Clist.P.reorderable ~callback
  method notify_row_height ~callback =
    self#notify Clist.P.row_height ~callback
  method notify_selection_mode ~callback =
    self#notify Clist.P.selection_mode ~callback
  method notify_shadow_type ~callback =
    self#notify Clist.P.shadow_type ~callback
  method notify_titles_active ~callback =
    self#notify Clist.P.titles_active ~callback
  method notify_use_drag_icons ~callback =
    self#notify Clist.P.use_drag_icons ~callback
end

