/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright (C) 2013 Colin Walters <walters@verbum.org>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GSYSTEM_LOG_H__
#define __GSYSTEM_LOG_H__

#include <gio/gio.h>

G_BEGIN_DECLS

gboolean gs_stdout_is_journal (void);

void gs_log_structured (const char *message,
                        const char *const *keys);

void gs_log_structured_print (const char *message,
                              const char *const *keys);

void gs_log_structured_print_id_v (const char *message_id,
                                   const char *format,
                                   ...) G_GNUC_PRINTF (2, 3);

G_END_DECLS

#endif
