/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.keys.page.PagePolicy;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentMetaNode;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.numeric.DecimalCounterStyle;
import org.jfree.layouting.layouter.i18n.DefaultLocalizationContext;
import org.jfree.layouting.namespace.DefaultNamespaceCollection;
import org.jfree.layouting.namespace.DefaultNamespaceDefinition;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultDocumentContext
extends DefaultDocumentMetaNode
implements DocumentContext {
    private ArrayList metaNodes = new ArrayList();
    private HashMap counterStyles = new HashMap();
    private HashMap counterPolicy = new HashMap();
    private HashMap stringPolicy = new HashMap();
    private DefaultNamespaceCollection namespaceCollection;
    private int quoteLevel;

    public DefaultDocumentContext() {
        this.setMetaAttribute("date", new Date());
        this.setMetaAttribute("localization-context", new DefaultLocalizationContext());
    }

    public CSSValue getStringPolicy(String string) {
        CSSValue cSSValue = (CSSValue)this.stringPolicy.get(string);
        if (cSSValue == null) {
            return PagePolicy.LAST;
        }
        return cSSValue;
    }

    public void setStringPolicy(String string, CSSValue cSSValue) {
        this.stringPolicy.put(string, cSSValue);
    }

    public CSSValue getCounterPolicy(String string) {
        CSSValue cSSValue = (CSSValue)this.counterPolicy.get(string);
        if (cSSValue == null) {
            return PagePolicy.LAST;
        }
        return cSSValue;
    }

    public void setCounterPolicy(String string, CSSValue cSSValue) {
        this.counterPolicy.put(string, cSSValue);
    }

    public void addMetaNode(DocumentMetaNode documentMetaNode) {
        if (documentMetaNode == null) {
            throw new NullPointerException();
        }
        if (documentMetaNode instanceof DocumentContext) {
            throw new IllegalArgumentException();
        }
        this.metaNodes.add(documentMetaNode);
    }

    public void removeMetaNode(DocumentMetaNode documentMetaNode) {
        this.metaNodes.remove(documentMetaNode);
    }

    public DocumentMetaNode getMetaNode(int n) {
        return (DocumentMetaNode)this.metaNodes.get(n);
    }

    public int getMetaNodeCount() {
        return this.metaNodes.size();
    }

    public ResourceManager getResourceManager() {
        Object object = this.getMetaAttribute("resource-manager");
        if (!(object instanceof ResourceManager)) {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            this.setMetaAttribute("resource-manager", resourceManager);
            return resourceManager;
        }
        return (ResourceManager)object;
    }

    public void setCounterStyle(String string, CounterStyle counterStyle) {
        this.counterStyles.put(string, counterStyle);
    }

    public CounterStyle getCounterStyle(String string) {
        CounterStyle counterStyle = (CounterStyle)this.counterStyles.get(string);
        if (counterStyle == null) {
            return new DecimalCounterStyle();
        }
        return counterStyle;
    }

    public void initialize() {
        Object object;
        int n;
        this.namespaceCollection = new DefaultNamespaceCollection();
        NamespaceDefinition[] namespaceDefinitionArray = Namespaces.createFromConfig(LibLayoutBoot.getInstance().getGlobalConfig(), "org.jfree.layouting.namespaces.", this.getResourceManager());
        for (n = 0; n < namespaceDefinitionArray.length; ++n) {
            object = namespaceDefinitionArray[n];
            this.namespaceCollection.addDefinition((NamespaceDefinition)object);
        }
        for (n = 0; n < this.metaNodes.size(); ++n) {
            object = (DocumentMetaNode)this.metaNodes.get(n);
            Object object2 = object.getMetaAttribute("type");
            if (!"namespace".equals(object2)) continue;
            Object object3 = object.getMetaAttribute("definition");
            if (object3 instanceof NamespaceDefinition) {
                this.namespaceCollection.addDefinition((NamespaceDefinition)object3);
                continue;
            }
            String string = (String)object.getMetaAttribute("uri");
            String string2 = (String)object.getMetaAttribute("prefix");
            String string3 = (String)object.getMetaAttribute("class-attribute");
            String string4 = (String)object.getMetaAttribute("style-attribute");
            ResourceKey resourceKey = (ResourceKey)object.getMetaAttribute("default-stylesheet");
            this.namespaceCollection.addDefinition(new DefaultNamespaceDefinition(string, resourceKey, string3, string4, string2));
        }
    }

    public NamespaceCollection getNamespaces() {
        return this.namespaceCollection;
    }

    public int getQuoteLevel() {
        return this.quoteLevel;
    }

    public void openQuote() {
        ++this.quoteLevel;
    }

    public void closeQuote() {
        --this.quoteLevel;
        if (this.quoteLevel < 0) {
            this.quoteLevel = 0;
        }
    }
}

