/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.DefaultLayoutContext;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.values.AttrValueFunction;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.util.AttributeMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.Resource;

public abstract class AbstractStyleResolver
implements StyleResolver {
    private LayoutStyle initialStyle;
    private LayoutProcess layoutProcess;
    private DocumentContext documentContext;
    private NamespaceCollection namespaces;
    private StyleKey[] keys;
    private AttrValueFunction attrFunction;

    protected AbstractStyleResolver() {
    }

    public LayoutContext createAnonymousContext(ContextId contextId, LayoutContext layoutContext) {
        LayoutElement layoutElement = new LayoutElement(null, null, layoutContext);
        DefaultLayoutContext defaultLayoutContext = new DefaultLayoutContext(contextId, "http://jfreereport.sourceforge.net/namespaces/layout", "anonymous-context", null, new AttributeMap());
        LayoutElement layoutElement2 = new LayoutElement(layoutElement, null, defaultLayoutContext);
        this.resolveOutOfContext(layoutElement2);
        return defaultLayoutContext;
    }

    public void initialize(LayoutProcess layoutProcess) {
        this.layoutProcess = layoutProcess;
        this.documentContext = layoutProcess.getDocumentContext();
        this.namespaces = this.documentContext.getNamespaces();
        this.attrFunction = new AttrValueFunction();
    }

    protected void loadInitialStyle() {
        Object object;
        this.initialStyle = new LayoutStyleImpl();
        try {
            object = this.layoutProcess.getResourceManager();
            Resource resource = object.createDirectly((Object)"res://org/jfree/layouting/initial.css", StyleSheet.class);
            StyleSheet styleSheet = (StyleSheet)resource.getResource();
            int n = styleSheet.getRuleCount();
            for (int i = 0; i < n; ++i) {
                StyleRule styleRule = styleSheet.getRule(i);
                if (!(styleRule instanceof CSSDeclarationRule)) continue;
                CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)styleRule;
                this.copyStyleInformation(this.initialStyle, cSSDeclarationRule, null);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Initial-StyleSheet could not be parsed. This is a FATAL error.");
        }
        object = this.layoutProcess.getDocumentContext();
        object.setMetaAttribute("initial-style", this.initialStyle);
    }

    protected void copyStyleInformation(LayoutStyle layoutStyle, CSSDeclarationRule cSSDeclarationRule, LayoutElement layoutElement) {
        try {
            StyleKey styleKey;
            int n;
            StyleRule styleRule = cSSDeclarationRule.getParentRule();
            if (styleRule instanceof CSSDeclarationRule) {
                this.copyStyleInformation(layoutStyle, (CSSDeclarationRule)styleRule, layoutElement);
            }
            if (layoutElement == null) {
                StyleKey[] styleKeyArray = cSSDeclarationRule.getPropertyKeysAsArray();
                for (int i = 0; i < styleKeyArray.length; ++i) {
                    StyleKey styleKey2 = styleKeyArray[i];
                    layoutStyle.setValue(styleKey2, cSSDeclarationRule.getPropertyCSSValue(styleKey2));
                }
                return;
            }
            StyleKey[] styleKeyArray = cSSDeclarationRule.getPropertyKeysAsArray();
            CSSValue[] cSSValueArray = new CSSValue[styleKeyArray.length];
            for (n = 0; n < cSSValueArray.length; ++n) {
                styleKey = styleKeyArray[n];
                CSSValue cSSValue = cSSDeclarationRule.getPropertyCSSValue(styleKey);
                if (cSSValue == null) continue;
                cSSValueArray[n] = ContentStyleKeys.CONTENT.equals(styleKey) || ContentStyleKeys.STRING_DEFINE.equals(styleKey) || ContentStyleKeys.STRING_SET.equals(styleKey) ? cSSValue : this.resolveValue(cSSValue, layoutElement);
            }
            for (n = 0; n < cSSValueArray.length; ++n) {
                styleKey = styleKeyArray[n];
                layoutStyle.setValue(styleKey, cSSValueArray[n]);
            }
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            DebugLog.log((Object)"Skipping rule, as resolving failed.");
        }
    }

    protected CSSValue resolveValue(CSSValue cSSValue, LayoutElement layoutElement) throws FunctionEvaluationException {
        if (layoutElement == null) {
            return cSSValue;
        }
        if (cSSValue == null) {
            return null;
        }
        if (!this.containsAttrFunction(cSSValue)) {
            return cSSValue;
        }
        if (cSSValue instanceof CSSAttrFunction) {
            return this.attrFunction.evaluate(this.getLayoutProcess(), layoutElement, (CSSFunctionValue)cSSValue);
        }
        if (cSSValue instanceof CSSValueList) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            ArrayList<CSSValue> arrayList = new ArrayList<CSSValue>();
            int n = cSSValueList.getLength();
            for (int i = 0; i < n; ++i) {
                CSSValue cSSValue2 = cSSValueList.getItem(i);
                arrayList.add(this.resolveValue(cSSValue2, layoutElement));
            }
            return new CSSValueList(arrayList);
        }
        if (cSSValue instanceof CSSValuePair) {
            CSSValuePair cSSValuePair = (CSSValuePair)cSSValue;
            return new CSSValuePair(this.resolveValue(cSSValuePair.getFirstValue(), layoutElement), this.resolveValue(cSSValuePair.getSecondValue(), layoutElement));
        }
        return cSSValue;
    }

    protected boolean containsAttrFunction(CSSValue cSSValue) {
        if (cSSValue == null) {
            return false;
        }
        if (cSSValue instanceof CSSAttrFunction) {
            return true;
        }
        if (cSSValue instanceof CSSValueList) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = cSSValueList.getLength();
            for (int i = 0; i < n; ++i) {
                CSSValue cSSValue2 = cSSValueList.getItem(i);
                if (!this.containsAttrFunction(cSSValue2)) continue;
                return true;
            }
            return false;
        }
        if (cSSValue instanceof CSSValuePair) {
            CSSValuePair cSSValuePair = (CSSValuePair)cSSValue;
            if (this.containsAttrFunction(cSSValuePair.getFirstValue())) {
                return true;
            }
            return this.containsAttrFunction(cSSValuePair.getSecondValue());
        }
        return false;
    }

    protected LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    public LayoutStyle getInitialStyle() {
        return this.initialStyle;
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected StyleKey[] getKeys() {
        if (this.keys == null) {
            this.keys = StyleKeyRegistry.getRegistry().getKeys(new StyleKey[0]);
        }
        return this.keys;
    }

    protected NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    protected void fillState(AbstractStyleResolverState abstractStyleResolverState) {
        abstractStyleResolverState.setInitialStyle(this.initialStyle);
        abstractStyleResolverState.setKeys(this.keys);
    }

    protected abstract void resolveOutOfContext(LayoutElement var1);

    static /* synthetic */ StyleKey[] access$402(AbstractStyleResolver abstractStyleResolver, StyleKey[] styleKeyArray) {
        abstractStyleResolver.keys = styleKeyArray;
        return styleKeyArray;
    }

    protected static abstract class AbstractStyleResolverState
    implements State {
        private LayoutStyle initialStyle;
        private StyleKey[] keys;

        protected AbstractStyleResolverState() {
        }

        public LayoutStyle getInitialStyle() {
            return this.initialStyle;
        }

        public void setInitialStyle(LayoutStyle layoutStyle) {
            this.initialStyle = layoutStyle;
        }

        protected abstract AbstractStyleResolver create();

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            AbstractStyleResolver abstractStyleResolver = this.create();
            this.fill(abstractStyleResolver, layoutProcess);
            return abstractStyleResolver;
        }

        protected void fill(AbstractStyleResolver abstractStyleResolver, LayoutProcess layoutProcess) {
            abstractStyleResolver.initialStyle = this.initialStyle;
            abstractStyleResolver.layoutProcess = layoutProcess;
            abstractStyleResolver.documentContext = layoutProcess.getDocumentContext();
            abstractStyleResolver.namespaces = layoutProcess.getDocumentContext().getNamespaces();
            AbstractStyleResolver.access$402(abstractStyleResolver, this.keys);
            abstractStyleResolver.attrFunction = new AttrValueFunction();
        }

        public StyleKey[] getKeys() {
            return this.keys;
        }

        public void setKeys(StyleKey[] styleKeyArray) {
            this.keys = styleKeyArray;
        }
    }
}

