/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class RenderLength {
    public static final RenderLength AUTO = new RenderLength(Long.MIN_VALUE, false);
    public static final RenderLength EMPTY = new RenderLength(0L, false);
    private long value;
    private boolean percentage;

    public RenderLength(long l, boolean bl) {
        this.value = l;
        this.percentage = bl;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RenderLength renderLength = (RenderLength)object;
        if (this.percentage != renderLength.percentage) {
            return false;
        }
        return this.value == renderLength.value;
    }

    public int hashCode() {
        int n = (int)(this.value ^ this.value >>> 32);
        n = 29 * n + (this.percentage ? 1 : 0);
        return n;
    }

    public long resolve(long l) {
        if (this.isPercentage()) {
            return StrictGeomUtility.multiply(this.value, l) / 100L;
        }
        if (this.value == Long.MIN_VALUE) {
            return 0L;
        }
        return this.value;
    }

    public RenderLength resolveToRenderLength(long l) {
        if (this.isPercentage()) {
            if (l <= 0L) {
                return AUTO;
            }
            return new RenderLength(StrictGeomUtility.multiply(this.value, l) / 100L, false);
        }
        if (this.value <= 0L) {
            return AUTO;
        }
        return new RenderLength(this.value, false);
    }

    public static RenderLength convertToInternal(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        if (cSSValue instanceof CSSNumericValue) {
            CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
            if (cSSNumericValue.getType() == CSSNumericType.PERCENTAGE) {
                return new RenderLength(StrictGeomUtility.toInternalValue(cSSNumericValue.getValue()), true);
            }
            if (cSSNumericValue.getType() == CSSNumericType.NUMBER) {
                return new RenderLength(StrictGeomUtility.toInternalValue(cSSNumericValue.getValue()) * 100L, true);
            }
            CSSNumericValue cSSNumericValue2 = CSSValueResolverUtility.convertLength(cSSValue, layoutContext, outputProcessorMetaData);
            return new RenderLength(StrictGeomUtility.toInternalValue(cSSNumericValue2.getValue()), false);
        }
        return EMPTY;
    }

    public String toString() {
        if (this.value == Long.MIN_VALUE) {
            return "RenderLength{value=AUTO}";
        }
        if (this.isPercentage()) {
            return "RenderLength{value=" + this.value + "% }";
        }
        return "RenderLength{value=" + this.value + "pt }";
    }
}

