/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class FontFileRecord
implements Serializable {
    private long lastAccessTime;
    private long fileSize;
    private String filename;

    public FontFileRecord(File file) throws IOException {
        this(file.getCanonicalPath(), file.length(), file.lastModified());
    }

    public FontFileRecord(String filename, long fileSize, long lastAccessTime) {
        if (filename == null) {
            throw new NullPointerException();
        }
        this.filename = filename;
        this.fileSize = fileSize;
        this.lastAccessTime = lastAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontFileRecord that = (FontFileRecord)o;
        if (this.fileSize != that.fileSize) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        return this.filename.equals(that.filename);
    }

    public int hashCode() {
        int result = (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result = 29 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 29 * result + this.filename.hashCode();
        return result;
    }
}

