/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.LocaleUtility;
import org.jfree.report.expressions.Expression;
import org.jfree.report.structure.Node;

public abstract class Element
extends Node {
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ID_ATTRIBUTE = "id";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String NAMESPACE_ATTRIBUTE = "namespace";
    public static final String VIRTUAL_ATTRIBUTE = "virtual";
    private transient AttributeMap readOnlyAttributes;
    private AttributeMap attributes;
    private CSSStyleRule style = new CSSStyleRule(null, null);
    private ArrayList expressions;
    private transient AttributeMap readOnlyAttributeExpressions;
    private AttributeMap attributeExpressions;
    private HashMap styleExpressions;
    private Map cachedStyleExpressions;
    private boolean enabled = true;
    private boolean virtual;
    private Expression displayCondition;

    protected Element() {
        this.attributes = new AttributeMap();
        this.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
    }

    public String getNamespace() {
        return (String)this.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", NAMESPACE_ATTRIBUTE);
    }

    public void setNamespace(String string) {
        this.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", NAMESPACE_ATTRIBUTE, string);
    }

    public String getId() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", ID_ATTRIBUTE);
    }

    public void setId(String string) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", ID_ATTRIBUTE, string);
    }

    public String getType() {
        return (String)this.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", TYPE_ATTRIBUTE);
    }

    public void setType(String string) {
        this.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", TYPE_ATTRIBUTE, string);
    }

    public void setName(String string) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE, string);
    }

    public String getName() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(this.getNamespace(), string, object);
    }

    public void setAttribute(String string, String string2, Object object) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.attributes.setAttribute(string, string2, object);
        this.readOnlyAttributes = null;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.getNamespace(), string);
    }

    public Object getAttribute(String string, String string2) {
        return this.attributes.getAttribute(string, string2);
    }

    public AttributeMap getAttributeMap() {
        if (this.readOnlyAttributes == null) {
            this.readOnlyAttributes = this.attributes.createUnmodifiableMap();
        } else if (this.readOnlyAttributes.getChangeTracker() != this.attributes.getChangeTracker()) {
            this.readOnlyAttributes = this.attributes.createUnmodifiableMap();
        }
        return this.readOnlyAttributes;
    }

    public CSSStyleRule getStyle() {
        return this.style;
    }

    public void setVisibility(CSSConstant cSSConstant) {
        this.getStyle().setPropertyValue(BoxStyleKeys.VISIBILITY, (CSSValue)cSSConstant);
    }

    public CSSConstant getVisibility() {
        return (CSSConstant)this.getStyle().getPropertyCSSValue(BoxStyleKeys.VISIBILITY);
    }

    public void setAttributeExpression(String string, Expression expression) {
        this.setAttribute(this.getNamespace(), string, expression);
    }

    public void setAttributeExpression(String string, String string2, Expression expression) {
        if (this.attributeExpressions == null) {
            if (expression == null) {
                return;
            }
            this.attributeExpressions = new AttributeMap();
        }
        this.attributeExpressions.setAttribute(string, string2, (Object)expression);
        this.readOnlyAttributeExpressions = null;
    }

    public Expression getAttributeExpression(String string) {
        return this.getAttributeExpression(this.getNamespace(), string);
    }

    public Expression getAttributeExpression(String string, String string2) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return (Expression)this.attributeExpressions.getAttribute(string, string2);
    }

    public Map getAttributeExpressions(String string) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return this.attributeExpressions.getAttributes(string);
    }

    public AttributeMap getAttributeExpressionMap() {
        if (this.attributeExpressions == null) {
            this.readOnlyAttributeExpressions = new AttributeMap();
            return this.readOnlyAttributeExpressions;
        }
        if (this.readOnlyAttributeExpressions == null) {
            this.readOnlyAttributeExpressions = this.attributeExpressions.createUnmodifiableMap();
        } else if (this.readOnlyAttributeExpressions.getChangeTracker() != this.attributeExpressions.getChangeTracker()) {
            this.readOnlyAttributeExpressions = this.attributeExpressions.createUnmodifiableMap();
        }
        return this.readOnlyAttributeExpressions;
    }

    public void setStyleExpression(String string, Expression expression) {
        if (expression == null) {
            if (this.styleExpressions != null) {
                this.styleExpressions.remove(string);
                this.cachedStyleExpressions = null;
            }
        } else {
            if (this.styleExpressions == null) {
                this.styleExpressions = new HashMap();
            }
            this.styleExpressions.put(string, expression);
            this.cachedStyleExpressions = null;
        }
    }

    public Expression getStyleExpression(String string) {
        if (this.styleExpressions == null) {
            return null;
        }
        return (Expression)this.styleExpressions.get(string);
    }

    public Map getStyleExpressions() {
        if (this.styleExpressions == null) {
            return EMPTY_MAP;
        }
        if (this.cachedStyleExpressions != null) {
            return this.cachedStyleExpressions;
        }
        this.cachedStyleExpressions = Collections.unmodifiableMap(this.styleExpressions);
        return this.cachedStyleExpressions;
    }

    public void addExpression(Expression expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        this.expressions.add(expression);
    }

    public Expression[] getExpressions() {
        if (this.expressions == null) {
            return EMPTY_EXPRESSIONS;
        }
        return this.expressions.toArray(new Expression[this.expressions.size()]);
    }

    public void setExpressions(Expression[] expressionArray) {
        if (expressionArray == null) {
            throw new NullPointerException("JFreeReport.setExpressions(...) : null not permitted.");
        }
        if (this.expressions == null) {
            this.expressions = new ArrayList(expressionArray.length);
        } else {
            this.expressions.clear();
        }
        this.expressions.addAll(Arrays.asList(expressionArray));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Expression getDisplayCondition() {
        return this.displayCondition;
    }

    public void setDisplayCondition(Expression expression) {
        this.displayCondition = expression;
    }

    public Locale getLocale() {
        Locale locale = this.getLocaleFromAttributes();
        if (locale != null) {
            return locale;
        }
        return super.getLocale();
    }

    protected Locale getLocaleFromAttributes() {
        Object object = this.getAttribute("http://www.w3.org/XML/1998/namespace", "lang");
        if (object instanceof String) {
            return LocaleUtility.createLocale((String)((String)object));
        }
        if (object instanceof Locale) {
            return (Locale)object;
        }
        Object object2 = this.getAttribute("http://www.w3.org/1999/xhtml", "lang");
        if (object2 instanceof String) {
            return LocaleUtility.createLocale((String)((String)object2));
        }
        if (object2 instanceof Locale) {
            return (Locale)object2;
        }
        return null;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() throws CloneNotSupportedException {
        Object object;
        Element element = (Element)super.clone();
        element.style = (CSSStyleRule)this.style.clone();
        if (this.attributes != null) {
            element.attributes = (AttributeMap)this.attributes.clone();
        }
        if (this.attributeExpressions != null) {
            void expression;
            element.attributeExpressions = (AttributeMap)this.attributeExpressions.clone();
            String[] stringArray = element.attributeExpressions.getNameSpaces();
            boolean i = false;
            while (expression < stringArray.length) {
                object = stringArray[expression];
                Map map = element.attributeExpressions.getAttributes((String)object);
                for (Map.Entry entry : map.entrySet()) {
                    Expression expression2 = (Expression)entry.getValue();
                    entry.setValue(expression2.clone());
                }
                ++expression;
            }
        }
        if (this.expressions != null) {
            element.expressions = (ArrayList)this.expressions.clone();
            element.expressions.clear();
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression entry = (Expression)this.expressions.get(i);
                element.expressions.add(entry.clone());
            }
        }
        if (this.styleExpressions != null) {
            element.styleExpressions = (HashMap)this.styleExpressions.clone();
            for (Map.Entry entry : element.styleExpressions.entrySet()) {
                object = (Expression)entry.getValue();
                entry.setValue(object.clone());
            }
        }
        if (this.displayCondition != null) {
            element.displayCondition = (Expression)this.displayCondition.clone();
        }
        return element;
    }
}

