/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_MM = "Mi\u00e0nmar";
        final String metaValue_NR = "Nabhru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tubhalu";
        final String metaValue_ae = "Avestanais";
        final String metaValue_ar = "Arabais";
        final String metaValue_bn = "Beangailis";
        final String metaValue_bo = "Tibeitis";
        final String metaValue_el = "Greugais";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Eabhra";
        final String metaValue_hy = "Airmeinis";
        final String metaValue_ja = "Seapanais";
        final String metaValue_jv = "De\u00e0bhanais";
        final String metaValue_ka = "Cairtbheilis";
        final String metaValue_km = "Cm\u00e8ar";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Coir\u00e8anais";
        final String metaValue_la = "Laideann";
        final String metaValue_lo = "L\u00e0tho";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolais";
        final String metaValue_si = "Sinhala";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "T\u00e0idh";
        final String metaValue_tl = "Tagalog";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptais";
        final String metaValue_gez = "Ge\u2019ez";
        final String metaValue_got = "Gotais";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_peo = "Seann-Pheirsis";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_syr = "Suraidheac";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Comharran Bliss";
        final Object[][] data = new Object[][] {
            { "Ogam", "Ogham-chraobh" },
            { "Zsym", "Samhlaidhean" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "egy", "\u00c8ipheitis \u00c0rsaidh" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapa Nui" },
            { "ter", "Ter\u00eana" },
            { "AC", "Eilean na Deasgabhalach" },
            { "rar", "C\u00e0nan Rarotonga" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Na h-Iomaratan Arabach Aonaichte" },
            { "nl_BE", "Flannrais" },
            { "AF", "Afghanast\u00e0n" },
            { "AG", "Aint\u00ecoga is Barbuda" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e0inia" },
            { "AM", "Airmeinia" },
            { "Teng", "Tengwar" },
            { "AO", "Ang\u00f2la" },
            { "AQ", "An Antartaig" },
            { "AR", "An Argantain" },
            { "Prti", "Partais snaidh-sgr\u00ecobhte" },
            { "AS", "Samotha na h-Aimeireaga" },
            { "AT", "An Ostair" },
            { "AU", "Astr\u00e0ilia" },
            { "AW", "Ar\u00f9ba" },
            { "en_US", "Beurla na h-Aimeireaga" },
            { "AX", "Na h-Eileanan \u00c5land" },
            { "mye", "Myene" },
            { "AZ", "Asarbaide\u00e0n" },
            { "BA", "Bosna agus Hearsagobhana" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladais" },
            { "kum", "Kumyk" },
            { "BE", "A\u2019 Bheilg" },
            { "gmh", "Meadhan-\u00c0rd-Gearmailtis" },
            { "BF", "Buirciona Faso" },
            { "BG", "A\u2019 Bhulgair" },
            { "BH", "Bachrain" },
            { "BI", "Burundaidh" },
            { "BJ", "Beinin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bearm\u00f9da" },
            { "kut", "Kutenai" },
            { "myv", "Erzya" },
            { "BN", "Br\u00f9naigh" },
            { "BO", "Boilibhia" },
            { "BQ", "Na T\u00ecrean \u00ccsle Caraibeach" },
            { "BR", "Braisil" },
            { "BS", "Na h-Eileanan Bhathama" },
            { "xog", "Soga" },
            { "BT", "But\u00e0n" },
            { "BV", "Eilean Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "A\u2019 Bhealaruis" },
            { "BZ", "A\u2019 Bheil\u00ecs" },
            { "CA", "Canada" },
            { "CC", "Na h-Eileanan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Poblachd Meadhan Afraga" },
            { "CG", "A\u2019 Chongo - Brazzaville" },
            { "CH", "An Eilbheis" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Eileanan Cook" },
            { "CL", "An t-Sile" },
            { "Kthi", "Kaithi" },
            { "CM", "Camarun" },
            { "CN", "An t-S\u00ecn" },
            { "CO", "Coloimbia" },
            { "CP", "Eilean Clipperton" },
            { "CR", "Costa R\u00eccea" },
            { "CU", "C\u00f9ba" },
            { "CV", "An Ceap Uaine" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Eilean na Nollaig" },
            { "CY", "C\u00ecopras" },
            { "CZ", "Poblachd na Seice" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "Flannrais Siarach" },
            { "DE", "A\u2019 Ghearmailt" },
            { "goh", "Seann-\u00c0rd-Gearmailtis" },
            { "ace", "Basa Ac\u00e8h" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Konkani Goa" },
            { "DJ", "Diob\u00f9taidh" },
            { "DK", "An Danmhairg" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Doiminicea" },
            { "DO", "A\u2019 Phoblachd Dhoiminiceach" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zu\u00f1i" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Aildiria" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta agus Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Eacuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "An Eastoin" },
            { "tiv", "Tiv" },
            { "EG", "An \u00c8iphit" },
            { "EH", "Sathara an Iar" },
            { "chg", "Chagatai" },
            { "pau", "Palabhais" },
            { "chk", "C\u00e0nan Chuuk" },
            { "chn", "Chinuk Wawa" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eartra" },
            { "ES", "An Sp\u00e0inn" },
            { "ET", "An Itiop" },
            { "EU", "An t-Aonadh E\u00f2rpach" },
            { "elx", "Elamais" },
            { "chy", "Cheyenne" },
            { "ady", "Adyghe" },
            { "aeb", "Arabais Thuiniseach" },
            { "FI", "An Fhionnlann" },
            { "FJ", "F\u00ecdi" },
            { "FK", "Na h-Eileanan F\u00e0clannach" },
            { "FM", "Na Meanbh-Eileanan" },
            { "FO", "Na h-Eileanan F\u00e0ro" },
            { "Taml", "Taimil" },
            { "FR", "An Fhraing" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picard" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "rgn", "Romagnol" },
            { "grc", "Greugais \u00c0rsaidh" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "GB", "An R\u00ecoghachd Aonaichte" },
            { "GD", "Grean\u00e0da" },
            { "GE", "A\u2019 Chairtbheil" },
            { "GF", "Guidhe\u00e0na na Frainge" },
            { "GG", "Ge\u00e0rnsaidh" },
            { "GH", "G\u00e0na" },
            { "Tale", "Tai Le" },
            { "GI", "Diobraltar" },
            { "afh", "Afrihili" },
            { "GL", "A\u2019 Ghraonlann" },
            { "enm", "Meadhan-Bheurla" },
            { "GM", "A\u2019 Ghaimbia" },
            { "GN", "Gini" },
            { "GP", "Guadalup" },
            { "GQ", "Gini Mheadhan-Chriosach" },
            { "GR", "A\u2019 Ghreug" },
            { "GS", "Se\u00f2rsea a Deas is na h-Eileanan Sandwich a Deas" },
            { "GT", "Guatamala" },
            { "GU", "Guam" },
            { "pdc", "Gearmailtis Phennsylvania" },
            { "GW", "Gini-Bioso" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Tai Lue \u00d9r" },
            { "GY", "Guidhe\u00e0na" },
            { "ckb", "C\u00f9rdais Soran\u00ee" },
            { "zxx", "Susbaint nach eil \u2019na ch\u00e0nan" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Gearmailtis na h-Ostaire" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR na S\u00ecne" },
            { "HM", "Eilean Heard is MhicDh\u00f2mhnaill" },
            { "HN", "Hond\u00f9ras" },
            { "HR", "A\u2019 Chr\u00f2thais" },
            { "agq", "Aghem" },
            { "gsw", "Gearmailtis Eilbheiseach" },
            { "HT", "Haidhti" },
            { "HU", "An Ungair" },
            { "tmh", "Tamashek" },
            { "IC", "Na h-Eileanan Can\u00e0rach" },
            { "nan", "Min Nan" },
            { "peo", metaValue_peo },
            { "ID", "Na h-Innd Innse" },
            { "IE", "\u00c8irinn" },
            { "naq", "Nama" },
            { "zza", "Zazaki" },
            { "Tang", "Tangut" },
            { "IL", "Iosrael" },
            { "IM", "Eilean Mhanainn" },
            { "IN", "Na h-Innseachan" },
            { "IO", "Ranntair Breatannach Cuan nan Innseachan" },
            { "IQ", "Ior\u00e0c" },
            { "IR", "Ior\u00e0n" },
            { "IS", "Innis T\u00ecle" },
            { "IT", "An Eadailt" },
            { "Zmth", "Gn\u00ecomhairean matamataig" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "JE", "De\u00e0rsaidh" },
            { "Beng", metaValue_bn },
            { "JM", "Diameuga" },
            { "JO", "I\u00f2rdan" },
            { "gur", "Frafra" },
            { "JP", "An t-Seapan" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "\u00c0rd-Ghearmailtis na h-Eilbheise" },
            { "KE", "Ceinia" },
            { "419", "Aimeireaga Laidinneach" },
            { "KG", "C\u00ecorgastan" },
            { "KH", "Cambuidea" },
            { "KI", "Ciribeas" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "Naomh Cr\u00ecstean is Nibheis" },
            { "fr_CA", "Fraingis Chanada" },
            { "KP", "Coir\u00e8a a Tuath" },
            { "KR", "Coir\u00e8a a Deas" },
            { "fr_CH", "Fraingis Eilbheiseach" },
            { "KW", "Cuibh\u00e8it" },
            { "tpi", "Tok Pisin" },
            { "KY", "Na h-Eileanan Caimean" },
            { "KZ", "Casachst\u00e0n" },
            { "Cyrl", "Cirilis" },
            { "LA", "L\u00e0thos" },
            { "LB", "Leabanon" },
            { "LC", "Naomh L\u00f9isea" },
            { "phn", "Phenicis" },
            { "Cyrs", "Cirilis Seann-Sl\u00e0bhais na h-Eaglaise" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Gearmailtis \u00ccochdarach" },
            { "LI", "Lichtenstein" },
            { "LK", "Sri Lanca" },
            { "akk", "Acadais" },
            { "cop", metaValue_cop },
            { "LR", "Lib\u00e8ir" },
            { "esu", "Yupik Mheadhanach" },
            { "LS", "Leasoto" },
            { "LT", "An Liotuain" },
            { "LU", "Lugsamburg" },
            { "LV", "An Laitbhe" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libia" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "A\u2019 Mholdobha" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Am Monadh Neagrach" },
            { "MF", "Naomh M\u00e0rtainn" },
            { "lam", "Lamba" },
            { "MG", "Madagasgar" },
            { "Thai", metaValue_th },
            { "MH", "Eileanan Mharshall" },
            { "ale", "Aleutais" },
            { "MK", "A\u2019 Mhasadon" },
            { "ML", "M\u00e0ili" },
            { "MM", metaValue_MM },
            { "MN", "D\u00f9thaich nam Mongol" },
            { "new", "Newari" },
            { "MO", "Mac\u00e0thu SAR na S\u00ecne" },
            { "aln", "Alb\u00e0inis Ghegeach" },
            { "MP", "Na h-Eileanan Mairianach a Tuath" },
            { "MQ", "Mairtinic" },
            { "MR", "Morat\u00e0inea" },
            { "MS", "Montsarat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Na h-Eileanan Mhoiriseas" },
            { "MV", "Na h-Eileanan Mhaladaibh" },
            { "MW", "Malabhaidh" },
            { "MX", "Meagsago" },
            { "MY", "Malaidhsea" },
            { "MZ", "M\u00f2saimbic" },
            { "NA", "An Namaib" },
            { "NC", "Cailleann Nuadh" },
            { "tru", "Turoyo" },
            { "NE", "N\u00ecgeir" },
            { "NF", "Eilean Norfolk" },
            { "NG", "Nig\u00e8iria" },
            { "trv", "Taroko" },
            { "NI", "Niocaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Na T\u00ecrean \u00ccsle" },
            { "NO", "An Nirribhidh" },
            { "NP", "Neap\u00e0l" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Sealainn Nuadh" },
            { "rom", "Romanais" },
            { "crh", "Turcais Chriomach" },
            { "ang", "Seann-Bheurla" },
            { "OM", "Om\u00e0n" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "Caisiubais" },
            { "en_GB", "Beurla Bhreatainn" },
            { "PE", "Pear\u00f9" },
            { "ttt", "Tati" },
            { "PF", "Poilin\u00e8is na Frainge" },
            { "PG", "Gini Nuadh Phaputhach" },
            { "PH", "Na h-Eileanan Filipineach" },
            { "PK", "Pagast\u00e0n" },
            { "PL", "A\u2019 Ph\u00f2lainn" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre agus Miquelon" },
            { "PN", "Eilean Peit a\u2019 Ch\u00e0irn" },
            { "PR", "Porto R\u00ecceo" },
            { "PS", "Na Ranntairean Palastaineach" },
            { "Bali", "Bali" },
            { "PT", "A\u2019 Phortagail" },
            { "PW", "Palabh" },
            { "nia", "Nias" },
            { "PY", "Paraguaidh" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Catar" },
            { "%%SCOTLAND", "Beurla Bhun-Tomhasach na h-Alba" },
            { "jam", "Beurla Cr\u00ectheolach Diameuga" },
            { "pms", "Piedmontese" },
            { "niu", "C\u00e0nan Niue" },
            { "QO", "Roinn Iomallach a\u2019 Chuain S\u00e8imh" },
            { "ext", "C\u00e0nan na h-Extremadura" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "001", "An Saoghal" },
            { "002", "Afraga" },
            { "njo", "Ao Naga" },
            { "003", "Aimeireaga a Tuath" },
            { "RE", "R\u00e9union" },
            { "005", "Aimeireaga a Deas" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "Rjng", "Rejang" },
            { "009", "Roinn a\u2019 Chuain S\u00e8imh" },
            { "RO", "Rom\u00e0inia" },
            { "RS", "An t-S\u00e8irb" },
            { "Mroo", "Mro" },
            { "RU", "An Ruis" },
            { "RW", "Rubhanda" },
            { "Khar", "Kharoshthi" },
            { "SA", "Ar\u00e0ibia nan Sabhd" },
            { "pon", "C\u00e0nan Pohnpei" },
            { "SB", "Eileanan Sholaimh" },
            { "twq", "Tasawaq" },
            { "011", "Afraga an Iar" },
            { "SC", "Na h-Eileanan Sheiseall" },
            { "SD", "Sud\u00e0n" },
            { "013", "Meadhan Aimeireaga" },
            { "SE", "An t-Suain" },
            { "014", "Afraga an Ear" },
            { "arc", "Aramais" },
            { "Loma", "Loma" },
            { "015", "Afraga a Tuath" },
            { "SG", "Singeap\u00f2r" },
            { "SH", "Eilean Naomh Eilidh" },
            { "017", "Meadhan Afraga" },
            { "SI", "An t-Sl\u00f2bhain" },
            { "018", "Ceann a Deas Afraga" },
            { "SJ", "Svalbard agus Jan Mayen" },
            { "019", "An D\u00e0 Aimeireaga" },
            { "SK", "An t-Sl\u00f2bhac" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Siarra Le\u00f2mhann" },
            { "SM", "San Marino" },
            { "SN", "Seanagal" },
            { "SO", "Som\u00e0ilia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "SR", "Suranam" },
            { "aro", "Araona" },
            { "SS", "Sud\u00e0n a Deas" },
            { "ST", "S\u00e3o Tom\u00e9 agus Pr\u00edncipe" },
            { "arq", "Arabais Aildireach" },
            { "SV", "An Salbhador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siridhea" },
            { "yao", "Yao" },
            { "SZ", "D\u00f9thaich nan Suasaidh" },
            { "arw", "Arawak" },
            { "arz", "Arabais \u00c8ipheiteach" },
            { "ary", "Arabais Mhorocach" },
            { "yap", "C\u00e0nan Yap" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Ceann a Tuath Aimeireaga" },
            { "TC", "Na h-Eileanan Turcach is Caiceo" },
            { "yav", "Yangben" },
            { "TD", "An t-Se\u00e0d" },
            { "TF", "Ranntairean a Deas na Frainge" },
            { "ase", "Cainnt-shanais na h-Aimeireaga" },
            { "TG", "Togo" },
            { "TH", "D\u00f9thaich nan T\u00e0idh" },
            { "Qaac", "Qaac" },
            { "TJ", "Taidigeast\u00e0n" },
            { "TK", metaValue_TK },
            { "029", "Am Muir Caraibeach" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "TM", "Turcmanast\u00e0n" },
            { "TN", "Tuinisea" },
            { "TO", "Tonga" },
            { "TR", "An Tuirc" },
            { "TT", "Trianaid agus Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taidh-Bh\u00e0n" },
            { "ast", "Ast\u00f9rais" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "An Tansan" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Litreadh neo-aithnichte" },
            { "Sind", "Khudawadi" },
            { "UA", "An Ucr\u00e0in" },
            { "lij", "Liog\u00f9rais" },
            { "030", "\u00c0isia an Ear" },
            { "tyv", "C\u00e0nan Tuva" },
            { "sw_CD", "Kiswahili na Congo" },
            { "034", "\u00c0isia a Deas" },
            { "hai", "Haida" },
            { "035", "\u00c0isia an Ear-dheas" },
            { "UG", "Uganda" },
            { "hak", "Hakka" },
            { "039", "An Roinn-E\u00f2rpa a Deas" },
            { "Sinh", metaValue_si },
            { "UM", "Meanbh-Eileanan Iomallach nan SA" },
            { "US", "Na St\u00e0itean Aonaichte" },
            { "haw", "C\u00e0nan Hawai\u2019i" },
            { "UY", "Uruguaidh" },
            { "prg", "Pruisis" },
            { "UZ", "Usbagast\u00e0n" },
            { "tzm", "Tamazight Meadhan na h-Atlas" },
            { "nnh", "Ngiemboon" },
            { "VA", "Cathair na Bhatacain" },
            { "pro", "Seann-Phroven\u00e7al" },
            { "VC", "Naomh Bhionsant agus Eileanan Greanadach" },
            { "VE", "A\u2019 Bheiniseala" },
            { "VG", "Eileanan Breatannach na Maighdinn" },
            { "VI", "Eileanan Aimeireagach na Maighdinn" },
            { "VN", "Bhiet-Nam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Seann-Lochlannais" },
            { "053", "Astr\u00e0ilia is Sealainn Nuadh" },
            { "054", "Na h-Eileanan Dubha" },
            { "WF", "Uallas agus Futuna" },
            { "057", "Roinn nam Meanbh-Eileanan" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakh\u00f3ta" },
            { "nov", "Novial" },
            { "avk", "Kotava" },
            { "wae", "Gearmailtis Wallis" },
            { "WS", "Samotha" },
            { "Bass", "Bassa Vah" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Poilin\u00e8is" },
            { "XK", "A\u2019 Chosobho" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Gun sgr\u00ecobhadh" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "An Eaman" },
            { "nqo", "N\u2019Ko" },
            { "lmo", "Lombardais" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "YT", "Mayotte" },
            { "ZA", "Afraga a Deas" },
            { "Deva", "Devanagari" },
            { "Hira", "Hiragana" },
            { "ZM", "S\u00e0imbia" },
            { "ZW", "An t-S\u00ecombab" },
            { "ZZ", "Roinn-d\u00f9thcha neo-aithnichte" },
            { "Runr", "R\u00f9n-sgr\u00ecobhadh" },
            { "lol", "Mongo" },
            { "nso", "Leasotais Thuathach" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "jmc", "Machame" },
            { "hif", "Hindis Fh\u00ecditheach" },
            { "hil", "Hiligaynon" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "hit", "C\u00e0nan Het" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Dealbh-sgr\u00ecobhadh Mayach" },
            { "lrc", "Luri Thuathach" },
            { "Copt", metaValue_cop },
            { "nwc", "Newari Chlasaigeach" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "sah", "Sachais" },
            { "sam", "Aramais Shamaritanach" },
            { "Aghb", "Alb\u00e0inis Chabhcasach" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Peirsis I\u00f9dhach" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "sbp", "Sangu" },
            { "lui", "Luise\u00f1o" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipinis" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Baluch\u00ec" },
            { "den", "Slavey" },
            { "ban", "C\u00e0nan Bali" },
            { "fit", "Me\u00e4nkieli" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "jrb", "Arabais I\u00f9dhach" },
            { "es_ES", "Sp\u00e0inntis E\u00f2rpach" },
            { "nzi", "Nzima" },
            { "sco", "Albais" },
            { "scn", "Sisilis" },
            { "aa", "Afar" },
            { "ab", "Abchasais" },
            { "bbc", "Batak Toba" },
            { "ae", metaValue_ae },
            { "af", "Afraganais" },
            { "ak", "Akan" },
            { "bbj", "Ghomala" },
            { "am", "Amtharais" },
            { "Arab", metaValue_ar },
            { "an", "Aragonais" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana no Hiragana" },
            { "as", "Asamais" },
            { "sdc", "Sassarese" },
            { "Lina", "Linear A" },
            { "av", "Avarais" },
            { "Linb", "Linear B" },
            { "sdh", "C\u00f9rdais Dheasach" },
            { "ay", "Aymara" },
            { "az", "Asarbaide\u00e0nais" },
            { "Khoj", "Khojki" },
            { "ba", "Bashkir" },
            { "be", "Bealaruisis" },
            { "bg", "Bulgarais" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breatnais" },
            { "bs", "Bosnais" },
            { "see", "Seneca" },
            { "Mymr", metaValue_MM },
            { "sei", "Seri" },
            { "seh", "Sena" },
            { "Nkoo", "N\u2019ko" },
            { "sel", "Selkup" },
            { "ca", "Catalanais" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Deideanais" },
            { "ch", "Chamorro" },
            { "co", "Corsais" },
            { "Orya", "Oriya" },
            { "cr", "Cree" },
            { "cs", "Seacais" },
            { "cu", "Sl\u00e0bhais na h-Eaglaise" },
            { "yrl", "Nheengatu" },
            { "cv", "Chuvash" },
            { "cy", "Cuimris" },
            { "Yiii", "Yi" },
            { "da", "Danmhairgis" },
            { "pt_PT", "Portagailis E\u00f2rpach" },
            { "de", "Gearmailtis" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "bem", "Bemba" },
            { "sga", "Seann-Ghaeilge" },
            { "dv", "Divehi" },
            { "es_419", "Sp\u00e0inntis na h-Aimeireaga Laidinneach" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "lzh", "S\u00ecnis an Litreachais" },
            { "dje", "Zarma" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "ro_MD", "Moldobhais" },
            { "el", metaValue_el },
            { "en", "Beurla" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Laz" },
            { "es", "Sp\u00e0inntis" },
            { "et", "Eastoinis" },
            { "eu", "Basgais" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "S\u00f2rbais Uachdarach" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Peirsis" },
            { "Hans", "Simplichte" },
            { "Hant", "Tradaiseanta" },
            { "ff", "Fulah" },
            { "shu", "Arabais Se\u00e0dach" },
            { "hsn", "Xiang" },
            { "fi", "Fionnlannais" },
            { "fj", "F\u00ecdis" },
            { "fon", "Fon" },
            { "bgn", "Balochi Shiarach" },
            { "yue", "Cantonais" },
            { "fo", "F\u00e0rothais" },
            { "umb", "Umbundu" },
            { "fr", "Fraingis" },
            { "sid", "Sidamo" },
            { "fy", "Fr\u00ecoslannais Shiarach" },
            { "ga", "Gaeilge" },
            { "gd", "G\u00e0idhlig" },
            { "gl", "Gail\u00ecsis" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "C\u00e0nan neo-aithnichte" },
            { "gu", metaValue_gu },
            { "gv", "Gaelg" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindis" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Cr\u00f2thaisis" },
            { "ht", "Cr\u00ectheol Haidhti" },
            { "hu", "Ungairis" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Fraingis nan Cajun" },
            { "ia", "Interlingua" },
            { "id", "Innd-Innsis" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Yi Sichuan" },
            { "frm", "Meadhan-Fhraingis" },
            { "ik", "Inupiaq" },
            { "fro", "Seann-Fhraingis" },
            { "frp", "Arpitan" },
            { "io", "Ido" },
            { "frs", "Fr\u00ecoslannais Earach" },
            { "bjn", "Banjar" },
            { "frr", "Fr\u00ecoslannais Thuathach" },
            { "is", "Innis T\u00eclis" },
            { "it", "Eadailtis" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Seann-Arabais Dheasach" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "bkm", "Kom" },
            { "sma", "S\u00e0mais Dheasach" },
            { "jv", metaValue_jv },
            { "mad", "C\u00e0nan Madhura" },
            { "smj", "S\u00e0mais Lule" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "S\u00e0mais Inari" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Wu" },
            { "sms", "S\u00e0mais Skolt" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Maasai" },
            { "kj", "Kuanyama" },
            { "kk", "Casachais" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Caismiris" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "C\u00f9rdais" },
            { "kv", "Komi" },
            { "kw", "C\u00f2rnais" },
            { "ky", "C\u00ecorgasais" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "lb", "Lugsamburgais" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "C\u00e0nan Limburg" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Fri\u00f9ilis" },
            { "lo", metaValue_lo },
            { "lt", "Liotuainis" },
            { "lu", "Luba-Katanga" },
            { "lv", "Laitbheis" },
            { "mg", "Malagasais" },
            { "mh", "Marshallais" },
            { "mi", "M\u0101ori" },
            { "mk", "Masadonais" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaidhis" },
            { "mt", "Maltais" },
            { "Saur", metaValue_saz },
            { "my", "Burmais" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "S\u00f2rbais \u00ccochdarach" },
            { "Armi", "Aramais impireil" },
            { "na", metaValue_NR },
            { "nb", "Bokm\u00e5l na Nirribhidh" },
            { "nd", "Ndebele Thuathach" },
            { "ne", "Neap\u00e0lais" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Duitsis" },
            { "nn", "Nynorsk na Nirribhidh" },
            { "no", "Nirribhis" },
            { "nr", "Ndebele Dheasach" },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Chichewa" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "oc", "Ogsatanais" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Dusun Mheadhanach" },
            { "or", "Odia" },
            { "Modi", "Modi" },
            { "os", "Ossetic" },
            { "bpy", "Bishnupriya" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Panjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "P\u00f2lainnis" },
            { "dum", "Meadhan-Dhuitsis" },
            { "ps", "Pashto" },
            { "pt", "Portagailis" },
            { "mga", "Meadhan-Ghaeilge" },
            { "pt_BR", "Portagailis Bhraisileach" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "ssy", "Saho" },
            { "brh", "Brahui" },
            { "qu", "Ceatsua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_gez },
            { "rm", "Rumains" },
            { "rn", "Kirundi" },
            { "ro", "Rom\u00e0inis" },
            { "ru", "Ruisis" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Sukuma" },
            { "en_AU", "Beurla Astr\u00e0ilia" },
            { "sa", "Sanskrit" },
            { "sc", "S\u00e0rdais" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "S\u00e0mais Thuathach" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "S\u00e8irb-Chr\u00f2thaisis" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "C\u00e0nan Sumer" },
            { "sk", "Sl\u00f2bhacais" },
            { "sl", "Sl\u00f2bhainis" },
            { "Gran", "Grantha" },
            { "sm", "Samothais" },
            { "sn", "Shona" },
            { "so", "Som\u00e0ilis" },
            { "sq", "Alb\u00e0inis" },
            { "sr", "S\u00e8irbis" },
            { "ss", "Swati" },
            { "Java", metaValue_jv },
            { "st", "Leasotach Dheasach" },
            { "su", "C\u00e0nan Sunda" },
            { "sv", "Suainis" },
            { "sw", "Kiswahili" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", "Taimilis" },
            { "142", "\u00c0isia" },
            { "bua", "Buriat" },
            { "143", "Meadhan \u00c0isia" },
            { "te", metaValue_te },
            { "145", "\u00c0isia an Iar" },
            { "tg", "Taidigis" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "bug", "C\u00e0nan nam Bugis" },
            { "kfo", "Koro" },
            { "en_CA", "Beurla Chanada" },
            { "tk", "Turcmanais" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongais" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "tr", "Turcais" },
            { "ts", "Tsonga" },
            { "swb", "Comorais" },
            { "Cakm", "Chakma" },
            { "tt", "Tatarais" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "C\u00e0nan Tahiti" },
            { "150", "An Roinn-E\u00f2rpa" },
            { "151", "An Roinn-E\u00f2rpa an Ear" },
            { "154", "An Roinn-E\u00f2rpa a Tuath" },
            { "dzg", "Dazaga" },
            { "155", "An Roinn-E\u00f2rpa an Iar" },
            { "ug", "\u00d9igiurais" },
            { "Kore", metaValue_ko },
            { "Ital", "Seann-Eadailtis" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Coitcheann" },
            { "uk", "Ucr\u00e0inis" },
            { "zea", "C\u00e0nan Zeeland" },
            { "ur", "\u00d9rdu" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Usbagais" },
            { "kha", "Khasi" },
            { "nds_NL", "Sagsannais \u00ccochdarach" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "vi", "Bhiet-Namais" },
            { "kho", "C\u00e0nan Khotan" },
            { "khq", "Koyra Chiini" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Suraidheac Chlasaigeach" },
            { "Osma", "Osmanya" },
            { "quc", "K\u2019iche\u2019" },
            { "qug", "Quichua \u00c0rd-t\u00ecr Chimborazo" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "Gan" },
            { "kiu", "Kirmanjki" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Stannardach Moroco" },
            { "ar_001", "Nuadh-Arabais Stannardach" },
            { "Cans", "Sgr\u00ecobhadh Lideach Aonaichte nan T\u00f9sanach Canadach" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Manchu" },
            { "Latf", "Laideann fraktur" },
            { "Hluw", "Dealbh-sgr\u00ecobhadh Anatolach" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "Laideann Gh\u00e0idhealach" },
            { "xh", "Xhosa" },
            { "byn", "Blin" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Dari Zoroastrach" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "Syrc", metaValue_syr },
            { "yi", "I\u00f9dhais" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Ioruba" },
            { "es_MX", "Sp\u00e0inntis Mheagsagach" },
            { "Syrj", "Suraidheac Siarach" },
            { "ota", "Turcais Otomanach" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "kln", "Kalenjin" },
            { "zh", "S\u00ecnis" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "zu", "Zulu" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "Cham", "Cham" },
            { "gez", metaValue_gez },
            { "mrj", "Mari Shiarach" },
            { "Syrn", "Suraidheac Earach" },
            { "Narb", "Seann-Arabach Thuathach" },
            { "Tglg", metaValue_tl },
            { "ebu", "Embu" },
            { "Egyp", "Sealbh-sgr\u00ecobhadh \u00c8ipheiteach" },
            { "zh_Hans", "S\u00ecnis Shimplichte" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Seann-Ungarais" },
            { "kok", "Konkani" },
            { "zh_Hant", "S\u00ecnis Thradaiseanta" },
            { "Sund", "Sunda" },
            { "vep", "Veps" },
            { "kpe", metaValue_kpe },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "Cprt", "C\u00ecoprasais" },
            { "mua", "Mundang" },
            { "mul", "Iomadh c\u00e0nan" },
            { "cad", "Caddo" },
            { "mus", "Creek" },
            { "gil", "Ciribeasais" },
            { "Cher", metaValue_chr },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
