/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0aae\u0aa7\u0acd\u0aaf \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0ab8\u0aae\u0aaf",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0aae\u0acb\u0ab8\u0acd\u0a95\u0acb \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "MSK",
               "\u0aae\u0acb\u0ab8\u0acd\u0a95\u0acb \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "MSD",
               "\u0aae\u0acb\u0ab8\u0acd\u0a95\u0acb \u0ab8\u0aae\u0aaf",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0a9c\u0abe\u0aaa\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "JST",
               "\u0a9c\u0abe\u0aaa\u0abe\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "JDT",
               "\u0a9c\u0abe\u0aaa\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0aaa\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PKT",
               "\u0aaa\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "PKST",
               "\u0aaa\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u0aa4\u0abe\u0a87\u0aaa\u0ac7\u0a87 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CST",
               "\u0aa4\u0abe\u0a87\u0aaa\u0ac7\u0a87 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "CDT",
               "\u0aa4\u0abe\u0a87\u0aaa\u0ac7\u0a87 \u0ab8\u0aae\u0aaf",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u0ab9\u0acb\u0ab5\u0acd\u0aa1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "HOVT",
               "\u0ab9\u0acb\u0ab5\u0acd\u0aa1 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "HOVST",
               "\u0ab9\u0acb\u0ab5\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u0aae\u0a97\u0abe\u0aa1\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "MAGT",
               "\u0aae\u0a97\u0abe\u0aa1\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "MAGST",
               "\u0aae\u0a97\u0abe\u0aa1\u0aa8 \u0ab8\u0aae\u0aaf",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "ACWST",
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "ACWDT",
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0ab8\u0aae\u0aaf",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0aae\u0aa7\u0acd\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CET",
               "\u0aae\u0aa7\u0acd\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "CEST",
               "\u0aae\u0aa7\u0acd\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0ab8\u0a96\u0abe\u0ab2\u0abf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "SAKT",
               "\u0ab8\u0a96\u0abe\u0ab2\u0abf\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "SAKST",
               "\u0ab8\u0a96\u0abe\u0ab2\u0abf\u0aa8 \u0ab8\u0aae\u0aaf",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u0aaa\u0ac7\u0ab0\u0abe\u0a97\u0acd\u0ab5\u0ac7 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PYT",
               "\u0aaa\u0ac7\u0ab0\u0abe\u0a97\u0acd\u0ab5\u0ac7 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "PYST",
               "\u0aaa\u0ac7\u0ab0\u0abe\u0a97\u0acd\u0ab5\u0ac7 \u0ab8\u0aae\u0aaf",
               "PYT",
            };
        final String[] Acre = new String[] {
               "\u0a8f\u0a95\u0ab0 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "ACT",
               "\u0a8f\u0a95\u0ab0 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "ACST",
               "\u0a8f\u0a95\u0ab0 \u0ab8\u0aae\u0aaf",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "\u0aae\u0ab2\u0ac7\u0ab6\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "EST",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "EDT",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0ab8\u0aae\u0aaf",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0ab2\u0acb\u0ab0\u0acd\u0aa1 \u0ab9\u0acb\u0ab5 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "LHST",
               "\u0ab2\u0acb\u0ab0\u0acd\u0aa1 \u0ab9\u0acb\u0ab5 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "LHDT",
               "\u0ab2\u0acb\u0ab0\u0acd\u0aa1 \u0ab9\u0acb\u0ab5 \u0ab8\u0aae\u0aaf",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0aa8\u0acd\u0aaf\u0ac1\u0a9d\u0ac0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "NZST",
               "\u0aa8\u0acd\u0aaf\u0ac1\u0a9d\u0ac0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "NZDT",
               "\u0aa8\u0acd\u0aaf\u0ac1\u0a9d\u0ac0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0aad\u0abe\u0ab0\u0aa4\u0ac0\u0aaf \u0aae\u0ab9\u0abe\u0ab8\u0abe\u0a97\u0ab0 \u0ab8\u0aae\u0aaf",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0aaf\u0abe\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "YAKT",
               "\u0aaf\u0abe\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "YAKST",
               "\u0aaf\u0abe\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0ab8\u0aae\u0aaf",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0aae\u0acb\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0ab8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "MUT",
               "\u0aae\u0acb\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0ab8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "MUST",
               "\u0aae\u0acb\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0ab8 \u0ab8\u0aae\u0aaf",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0ab8\u0aae\u0aaf",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0aa4\u0abf\u0aae\u0acb\u0ab0 \u0ab8\u0aae\u0aaf",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0ab8\u0acb\u0ab2\u0acb\u0aae\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0a95\u0acb\u0ab8\u0ab0\u0ac7 \u0ab8\u0aae\u0aaf",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0aae\u0abe\u0ab0\u0acd\u0ab6\u0ab2 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "EET",
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0ac0\u0aaf\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "EEST",
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0aa8\u0acd\u0aaf\u0ac2\u0aab\u0abe\u0a89\u0aa8\u0acd\u0aa1\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "NST",
               "\u0aa8\u0acd\u0aaf\u0ac2\u0aab\u0abe\u0a89\u0aa8\u0acd\u0aa1\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "NDT",
               "\u0aa8\u0acd\u0aaf\u0ac2\u0aab\u0abe\u0a89\u0aa8\u0acd\u0aa1\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0a85\u0aab\u0a98\u0abe\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0ab9\u0acb\u0a82\u0a97 \u0a95\u0acb\u0a82\u0a97 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "HKT",
               "\u0ab9\u0acb\u0a82\u0a97 \u0a95\u0acb\u0a82\u0a97 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "HKST",
               "\u0ab9\u0acb\u0a82\u0a97 \u0a95\u0acb\u0a82\u0a97 \u0ab8\u0aae\u0aaf",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a85\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "ART",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a85\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "ARST",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a85\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0a85\u0a9f\u0ab2\u0abe\u0aa8\u0acd\u0a9f\u0abf\u0a95 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "AST",
               "\u0a85\u0a9f\u0ab2\u0abe\u0aa8\u0acd\u0a9f\u0abf\u0a95 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "ADT",
               "\u0a85\u0a9f\u0ab2\u0abe\u0aa8\u0acd\u0a9f\u0abf\u0a95 \u0ab8\u0aae\u0aaf",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u0aaa\u0acb\u0aa8\u0aaa\u0ac7 \u0ab8\u0aae\u0aaf",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u0aac\u0acb\u0ab2\u0abf\u0ab5\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0ab8\u0ac7\u0a82\u0a9f \u0aaa\u0ac0\u0a8f\u0ab0\u0ac7 \u0a8f\u0aa8\u0acd\u0aa1 \u0aae\u0abf\u0a95\u0ac0\u0ab2\u0acb\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PMST",
               "\u0ab8\u0ac7\u0a82\u0a9f \u0aaa\u0ac0\u0a8f\u0ab0\u0ac7 \u0a8f\u0aa8\u0acd\u0aa1 \u0aae\u0abf\u0a95\u0ac0\u0ab2\u0acb\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "PMDT",
               "\u0ab8\u0ac7\u0a82\u0a9f \u0aaa\u0ac0\u0a8f\u0ab0\u0ac7 \u0a8f\u0aa8\u0acd\u0aa1 \u0aae\u0abf\u0a95\u0ac0\u0ab2\u0acb\u0aa8 \u0ab8\u0aae\u0aaf",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0a87\u0aa8\u0acd\u0aa1\u0acb\u0a9a\u0abe\u0a87\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0aaf\u0ac7\u0a95\u0abe\u0a9f\u0ac7\u0ab0\u0abf\u0aa8\u0aac\u0ab0\u0acd\u0a97 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "YEKT",
               "\u0aaf\u0ac7\u0a95\u0abe\u0a9f\u0ac7\u0ab0\u0abf\u0aa8\u0aac\u0ab0\u0acd\u0a97 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "YEKST",
               "\u0aaf\u0ac7\u0a95\u0abe\u0a9f\u0ac7\u0ab0\u0abf\u0aa8\u0aac\u0ab0\u0acd\u0a97 \u0ab8\u0aae\u0aaf",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0aae\u0abe\u0ab2\u0aa6\u0ac0\u0ab5 \u0ab8\u0aae\u0aaf",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u0aa4\u0abe\u0ab9\u0abf\u0aa4\u0ac0 \u0ab8\u0aae\u0aaf",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0a87\u0a9d\u0ab0\u0abe\u0a87\u0ab2 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "IST",
               "\u0a87\u0a9d\u0ab0\u0abe\u0a87\u0ab2 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "IDT",
               "\u0a87\u0a9d\u0ab0\u0abe\u0a87\u0ab2 \u0ab8\u0aae\u0aaf",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0aae\u0aa7\u0acd\u0aaf \u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u0ab5\u0ac9\u0ab2\u0abf\u0ab8 \u0a85\u0aa8\u0ac7 \u0aab\u0acd\u0aaf\u0ac1\u0a9a\u0ac1\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0ab8\u0acd\u0aaf\u0acb\u0ab5\u0abe \u0ab8\u0aae\u0aaf",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0ab2\u0abe\u0a87\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0a89\u0a9d\u0acd\u0aac\u0ac7\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "UZT",
               "\u0a89\u0a9d\u0acd\u0aac\u0ac7\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "UZST",
               "\u0a89\u0a9d\u0acd\u0aac\u0ac7\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0a93\u0aae\u0ab8\u0acd\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "OMST",
               "\u0a93\u0aae\u0acd\u0ab8\u0acd\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "OMSST",
               "\u0a93\u0aae\u0acd\u0ab8\u0acd\u0a95 \u0ab8\u0aae\u0aaf",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0ab8\u0ac7\u0ab6\u0ab2\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0a89\u0ab0\u0ac2\u0a97\u0acd\u0ab5\u0ac7 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "UYT",
               "\u0a89\u0ab0\u0ac2\u0a97\u0acd\u0ab5\u0ac7 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "UYST",
               "\u0a89\u0ab0\u0ac2\u0a97\u0acd\u0ab5\u0ac7 \u0ab8\u0aae\u0aaf",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0aa8\u0ac7\u0aaa\u0abe\u0ab3 \u0ab8\u0aae\u0aaf",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0a89\u0ab2\u0abe\u0aa8 \u0aac\u0abe\u0a9f\u0acb\u0ab0 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "ULAT",
               "\u0a89\u0ab2\u0abe\u0aa8 \u0aac\u0a9f\u0acb\u0ab0 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "ULAST",
               "\u0a89\u0ab2\u0abe\u0aa8 \u0aac\u0abe\u0a9f\u0acb\u0ab0 \u0ab8\u0aae\u0aaf",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0a95\u0ac7\u0aa8\u0acd\u0aa6\u0acd\u0ab0\u0abf\u0aaf \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "CST",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "CDT",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0ab8\u0aae\u0aaf",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0a9a\u0ac1\u0a89\u0a95 \u0ab8\u0aae\u0aaf",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0aa8\u0ac0\u0aaf\u0ac1 \u0ab8\u0aae\u0aaf",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u0ab5\u0ac5\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u0aab\u0ac9\u0a95\u0ab2\u0ac5\u0a82\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "FKT",
               "\u0aab\u0acb\u0a95\u0ab2\u0ac5\u0a82\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "FKST",
               "\u0aab\u0acb\u0a95\u0ab2\u0ac5\u0a82\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u0ab5\u0aa8\u0abe\u0aa4\u0ac2 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "VUT",
               "\u0ab5\u0aa8\u0abe\u0aa4\u0ac2 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "VUST",
               "\u0ab5\u0aa8\u0abe\u0aa4\u0ac2 \u0ab8\u0aae\u0aaf",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0aa8\u0acb\u0ab5\u0ab8\u0abf\u0aac\u0abf\u0ab0\u0acd\u0ab8\u0acd\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "NOVT",
               "\u0aa8\u0acb\u0ab5\u0ab8\u0abf\u0aac\u0abf\u0ab0\u0acd\u0ab8\u0acd\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "NOVST",
               "\u0aa8\u0acb\u0ab5\u0ab8\u0abf\u0aac\u0abf\u0ab0\u0acd\u0ab8\u0acd\u0a95 \u0ab8\u0aae\u0aaf",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0ab8\u0abf\u0a82\u0a97\u0abe\u0aaa\u0ac1\u0ab0 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u0a8f\u0a9d\u0acb\u0ab0\u0acd\u0ab8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "AZOT",
               "\u0a8f\u0a9d\u0acb\u0ab0\u0acd\u0ab8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "AZOST",
               "\u0a8f\u0a9d\u0acb\u0ab0\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u0a8f\u0aaa\u0abf\u0aaf\u0abe \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "WSST",
               "\u0a85\u0aaa\u0abf\u0aaf\u0abe \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "WSDT",
               "\u0a8f\u0aaa\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u0aad\u0ac2\u0a9f\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0ab8\u0ac2\u0ab0\u0ac0\u0aa8\u0abe\u0aae \u0ab8\u0aae\u0aaf",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0aa8\u0acc\u0ab0\u0ac1 \u0ab8\u0aae\u0aaf",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0a95\u0acd\u0ab0\u0ab8\u0acd\u0aa8\u0acb\u0aaf\u0abe\u0ab0\u0acd\u0ab8\u0acd\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "KRAT",
               "\u0a95\u0acd\u0ab0\u0ac7\u0ab8\u0aa8\u0acb\u0aaf\u0abe\u0ab0\u0acd\u0ab8\u0acd\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "KRAST",
               "\u0a95\u0acd\u0ab0\u0ac7\u0ab8\u0acd\u0aa8\u0acb\u0aaf\u0abe\u0ab0\u0acd\u0ab8\u0acd\u0a95\u0ac0 \u0ab8\u0aae\u0aaf",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a95\u0a9d\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u0aae\u0acd\u0aaf\u0abe\u0aa8\u0aae\u0abe\u0ab0 \u0ab8\u0aae\u0aaf",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0a95\u0acd\u0ab0\u0abf\u0ab8\u0aae\u0ab8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0a8f\u0aae\u0ac7\u0a9d\u0acb\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "AMT",
               "\u0a8f\u0aae\u0ac7\u0a9d\u0acb\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "AMST",
               "\u0a8f\u0aae\u0ac7\u0a9d\u0acb\u0aa8 \u0ab8\u0aae\u0aaf",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a95\u0a9d\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u0aab\u0abf\u0a9c\u0ac0 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "FJT",
               "\u0aab\u0abf\u0a9c\u0ac0 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "FJST",
               "\u0aab\u0abf\u0a9c\u0ac0 \u0ab8\u0aae\u0aaf",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0ab0\u0ac0\u0aaf\u0ac2\u0aa8\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0a95\u0acb\u0a95\u0acb\u0a9d \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u0a9a\u0ac7\u0aa4\u0ab9\u0abe\u0aae \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CHAST",
               "\u0a9a\u0ac7\u0aa4\u0ab9\u0abe\u0aae \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "CHADT",
               "\u0a9a\u0ac7\u0aa4\u0ab9\u0abe\u0aae \u0ab8\u0aae\u0aaf",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u0ab5\u0acb\u0ab8\u0acd\u0a9f\u0acb\u0a95 \u0ab8\u0aae\u0aaf",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0a85\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "ART",
               "\u0a86\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "ARST",
               "\u0a85\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u0a97\u0ac7\u0aae\u0acd\u0aac\u0abf\u0aaf\u0ab0 \u0ab8\u0aae\u0aaf",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "\u0aaa\u0ac7\u0a9f\u0acd\u0ab0\u0acb\u0aaa\u0ac7\u0ab5\u0ab2\u0acb\u0ab5\u0acd\u0ab8\u0acd\u0a95-\u0a95\u0abe\u0aae\u0a9a\u0aa4\u0ab8\u0acd\u0a95\u0ac0 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "PETT",
               "\u0aaa\u0ac7\u0a9f\u0acd\u0ab0\u0acb\u0aaa\u0ac7\u0ab5\u0ab2\u0acb\u0ab5\u0acd\u0ab8\u0acd\u0a95-\u0a95\u0abe\u0aae\u0a9a\u0aa4\u0ab8\u0acd\u0a95\u0ac0 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "PETST",
               "\u0aaa\u0ac7\u0a9f\u0acd\u0ab0\u0acb\u0aaa\u0ac7\u0ab5\u0ab2\u0acb\u0ab5\u0acd\u0ab8\u0acd\u0a95-\u0a95\u0abe\u0aae\u0a9a\u0aa4\u0ab8\u0acd\u0a95\u0ac0 \u0ab8\u0aae\u0aaf",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u0a9f\u0ab5\u0abe\u0ab2\u0ac2 \u0ab8\u0aae\u0aaf",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u0a97\u0abe\u0ab2\u0abe\u0aaa\u0abe\u0a97\u0acb\u0ab8 \u0ab8\u0aae\u0aaf",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u0aae\u0ac7\u0a95\u0acd\u0ab5\u0abe\u0aaf\u0ab0 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u0ab5\u0ac7\u0aa8\u0ac7\u0a9d\u0ac1\u0a8f\u0ab2\u0abe \u0ab8\u0aae\u0aaf",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0ab9\u0ab5\u0abe\u0a87-\u0a8f\u0ab2\u0acd\u0aaf\u0ac1\u0ab6\u0abf\u0a85\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "HAST",
               "\u0ab9\u0ab5\u0abe\u0a87-\u0a8f\u0ab2\u0acd\u0aaf\u0ac1\u0ab6\u0abf\u0a85\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "HADT",
               "\u0ab9\u0ab5\u0abe\u0a88-\u0a8f\u0ab2\u0acd\u0aaf\u0ac1\u0ab6\u0abf\u0a85\u0aa8 \u0ab8\u0aae\u0aaf",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "ACST",
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aae\u0aa7\u0acd\u0aaf \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "ACDT",
               "\u0aae\u0aa7\u0acd\u0aaf \u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "PST",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "PDT",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0ab8\u0aae\u0aaf",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0aab\u0acb\u0aa8\u0abf\u0a95\u0acd\u0ab8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0aae\u0ac7\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "TMT",
               "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0aae\u0ac7\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "TMST",
               "\u0aa4\u0ac1\u0ab0\u0acd\u0a95\u0aae\u0ac7\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "WET",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "WEST",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0a95\u0ac5\u0aaa \u0ab5\u0ab0\u0acd\u0aa1\u0ac7 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CVT",
               "\u0a95\u0ac5\u0aaa \u0ab5\u0ab0\u0acd\u0aa1\u0ac7 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "CVST",
               "\u0a95\u0ac5\u0aaa \u0ab5\u0ab0\u0acd\u0aa1\u0ac7 \u0ab8\u0aae\u0aaf",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0aa8\u0acb\u0ab0\u0aab\u0ac9\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u0a97\u0aaf\u0abe\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u0aaa\u0abf\u0a9f\u0a95\u0ac7\u0aaf\u0ab0\u0acd\u0aa8 \u0ab8\u0aae\u0aaf",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0ab0\u0acb\u0aa5\u0ac7\u0ab0\u0abe \u0ab8\u0aae\u0aaf",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0ab8\u0aae\u0acb\u0a86 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "SST",
               "\u0ab8\u0aae\u0acb\u0a86 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "SDT",
               "\u0ab8\u0aae\u0acb\u0a86 \u0ab8\u0aae\u0aaf",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u0aaa\u0ab2\u0abe\u0a89 \u0ab8\u0aae\u0aaf",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u0a86\u0a97\u0ab3\u0aa8\u0ac1\u0a82-\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0aaf\u0ac1\u0ab0\u0acb\u0aaa\u0ac0\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "AZT",
               "\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "AZST",
               "\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u0aae\u0acb\u0ab8\u0aa8 \u0ab8\u0aae\u0aaf",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0ac0\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "MST",
               "\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0ac0\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "MDT",
               "\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0ac0\u0a95\u0aa8 \u0aaa\u0ac7\u0ab8\u0abf\u0aab\u0abf\u0a95 \u0ab8\u0aae\u0aaf",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0aa1\u0ac7\u0ab5\u0abf\u0ab8 \u0ab8\u0aae\u0aaf",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0a95\u0acd\u0aaf\u0ac2\u0aac\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CST",
               "\u0a95\u0acd\u0aaf\u0ac2\u0aac\u0abe \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "CDT",
               "\u0a95\u0acd\u0aaf\u0ac2\u0aac\u0abe \u0ab8\u0aae\u0aaf",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "WAT",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "WAST",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0abe \u0ab8\u0aae\u0aaf",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab5\u0abf\u0a9a \u0aae\u0aa7\u0acd\u0aaf\u0aae \u0ab8\u0aae\u0aaf",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abe\u0a87\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PHT",
               "\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abe\u0a87\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "PHST",
               "\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abe\u0a87\u0aa8 \u0ab8\u0aae\u0aaf",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u0aab\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9a \u0ab8\u0abe\u0a89\u0aa7\u0ab0\u0acd\u0aa8 \u0a85\u0aa8\u0ac7 \u0a8f\u0aa8\u0acd\u0a9f\u0abe\u0ab0\u0acd\u0a95\u0a9f\u0abf\u0a95 \u0ab8\u0aae\u0aaf",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0ac0\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0aa8\u0acd\u0aaf\u0ac1 \u0ab8\u0ac7\u0ab2\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "NCT",
               "\u0aa8\u0acd\u0aaf\u0ac1 \u0ab8\u0ac7\u0ab2\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "NCST",
               "\u0aa8\u0acd\u0aaf\u0ac1 \u0ab8\u0ac7\u0ab2\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u0aac\u0acd\u0ab0\u0ac2\u0aa8\u0ac7\u0a88 \u0aa6\u0abe\u0ab0\u0ac1\u0ab8\u0ab2\u0abe\u0aae \u0ab8\u0aae\u0aaf",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0a88\u0ab0\u0abe\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "IRST",
               "\u0a88\u0ab0\u0abe\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "IRDT",
               "\u0a88\u0ab0\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0a87\u0ab8\u0acd\u0a9f\u0ab0 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "EAST",
               "\u0a87\u0ab8\u0acd\u0a9f\u0ab0 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "EASST",
               "\u0a87\u0ab8\u0acd\u0a9f\u0ab0 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0acb \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PST",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0acb \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "PDT",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0acb \u0ab8\u0aae\u0aaf",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0aa1\u0acd\u0aaf\u0ac1\u0aae\u0acb\u0aa8\u0acd\u0a9f-\u0aa1\u0ac0\u2018\u0a89\u0ab0\u0acd\u0ab5\u0abf\u0ab2 \u0ab8\u0aae\u0aaf",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u0aa4\u0abe\u0a9c\u0ac0\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u0a9f\u0acb\u0a82\u0a97\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "TOT",
               "\u0a9f\u0acb\u0a82\u0a97\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "TOST",
               "\u0a9f\u0acb\u0a82\u0a97\u0abe \u0ab8\u0aae\u0aaf",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe\u0aa6\u0ac7\u0ab6 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "BDT",
               "\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe\u0aa6\u0ac7\u0ab6 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "BDST",
               "\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe\u0aa6\u0ac7\u0ab6 \u0ab8\u0aae\u0aaf",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u0aaa\u0ac7\u0ab0\u0ac1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "PET",
               "\u0aaa\u0ac7\u0ab0\u0ac1 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "PEST",
               "\u0aaa\u0ac7\u0ab0\u0ac1 \u0ab8\u0aae\u0aaf",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "WGT",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "WGST",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0a8f\u0a95\u0acd\u0ab5\u0abe\u0aa1\u0acb\u0ab0 \u0ab8\u0aae\u0aaf",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "EGT",
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "EGST",
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5 \u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0a97\u0ab2\u0acd\u0aab \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0a95\u0acb\u0ab0\u0abf\u0aaf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "KST",
               "\u0a95\u0acb\u0ab0\u0abf\u0aaf\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "KDT",
               "\u0a95\u0acb\u0ab0\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "AWST",
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "AWDT",
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0a95\u0abf\u0ab0\u0acd\u0a97\u0abf\u0a9d\u0aa4\u0abe\u0aa8 \u0ab8\u0aae\u0aaf",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "AEST",
               "\u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "AEDT",
               "\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac0\u0aaf \u0a93\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0aab\u0acd\u0ab0\u0ac7\u0aa8\u0acd\u0a9a \u0a97\u0aaf\u0abe\u0aa8\u0abe \u0ab8\u0aae\u0aaf",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0a95\u0acb\u0ab2\u0a82\u0aac\u0abf\u0aaf\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "COT",
               "\u0a95\u0acb\u0ab2\u0a82\u0aac\u0abf\u0aaf\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "COST",
               "\u0a95\u0acb\u0ab2\u0a82\u0aac\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0a9a\u0abf\u0ab2\u0ac0 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CLT",
               "\u0a9a\u0abf\u0ab2\u0ac0 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "CLST",
               "\u0a9a\u0abf\u0ab2\u0ac0 \u0ab8\u0aae\u0aaf",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0a97\u0abf\u0ab2\u0aac\u0ab0\u0acd\u0a9f \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0ab8\u0aae\u0aaf",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0abe\u0a89\u0aa8\u0acd\u0a9f\u0aa8 \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "MST",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0abe\u0a89\u0aa8\u0acd\u0a9f\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "MDT",
               "\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0aae\u0abe\u0a89\u0aa8\u0acd\u0a9f\u0aa8 \u0ab8\u0aae\u0aaf",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u0aae\u0abe\u0ab0\u0acd\u0a95\u0acd\u0aaf\u0ac2\u0ab8\u0ab8 \u0ab8\u0aae\u0aaf",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "AST",
               "\u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "ADT",
               "\u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0aa8 \u0ab8\u0aae\u0aaf",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0a85\u0ab2\u0abe\u0ab8\u0acd\u0a95\u0abe \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "AKST",
               "\u0a85\u0ab2\u0abe\u0ab8\u0acd\u0a95\u0abe \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "AKDT",
               "\u0a85\u0ab2\u0abe\u0ab8\u0acd\u0a95\u0abe \u0ab8\u0aae\u0aaf",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0ab5\u0acd\u0ab2\u0abe\u0aa1\u0abf\u0ab5\u0acb\u0ab8\u0acd\u0a9f\u0acb\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "VLAT",
               "\u0ab5\u0acd\u0ab2\u0abe\u0aa1\u0abf\u0ab5\u0acb\u0ab8\u0acd\u0a9f\u0acb\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "VLAST",
               "\u0ab5\u0acd\u0ab2\u0abe\u0aa1\u0abf\u0ab5\u0acb\u0ab8\u0acd\u0a9f\u0acb\u0a95 \u0ab8\u0aae\u0aaf",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u0a95\u0ac7\u0aae\u0acb\u0ab0\u0acb \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0a87\u0ab0\u0acd\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "IRKT",
               "\u0a87\u0ab0\u0acd\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "IRKST",
               "\u0a87\u0ab0\u0acd\u0a95\u0ac1\u0aa4\u0acd\u0ab8\u0acd\u0a95 \u0ab8\u0aae\u0aaf",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "GET",
               "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "GEST",
               "\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u0a9f\u0acb\u0a95\u0ab2\u0abe\u0a89 \u0ab8\u0aae\u0aaf",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u0aaa\u0abe\u0aaa\u0ac1\u0a86 \u0aa8\u0acd\u0aaf\u0ac1 \u0a97\u0abf\u0aa8\u0ac0 \u0ab8\u0aae\u0aaf",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0aab\u0ab0\u0acd\u0aa8\u0abe\u0aa8\u0acd\u0aa1\u0acb \u0aa1\u0ac0 \u0aa8\u0acb\u0ab0\u0acb\u0aa8\u0acd\u0ab9\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "FNT",
               "\u0aab\u0ab0\u0aa8\u0ac7\u0aa8\u0acd\u0aa1\u0acb \u0aa6\u0ac7 \u0aa8\u0acb\u0ab0\u0acb\u0ab9\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "FNST",
               "\u0aab\u0ab0\u0acd\u0aa8\u0abe\u0aa8\u0acd\u0aa1\u0acb \u0aa1\u0ac0 \u0aa8\u0acb\u0ab0\u0acb\u0aa8\u0acd\u0ab9\u0abe \u0ab8\u0aae\u0aaf",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0a9a\u0acb\u0a87\u0aac\u0abe\u0ab2\u0acd\u0ab8\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CHOT",
               "\u0a9a\u0acb\u0a87\u0aac\u0abe\u0ab2\u0acd\u0ab8\u0aa8 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "CHOST",
               "\u0a9a\u0acb\u0a87\u0aac\u0abe\u0ab2\u0acd\u0ab8\u0aa8 \u0ab8\u0aae\u0aaf",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2\u0abf\u0aaf\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "BRT",
               "\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2\u0abf\u0aaf\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "BRST",
               "\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0a9a\u0ac0\u0aa8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CST",
               "\u0a9a\u0ac0\u0aa8 \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf",
               "CDT",
               "\u0a9a\u0ac0\u0aa8 \u0ab8\u0aae\u0aaf",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0abe \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "AMT",
               "\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "AMST",
               "\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0abe \u0ab8\u0aae\u0aaf",
               "AMT",
            };
        final String[] Samara = new String[] {
               "\u0ab8\u0aae\u0abe\u0ab0\u0abe \u0aaa\u0acd\u0ab0\u0aae\u0abe\u0aa3\u0aad\u0ac2\u0aa4 \u0ab8\u0aae\u0aaf",
               "SAMT",
               "\u0ab8\u0aae\u0abe\u0ab0\u0abe \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "SAMST",
               "\u0ab8\u0aae\u0abe\u0ab0\u0abe \u0ab8\u0aae\u0aaf",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u0aad\u0abe\u0ab0\u0aa4\u0ac0\u0aaf \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0a95\u0ac1\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
               "CKT",
               "\u0a95\u0ac1\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0a85\u0ab0\u0acd\u0aa7 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
               "CKHST",
               "\u0a95\u0ac1\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8 \u0ab8\u0aae\u0aaf",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab5\u0abf\u0a9a \u0aae\u0aa7\u0acd\u0aaf\u0aae \u0ab8\u0aae\u0aaf",
                    "GMT",
                    "\u0aac\u0acd\u0ab0\u0abf\u0a9f\u0abf\u0ab6 \u0a97\u0acd\u0ab0\u0ac0\u0ab7\u0acd\u0aae \u0ab8\u0aae\u0aaf",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab5\u0abf\u0a9a \u0aae\u0aa7\u0acd\u0aaf\u0aae \u0ab8\u0aae\u0aaf",
                    "GMT",
                    "\u0a86\u0a88\u0ab0\u0abf\u0ab6 \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
