/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_it extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Ora dell\u2019Africa centrale",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Ora standard di Mosca",
               "MSK",
               "Ora legale di Mosca",
               "MSD",
               "Ora di Mosca",
               "MT",
            };
        final String[] Japan = new String[] {
               "Ora standard del Giappone",
               "JST",
               "Ora legale del Giappone",
               "JDT",
               "Ora del Giappone",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Ora standard del Pakistan",
               "PKT",
               "Ora legale del Pakistan",
               "PKST",
               "Ora del Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Ora standard di Taipei",
               "CST",
               "Ora legale di Taipei",
               "CDT",
               "Ora di Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Ora standard di Hovd",
               "HOVT",
               "Ora legale di Hovd",
               "HOVST",
               "Ora di Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Ora standard di Magadan",
               "MAGT",
               "Ora legale di Magadan",
               "MAGST",
               "Ora di Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard dell\u2019Australia centroccidentale",
               "ACWST",
               "Ora legale dell\u2019Australia centroccidentale",
               "ACWDT",
               "Ora dell\u2019Australia centroccidentale",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard dell\u2019Europa centrale",
               "CET",
               "Ora legale dell\u2019Europa centrale",
               "CEST",
               "Ora dell\u2019Europa centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard di Sakhalin",
               "SAKT",
               "Ora legale di Sakhalin",
               "SAKST",
               "Ora di Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Ora standard del Paraguay",
               "PYT",
               "Ora legale del Paraguay",
               "PYST",
               "Ora del Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Ora della Malesia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard orientale USA",
               "EST",
               "Ora legale orientale USA",
               "EDT",
               "Ora orientale USA",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard di Lord Howe",
               "LHST",
               "Ora legale di Lord Howe",
               "LHDT",
               "Ora di Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Ora standard della Nuova Zelanda",
               "NZST",
               "Ora legale della Nuova Zelanda",
               "NZDT",
               "Ora della Nuova Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora dell\u2019Oceano Indiano",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard di Yakutsk",
               "YAKT",
               "Ora legale di Yakutsk",
               "YAKST",
               "Ora di Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Ora standard delle Mauritius",
               "MUT",
               "Ora legale delle Mauritius",
               "MUST",
               "Ora delle Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora dell\u2019Africa orientale",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ora di Timor Est",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Ora delle Isole Salomone",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Ora del Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora delle Isole Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard dell\u2019Europa orientale",
               "EET",
               "Ora legale dell\u2019Europa orientale",
               "EEST",
               "Ora dell\u2019Europa orientale",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard di Terranova",
               "NST",
               "Ora legale di Terranova",
               "NDT",
               "Ora di Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Ora dell\u2019Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standard di Hong Kong",
               "HKT",
               "Ora legale di Hong Kong",
               "HKST",
               "Ora di Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora standard dell\u2019Argentina occidentale",
               "ART",
               "Ora legale dell\u2019Argentina occidentale",
               "ARST",
               "Ora dell\u2019Argentina occidentale",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Ora standard dell\u2019Atlantico",
               "AST",
               "Ora legale dell\u2019Atlantico",
               "ADT",
               "Ora dell\u2019Atlantico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ora di Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Ora della Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard di Saint-Pierre e Miquelon",
               "PMST",
               "Ora legale di Saint-Pierre e Miquelon",
               "PMDT",
               "Ora di Saint-Pierre e Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Ora dell\u2019Indocina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard di Ekaterinburg",
               "YEKT",
               "Ora legale di Ekaterinburg",
               "YEKST",
               "Ora di Ekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Ora delle Maldive",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Ora di Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Ora standard di Israele",
               "IST",
               "Ora legale di Israele",
               "IDT",
               "Ora di Israele",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora dell\u2019Indonesia centrale",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Ora di Wallis e Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora dell\u2019Africa meridionale",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Ora di Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Ora delle Sporadi equatoriali",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standard dell\u2019Uzbekistan",
               "UZT",
               "Ora legale dell\u2019Uzbekistan",
               "UZST",
               "Ora dell\u2019Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Ora standard di Omsk",
               "OMST",
               "Ora legale di Omsk",
               "OMSST",
               "Ora di Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Ora delle Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Ora standard dell\u2019Uruguay",
               "UYT",
               "Ora legale dell\u2019Uruguay",
               "UYST",
               "Ora dell\u2019Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Ora del Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ora standard di Ulan Bator",
               "ULAT",
               "Ora legale di Ulan Bator",
               "ULAST",
               "Ora di Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Ora standard centrale USA",
               "CST",
               "Ora legale centrale USA",
               "CDT",
               "Ora centrale USA",
               "CT",
            };
        final String[] Truk = new String[] {
               "Ora del Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Ora di Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Ora dell\u2019Isola di Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Ora standard delle Isole Falkland",
               "FKT",
               "Ora legale delle Isole Falkland",
               "FKST",
               "Ora delle Isole Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Ora standard del Vanuatu",
               "VUT",
               "Ora legale del Vanuatu",
               "VUST",
               "Ora del Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard di Novosibirsk",
               "NOVT",
               "Ora legale di Novosibirsk",
               "NOVST",
               "Ora di Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Ora Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Ora standard delle Azzorre",
               "AZOT",
               "Ora legale delle Azzorre",
               "AZOST",
               "Ora delle Azzorre",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Ora standard di Apia",
               "WSST",
               "Ora legale di Apia",
               "WSDT",
               "Ora di Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Ora del Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Ora del Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Ora di Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard di Krasnoyarsk",
               "KRAT",
               "Ora legale di Krasnoyarsk",
               "KRAST",
               "Ora di Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora del Kazakistan occidentale",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Ora della Birmania",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Ora dell\u2019Isola Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Ora standard dell\u2019Amazzonia",
               "AMT",
               "Ora legale dell\u2019Amazzonia",
               "AMST",
               "Ora dell\u2019Amazzonia",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora del Kazakistan orientale",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Ora standard delle Figi",
               "FJT",
               "Ora legale delle Figi",
               "FJST",
               "Ora delle Figi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Ora di Riunione",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Ora delle Isole Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Ora standard delle Chatham",
               "CHAST",
               "Ora legale delle Chatham",
               "CHADT",
               "Ora delle Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Ora di Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Ora standard dell\u2019Argentina",
               "ART",
               "Ora legale dell\u2019Argentina",
               "ARST",
               "Ora dell\u2019Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Ora di Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Ora standard di Petropavlovsk-Kamchatski",
               "PETT",
               "Ora legale di Petropavlovsk-Kamchatski",
               "PETST",
               "Ora di Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Ora di Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Ora delle Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Ora dell\u2019Isola Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Ora del Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard delle Isole Hawaii-Aleutine",
               "HAST",
               "Ora legale delle Isole Hawaii-Aleutine",
               "HADT",
               "Ora delle isole Hawaii-Aleutine",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard dell\u2019Australia centrale",
               "ACST",
               "Ora legale dell\u2019Australia centrale",
               "ACDT",
               "Ora dell\u2019Australia centrale",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard del Pacifico USA",
               "PST",
               "Ora legale del Pacifico USA",
               "PDT",
               "Ora del Pacifico USA",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora delle Isole della Fenice",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standard del Turkmenistan",
               "TMT",
               "Ora legale del Turkmenistan",
               "TMST",
               "Ora del Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard dell\u2019Europa occidentale",
               "WET",
               "Ora legale dell\u2019Europa occidentale",
               "WEST",
               "Ora dell\u2019Europa occidentale",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standard di Capo Verde",
               "CVT",
               "Ora legale di Capo Verde",
               "CVST",
               "Ora di Capo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Ora delle Isole Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Ora della Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Ora delle Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Ora di Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Ora standard di Samoa",
               "SST",
               "Ora legale di Samoa",
               "SDT",
               "Ora di Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Ora di Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Ora dell\u2019Europa orientale (Kaliningrad)",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard dell\u2019Azerbaigian",
               "AZT",
               "Ora legale dell\u2019Azerbaigian",
               "AZST",
               "Ora dell\u2019Azerbaigian",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Ora di Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standard del Pacifico (Messico)",
               "MST",
               "Ora legale del Pacifico (Messico)",
               "MDT",
               "Ora del Pacifico (Messico)",
               "MT",
            };
        final String[] Davis = new String[] {
               "Ora di Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Ora standard di Cuba",
               "CST",
               "Ora legale di Cuba",
               "CDT",
               "Ora di Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard dell\u2019Africa occidentale",
               "WAT",
               "Ora legale dell\u2019Africa occidentale",
               "WAST",
               "Ora dell\u2019Africa occidentale",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Ora del meridiano di Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Ora standard delle Filippine",
               "PHT",
               "Ora legale delle Filippine",
               "PHST",
               "Ora delle Filippine",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Ora delle Terre australi e antartiche francesi",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Ora della Georgia del Sud",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standard della Nuova Caledonia",
               "NCT",
               "Ora legale della Nuova Caledonia",
               "NCST",
               "Ora della Nuova Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Ora del Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Ora standard dell\u2019Iran",
               "IRST",
               "Ora legale dell\u2019Iran",
               "IRDT",
               "Ora dell\u2019Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Ora standard dell\u2019Isola di Pasqua",
               "EAST",
               "Ora legale dell\u2019Isola di Pasqua",
               "EASST",
               "Ora dell\u2019Isola di Pasqua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora standard del Messico nord-occidentale",
               "PST",
               "Ora legale del Messico nord-occidentale",
               "PDT",
               "Ora del Messico nord-occidentale",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora di Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Ora del Tagikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Ora standard di Tonga",
               "TOT",
               "Ora legale di Tonga",
               "TOST",
               "Ora di Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard del Bangladesh",
               "BDT",
               "Ora legale del Bangladesh",
               "BDST",
               "Ora del Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Ora standard del Per\u00f9",
               "PET",
               "Ora legale del Per\u00f9",
               "PEST",
               "Ora del Per\u00f9",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard della Groenlandia occidentale",
               "WGT",
               "Ora legale della Groenlandia occidentale",
               "WGST",
               "Ora della Groenlandia occidentale",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ora dell\u2019Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard della Groenlandia orientale",
               "EGT",
               "Ora legale della Groenlandia orientale",
               "EGST",
               "Ora della Groenlandia orientale",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Ora del Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora dell\u2019Indonesia orientale",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Ora standard coreana",
               "KST",
               "Ora legale coreana",
               "KDT",
               "Ora coreana",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard dell\u2019Australia occidentale",
               "AWST",
               "Ora legale dell\u2019Australia occidentale",
               "AWDT",
               "Ora dell\u2019Australia occidentale",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Ora del Kirghizistan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora dell\u2019Indonesia occidentale",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard dell\u2019Australia orientale",
               "AEST",
               "Ora legale dell\u2019Australia orientale",
               "AEDT",
               "Ora dell\u2019Australia orientale",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Ora della Guiana francese",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Ora standard della Colombia",
               "COT",
               "Ora legale della Colombia",
               "COST",
               "Ora della Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Ora standard del Cile",
               "CLT",
               "Ora legale del Cile",
               "CLST",
               "Ora del Cile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora delle isole Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard Montagne Rocciose USA",
               "MST",
               "Ora legale Montagne Rocciose USA",
               "MDT",
               "Ora Montagne Rocciose USA",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Ora delle Marchesi",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Ora standard araba",
               "AST",
               "Ora legale araba",
               "ADT",
               "Ora araba",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Ora standard dell\u2019Alaska",
               "AKST",
               "Ora legale dell\u2019Alaska",
               "AKDT",
               "Ora dell\u2019Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard di Vladivostok",
               "VLAT",
               "Ora legale di Vladivostok",
               "VLAST",
               "Ora di Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Ora Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard di Irkutsk",
               "IRKT",
               "Ora legale di Irkutsk",
               "IRKST",
               "Ora di Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Ora standard della Georgia",
               "GET",
               "Ora legale della Georgia",
               "GEST",
               "Ora della Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Ora di Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora della Papua Nuova Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Ora standard di Fernando de Noronha",
               "FNT",
               "Ora legale di Fernando de Noronha",
               "FNST",
               "Ora di Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard di Choibalsan",
               "CHOT",
               "Ora legale di Choibalsan",
               "CHOST",
               "Ora di Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Ora standard di Brasilia",
               "BRT",
               "Ora legale di Brasilia",
               "BRST",
               "Ora di Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Ora standard della Cina",
               "CST",
               "Ora legale della Cina",
               "CDT",
               "Ora della Cina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ora standard dell\u2019Armenia",
               "AMT",
               "Ora legale dell\u2019Armenia",
               "AMST",
               "Ora dell\u2019Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Ora standard di Samara",
               "SAMT",
               "Ora legale di Samara",
               "SAMST",
               "Ora di Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Ora standard dell\u2019India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Ora standard delle isole Cook",
               "CKT",
               "Ora legale media delle isole Cook",
               "CKHST",
               "Ora delle isole Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale dell\u2019Irlanda",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
