'''OpenGL extension VERSION.GL_1_1

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_1_1 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_1_1.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_1_1 import *
from OpenGL.raw.GL.VERSION.GL_1_1 import _EXTENSION_NAME

def glInitGl11VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawElements.indices size not checked against 'count,type'
glDrawElements=wrapper.wrapper(glDrawElements).setInputArraySize(
    'indices', None
)
glGetPointerv=wrapper.wrapper(glGetPointerv).setOutput(
    'params',size=(1,),orPassIn=True
)
# INPUT glTexSubImage1D.pixels size not checked against 'format,type,width'
glTexSubImage1D=wrapper.wrapper(glTexSubImage1D).setInputArraySize(
    'pixels', None
)
# INPUT glTexSubImage2D.pixels size not checked against 'format,type,width,height'
glTexSubImage2D=wrapper.wrapper(glTexSubImage2D).setInputArraySize(
    'pixels', None
)
# INPUT glDeleteTextures.textures size not checked against n
glDeleteTextures=wrapper.wrapper(glDeleteTextures).setInputArraySize(
    'textures', None
)
glGenTextures=wrapper.wrapper(glGenTextures).setOutput(
    'textures',size=lambda x:(x,),pnameArg='n',orPassIn=True
)
# INPUT glColorPointer.pointer size not checked against 'size,type,stride'
glColorPointer=wrapper.wrapper(glColorPointer).setInputArraySize(
    'pointer', None
)
# INPUT glEdgeFlagPointer.pointer size not checked against 'stride'
glEdgeFlagPointer=wrapper.wrapper(glEdgeFlagPointer).setInputArraySize(
    'pointer', None
)
# INPUT glIndexPointer.pointer size not checked against 'type,stride'
glIndexPointer=wrapper.wrapper(glIndexPointer).setInputArraySize(
    'pointer', None
)
# INPUT glInterleavedArrays.pointer size not checked against 'format,stride'
glInterleavedArrays=wrapper.wrapper(glInterleavedArrays).setInputArraySize(
    'pointer', None
)
# INPUT glNormalPointer.pointer size not checked against 'type,stride'
glNormalPointer=wrapper.wrapper(glNormalPointer).setInputArraySize(
    'pointer', None
)
# INPUT glTexCoordPointer.pointer size not checked against 'size,type,stride'
glTexCoordPointer=wrapper.wrapper(glTexCoordPointer).setInputArraySize(
    'pointer', None
)
# INPUT glVertexPointer.pointer size not checked against 'size,type,stride'
glVertexPointer=wrapper.wrapper(glVertexPointer).setInputArraySize(
    'pointer', None
)
# INPUT glAreTexturesResident.textures size not checked against n
glAreTexturesResident=wrapper.wrapper(glAreTexturesResident).setInputArraySize(
    'textures', None
).setOutput(
    'residences',size=lambda x:(x,),pnameArg='n',orPassIn=True
)
# INPUT glPrioritizeTextures.textures size not checked against n
# INPUT glPrioritizeTextures.priorities size not checked against n
glPrioritizeTextures=wrapper.wrapper(glPrioritizeTextures).setInputArraySize(
    'textures', None
).setInputArraySize(
    'priorities', None
)
glIndexubv=wrapper.wrapper(glIndexubv).setInputArraySize(
    'c', 1
)
### END AUTOGENERATED SECTION
from OpenGL.GL.VERSION.GL_1_0 import *
GL_MODELVIEW0_EXT = GL_MODELVIEW # alias
GL_MODELVIEW0_MATRIX_EXT = GL_MODELVIEW_MATRIX # alias
GL_MODELVIEW0_STACK_DEPTH_EXT = GL_MODELVIEW_STACK_DEPTH # alias
GL_TEXTURE_COMPONENTS = GL_TEXTURE_INTERNAL_FORMAT # alias

# See: http://lists.freedesktop.org/archives/mesa-dev/2011-October/013095.html
# basically these names were present for a while in the .spec files but were not 
# actually used officially, the mapped values here are what is supposed to get 
# used instead.
GL_DEPTH_BUFFER = GL_DEPTH
GL_STENCIL_BUFFER = GL_STENCIL
