/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.File;
import java.io.IOException;

public class TeXSyntaxException
extends IOException {
    private String errorTag;
    private String[] params;
    private int lineNum = -1;
    private File file = null;
    public static final String ERROR_BAD_PARAM = "tex.error.bad_param";
    public static final String ERROR_NO_EG = "tex.error.no_eg";
    public static final String ERROR_PAR_BEFORE_EG = "tex.error.par_before_eg";
    public static final String ERROR_UNEXPECTED_EG = "tex.error.unexpected_eg";
    public static final String ERROR_MISSING_ENDMATH = "tex.error.missing_endmath";
    public static final String ERROR_DOLLAR2_ENDED_WITH_DOLLAR = "tex.error.dollar2_ended_with_dollar";
    public static final String ERROR_NOT_FOUND = "tex.error.not_found";
    public static final String ERROR_MISSING_PARAM = "tex.error.missing_param";
    public static final String ERROR_EMPTY_STACK = "tex.error.empty_stack";
    public static final String ERROR_NOT_MATH_MODE = "tex.error.not_math_mode";
    public static final String ERROR_INVALID_ACCENT = "tex.error.invalid_accent";
    public static final String ERROR_AMBIGUOUS_MIDCS = "tex.error.ambiguous.mid_cs";
    public static final String ERROR_MISSING_CLOSING = "tex.error.missing_closing";
    public static final String ERROR_DIMEN_EXPECTED = "tex.error.dimen_expected";
    public static final String ERROR_MISSING_UNIT = "tex.error.missing_unit";
    public static final String ERROR_EXPECTED = "tex.error.expected";
    public static final String ERROR_UNDEFINED = "tex.error.undefined";
    public static final String ERROR_UNDEFINED_CHAR = "tex.error.undefined_char";
    public static final String ERROR_CS_EXPECTED = "tex.error.cs_expected";
    public static final String ERROR_NUMBER_EXPECTED = "tex.error.number_expected";
    public static final String ERROR_REGISTER_UNDEF = "tex.error.register_undef";
    public static final String ERROR_SYNTAX = "tex.error.syntax";
    public static final String ERROR_EXTRA = "tex.error.extra";
    public static final String ERROR_DOUBLE_SUBSCRIPT = "tex.error.double_subscript";
    public static final String ERROR_DOUBLE_SUPERSCRIPT = "tex.error.double_superscript";
    public static final String ERROR_MISPLACED_OMIT = "tex.error.misplaced_omit";
    public static final String ERROR_ILLEGAL_ALIGN = "tex.error.illegal_align";
    public static final String ERROR_IMPROPER_ALPHABETIC_CONSTANT = "tex.error.improper_alphabetic_constant";
    public static final String ERROR_EXTRA_OR_FORGOTTEN = "tex.error.extra_or_forgotten";

    public TeXSyntaxException(String string) {
        this(null, -1, string, (String)null);
    }

    public TeXSyntaxException(File file, String string) {
        this(file, -1, string, (String)null);
    }

    public TeXSyntaxException(int n, String string) {
        this(null, n, string, (String)null);
    }

    public TeXSyntaxException(File file, int n, String string) {
        this(file, n, string, (String)null);
    }

    public TeXSyntaxException(String string, String string2) {
        this(null, -1, string, string2);
    }

    public TeXSyntaxException(String string, String[] stringArray) {
        this(null, -1, string, stringArray);
    }

    public TeXSyntaxException(File file, String string, String string2) {
        this(file, -1, string, string2);
    }

    public TeXSyntaxException(File file, String string, String[] stringArray) {
        this(file, -1, string, stringArray);
    }

    public TeXSyntaxException(int n, String string, String string2) {
        this(null, n, string, string2);
    }

    public TeXSyntaxException(int n, String string, String[] stringArray) {
        this(null, n, string, stringArray);
    }

    public TeXSyntaxException(TeXParser teXParser, String string, String string2) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, string2);
    }

    public TeXSyntaxException(TeXParser teXParser, String string, String[] stringArray) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, stringArray);
    }

    public TeXSyntaxException(TeXParser teXParser, String string, String string2, Throwable throwable) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, string2, throwable);
    }

    public TeXSyntaxException(TeXParser teXParser, String string, String[] stringArray, Throwable throwable) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, stringArray, throwable);
    }

    public TeXSyntaxException(TeXParser teXParser, String string) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, (String)null);
    }

    public TeXSyntaxException(TeXParser teXParser, String string, Throwable throwable) {
        this(teXParser == null ? null : teXParser.getCurrentFile(), teXParser == null ? -1 : teXParser.getLineNumber(), string, (String)null, throwable);
    }

    public TeXSyntaxException(File file, int n, String string, String[] stringArray) {
        super("TeX syntax error code " + string);
        this.file = file;
        this.errorTag = string;
        this.params = stringArray;
        this.lineNum = n;
    }

    public TeXSyntaxException(File file, int n, String string, String string2) {
        super("TeX syntax error code " + string);
        this.file = file;
        this.errorTag = string;
        this.lineNum = n;
        if (string2 != null) {
            this.params = new String[]{string2};
        }
    }

    public TeXSyntaxException(File file, int n, String string, String[] stringArray, Throwable throwable) {
        super("TeX syntax error code " + string, throwable);
        this.file = file;
        this.errorTag = string;
        this.params = stringArray;
        this.lineNum = n;
    }

    public TeXSyntaxException(File file, int n, String string, String string2, Throwable throwable) {
        super("TeX syntax error code " + string, throwable);
        this.file = file;
        this.errorTag = string;
        this.lineNum = n;
        if (string2 != null) {
            this.params = new String[]{string2};
        }
    }

    public String getErrorTag() {
        return this.errorTag;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setLineNumber(int n) {
        this.lineNum = n;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getMessage(TeXApp teXApp) {
        String string;
        String string2 = string = this.params == null ? teXApp.getMessage(this.errorTag) : teXApp.getMessage(this.errorTag, this.params);
        if (this.file == null && this.lineNum == -1) {
            return string;
        }
        if (this.lineNum == -1) {
            return String.format("%s: %s", this.file.getName(), string);
        }
        if (this.file == null) {
            return String.format("l.%d: %s", this.lineNum, string);
        }
        return String.format("%s:%d: %s", this.file.getName(), this.lineNum, string);
    }
}

