/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ByteBufferHolder;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNioOutputBuffer
extends AbstractOutputBuffer<NioChannel> {
    private NioChannel socket;
    private NioSelectorPool pool;
    protected volatile boolean flipped = false;

    public InternalNioOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
    }

    @Override
    public void init(SocketWrapper<NioChannel> socketWrapper, AbstractEndpoint<NioChannel> endpoint) throws IOException {
        this.socket = socketWrapper.getSocket();
        this.pool = ((NioEndpoint)endpoint).getSelectorPool();
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.socket != null) {
            this.socket.getBufHandler().getWriteBuffer().clear();
            this.socket = null;
        }
        this.flipped = false;
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.socket.getBufHandler().getWriteBuffer().put(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            int result = this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, true);
            if (result < 0) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeToSocket(ByteBuffer bytebuffer, boolean block, boolean flip) throws IOException {
        if (flip) {
            bytebuffer.flip();
            this.flipped = true;
        }
        int written = 0;
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            written = this.pool.write(bytebuffer, this.socket, selector, writeTimeout, block);
            while (!this.socket.flush(true, selector, writeTimeout)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        if (block || bytebuffer.remaining() == 0) {
            bytebuffer.clear();
            this.flipped = false;
        }
        return written;
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.addToBB(this.headerBuffer, 0, this.pos);
        }
    }

    private synchronized void addToBB(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        boolean dataLeft = this.flushBuffer(this.isBlocking());
        while (!dataLeft && length > 0) {
            int thisTime = this.transfer(buf, offset, length, this.socket.getBufHandler().getWriteBuffer());
            length -= thisTime;
            offset += thisTime;
            int written = this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), this.isBlocking(), true);
            if (written == 0) {
                dataLeft = true;
                continue;
            }
            dataLeft = this.flushBuffer(this.isBlocking());
        }
        NioEndpoint.KeyAttachment ka = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
        if (ka != null) {
            ka.access();
        }
        if (!this.isBlocking() && length > 0) {
            this.addToBuffers(buf, offset, length);
        }
    }

    private void addToBuffers(byte[] buf, int offset, int length) {
        ByteBufferHolder holder = (ByteBufferHolder)this.bufferedWrites.peekLast();
        if (holder == null || holder.isFlipped() || holder.getBuf().remaining() < length) {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferedWriteSize, length));
            holder = new ByteBufferHolder(buffer, false);
            this.bufferedWrites.add(holder);
        }
        holder.getBuf().put(buf, offset, length);
    }

    @Override
    protected boolean flushBuffer(boolean block) throws IOException {
        boolean dataLeft;
        SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
        if (key != null) {
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)key.attachment();
            attach.access();
        }
        if (dataLeft = this.hasMoreDataToFlush()) {
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), block, !this.flipped);
        }
        if (!(dataLeft = this.hasMoreDataToFlush()) && this.bufferedWrites.size() > 0) {
            Iterator bufIter = this.bufferedWrites.iterator();
            while (!this.hasMoreDataToFlush() && bufIter.hasNext()) {
                ByteBufferHolder buffer = (ByteBufferHolder)bufIter.next();
                buffer.flip();
                while (!this.hasMoreDataToFlush() && buffer.getBuf().remaining() > 0) {
                    this.transfer(buffer.getBuf(), this.socket.getBufHandler().getWriteBuffer());
                    if (buffer.getBuf().remaining() == 0) {
                        bufIter.remove();
                    }
                    this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), block, true);
                }
            }
        }
        return this.hasMoreDataToFlush();
    }

    @Override
    protected boolean hasMoreDataToFlush() {
        return this.flipped && this.socket.getBufHandler().getWriteBuffer().remaining() > 0 || !this.flipped && this.socket.getBufHandler().getWriteBuffer().position() > 0;
    }

    @Override
    protected void registerWriteInterest() throws IOException {
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        att.getPoller().add(this.socket, 4);
    }

    private int transfer(byte[] from, int offset, int length, ByteBuffer to) {
        int max = Math.min(length, to.remaining());
        to.put(from, offset, max);
        return max;
    }

    private void transfer(ByteBuffer from, ByteBuffer to) {
        int max = Math.min(from.remaining(), to.remaining());
        ByteBuffer tmp = from.duplicate();
        tmp.limit(tmp.position() + max);
        to.put(tmp);
        from.position(from.position() + max);
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            try {
                int len = chunk.getLength();
                int start = chunk.getStart();
                byte[] b = chunk.getBuffer();
                InternalNioOutputBuffer.this.addToBB(b, start, len);
                InternalNioOutputBuffer.this.byteCount += (long)chunk.getLength();
                return chunk.getLength();
            }
            catch (IOException ioe) {
                InternalNioOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, ioe);
                throw ioe;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalNioOutputBuffer.this.byteCount;
        }
    }
}

