/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import java.util.Set;
import java.util.Stack;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlFmtTLV
extends JstlBaseTLV {
    private static final String SETLOCALE = "setLocale";
    private static final String SETBUNDLE = "setBundle";
    private static final String SETTIMEZONE = "setTimeZone";
    private static final String BUNDLE = "bundle";
    private static final String MESSAGE = "message";
    private static final String MESSAGE_PARAM = "param";
    private static final String FORMAT_NUMBER = "formatNumber";
    private static final String PARSE_NUMBER = "parseNumber";
    private static final String PARSE_DATE = "parseDate";
    private static final String JSP_TEXT = "jsp:text";
    private static final String EVAL = "evaluator";
    private static final String MESSAGE_KEY = "key";
    private static final String BUNDLE_PREFIX = "prefix";
    private static final String VALUE = "value";

    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        return super.validate(2, prefix, uri, page);
    }

    protected DefaultHandler getHandler() {
        return new Handler();
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack messageDepths = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            Set expAtts;
            if (ln == null) {
                ln = JstlFmtTLV.this.getLocalPart(qn);
            }
            if (qn.equals(JstlFmtTLV.JSP_TEXT)) {
                return;
            }
            if (this.bodyIllegal) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (qn.startsWith(JstlFmtTLV.this.prefix + ":") && (expAtts = (Set)JstlFmtTLV.this.config.get(ln)) != null) {
                for (int i = 0; i < a.getLength(); ++i) {
                    String vMsg;
                    String attName = a.getLocalName(i);
                    if (!expAtts.contains(attName) || (vMsg = JstlFmtTLV.this.validateExpression(ln, attName, a.getValue(i))) == null) continue;
                    JstlFmtTLV.this.fail(vMsg);
                }
            }
            if (qn.startsWith(JstlFmtTLV.this.prefix + ":") && !JstlFmtTLV.this.hasNoInvalidScope(a)) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", qn, a.getValue("scope")));
            }
            if (qn.startsWith(JstlFmtTLV.this.prefix + ":") && JstlFmtTLV.this.hasEmptyVar(a)) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", qn));
            }
            if (qn.startsWith(JstlFmtTLV.this.prefix + ":") && !JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.SETLOCALE) && !JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.SETBUNDLE) && !JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.SETTIMEZONE) && JstlFmtTLV.this.hasDanglingScope(a)) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", qn));
            }
            if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.MESSAGE_PARAM) && this.messageDepths.empty()) {
                JstlFmtTLV.this.fail(Resources.getMessage("PARAM_OUTSIDE_MESSAGE"));
            }
            if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.MESSAGE)) {
                this.messageDepths.push(new Integer(this.depth));
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.MESSAGE_PARAM) || JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.FORMAT_NUMBER) || JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.PARSE_NUMBER) || JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.PARSE_DATE)) {
                if (JstlFmtTLV.this.hasAttribute(a, JstlFmtTLV.VALUE)) {
                    this.bodyIllegal = true;
                } else {
                    this.bodyNecessary = true;
                }
            } else if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.MESSAGE) && !JstlFmtTLV.this.hasAttribute(a, JstlFmtTLV.MESSAGE_KEY)) {
                this.bodyNecessary = true;
            } else if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.BUNDLE) && JstlFmtTLV.this.hasAttribute(a, JstlFmtTLV.BUNDLE_PREFIX)) {
                this.bodyNecessary = true;
            }
            this.lastElementName = qn;
            JstlFmtTLV.this.lastElementId = a.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
        }

        public void endElement(String ns, String ln, String qn) {
            if (qn.equals(JstlFmtTLV.JSP_TEXT)) {
                return;
            }
            if (this.bodyNecessary) {
                JstlFmtTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlFmtTLV.this.isFmtTag(ns, ln, JstlFmtTLV.MESSAGE)) {
                this.messageDepths.pop();
            }
            --this.depth;
        }
    }
}

