/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.ui.WrappingSearchCursor;
import org.openide.util.Lookup;

public class TreePathSearch
extends WrappingSearchCursor<TreePath> {
    private TreeNode root;
    private final ClassIndex ci;
    private final List<Lookup> contexts = new ArrayList<Lookup>();
    private final List<List<SourceClassInfo>> rslts = new ArrayList<List<SourceClassInfo>>();

    protected TreePathSearch(TreeNode treeNode, String string, ClassIndex classIndex) {
        super(string);
        this.ci = classIndex;
        this.root = treeNode;
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            SelectorNode selectorNode = (SelectorNode)enumeration.nextElement();
            this.contexts.add(selectorNode.getLookup());
            this.rslts.add(null);
        }
    }

    @Override
    protected TreePath getItem(int n, int n2) {
        SourceClassInfo sourceClassInfo = this.getSlot(n).get(n2);
        if (sourceClassInfo != null) {
            return this.findPath(sourceClassInfo, n);
        }
        return null;
    }

    @Override
    protected int getSlotSize(int n) {
        return this.getSlot(n).size();
    }

    @Override
    protected int getSlotsNumber() {
        return this.contexts.size();
    }

    private List<SourceClassInfo> getSlot(int n) {
        List<SourceClassInfo> list = this.rslts.get(n);
        if (list == null) {
            String string = ".*" + this.getSearchTerm() + ".*";
            Lookup lookup = this.contexts.get(n);
            list = this.ci.getClasses(string, lookup);
            this.rslts.set(n, list);
        }
        return list;
    }

    private TreePath findPath(SourceClassInfo sourceClassInfo, int n) {
        if (sourceClassInfo == null) {
            return null;
        }
        ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(sourceClassInfo.getQualifiedName() + "$**", null, null);
        SelectorNode selectorNode = this.findNode((SelectorNode)this.root.getChildAt(n), sourceCodeSelection);
        if (selectorNode != null) {
            TreeNode[] treeNodeArray = selectorNode.getPath();
            Object[] objectArray = new Object[treeNodeArray.length + 1];
            objectArray[0] = this.root;
            System.arraycopy(treeNodeArray, 0, objectArray, 1, treeNodeArray.length);
            return new TreePath(objectArray);
        }
        return null;
    }

    private SelectorNode findNode(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ArrayDeque<SelectorNode> arrayDeque = new ArrayDeque<SelectorNode>();
        arrayDeque.add(selectorNode);
        while (!arrayDeque.isEmpty()) {
            if (this.isCancelled()) {
                return null;
            }
            SelectorNode selectorNode2 = (SelectorNode)arrayDeque.poll();
            ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode2.getSignature();
            if (sourceCodeSelection2 != null && sourceCodeSelection2.equals((Object)sourceCodeSelection)) {
                return selectorNode2;
            }
            if (sourceCodeSelection2 != null && !sourceCodeSelection2.contains(sourceCodeSelection)) continue;
            Enumeration enumeration = selectorNode2.children();
            while (enumeration.hasMoreElements()) {
                if (this.isCancelled()) {
                    return null;
                }
                SelectorNode selectorNode3 = (SelectorNode)enumeration.nextElement();
                ClientUtils.SourceCodeSelection sourceCodeSelection3 = selectorNode3.getSignature();
                if (sourceCodeSelection3 != null && sourceCodeSelection3.equals((Object)sourceCodeSelection)) {
                    return selectorNode3;
                }
                if (sourceCodeSelection3 != null && !sourceCodeSelection3.contains(sourceCodeSelection) || selectorNode3 instanceof MethodsNode || selectorNode3 instanceof ConstructorsNode) continue;
                arrayDeque.offer(selectorNode3);
            }
        }
        return null;
    }

    public static interface ClassIndex {
        public List<SourceClassInfo> getClasses(String var1, Lookup var2);
    }
}

